/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.LegacyConnectionFactoryAdaptor;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=JdbcBinaryCacheStoreConfigurationBuilder.class)
public class JdbcBinaryCacheStoreConfiguration
extends AbstractJdbcCacheStoreConfiguration
implements LegacyLoaderAdapter<JdbcBinaryCacheStoreConfig> {
    private final TableManipulationConfiguration table;

    JdbcBinaryCacheStoreConfiguration(TableManipulationConfiguration table, ConnectionFactoryConfiguration connectionFactory, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(connectionFactory, lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.table = table;
    }

    public TableManipulationConfiguration table() {
        return this.table;
    }

    public JdbcBinaryCacheStoreConfig adapt() {
        JdbcBinaryCacheStoreConfig config = new JdbcBinaryCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((CacheStoreConfiguration)this, (CacheStoreConfig)config);
        ((LegacyConnectionFactoryAdaptor)((Object)this.connectionFactory())).adapt(config);
        config.setCreateTableOnStart(this.table.createOnStart());
        config.setDropTableOnExit(this.table.dropOnExit());
        config.setBatchSize(this.table.batchSize());
        config.setFetchSize(this.table.fetchSize());
        config.setDatabaseType(this.table.databaseType());
        config.setCacheName(this.table.cacheName());
        config.setDataColumnName(this.table.dataColumnName());
        config.setDataColumnType(this.table.dataColumnType());
        config.setIdColumnName(this.table.idColumnName());
        config.setIdColumnType(this.table.idColumnType());
        config.setTimestampColumnName(this.table.timestampColumnName());
        config.setTimestampColumnType(this.table.timestampColumnType());
        config.setTableNamePrefix(this.table.tableNamePrefix());
        return config;
    }

    public String toString() {
        return "JdbcBinaryCacheStoreConfiguration [table=" + this.table + ", connectionFactory()=" + this.connectionFactory() + ", lockAcquistionTimeout()=" + this.lockAcquistionTimeout() + ", lockConcurrencyLevel()=" + this.lockConcurrencyLevel() + ", async()=" + this.async() + ", singletonStore()=" + this.singletonStore() + ", purgeOnStartup()=" + this.purgeOnStartup() + ", purgeSynchronously()=" + this.purgeSynchronously() + ", purgerThreads()=" + this.purgerThreads() + ", fetchPersistentState()=" + this.fetchPersistentState() + ", ignoreModifications()=" + this.ignoreModifications() + ", properties()=" + this.properties() + "]";
    }
}

