/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.protostream.builder;

import org.infinispan.api.protostream.builder.FieldBuilder;
import org.infinispan.api.protostream.builder.MessageBuilder;
import org.infinispan.api.protostream.builder.ProtoBuf;

public class IndexedFieldBuilder {
    private final FieldBuilder parent;
    private final String indexing;
    private boolean custom = false;
    private Boolean searchable;
    private Boolean sortable;
    private Boolean projectable;
    private Boolean aggregable;
    private String indexNullAs;
    private String analyzer;
    private String searchAnalyzer;
    private String normalizer;

    public IndexedFieldBuilder(FieldBuilder parent, String indexing) {
        this.parent = parent;
        this.indexing = indexing;
    }

    public MessageBuilder message(String name) {
        return this.parent.message(name);
    }

    public FieldBuilder required(String name, int number, String type) {
        return this.parent.required(name, number, type);
    }

    public FieldBuilder optional(String name, int number, String type) {
        return this.parent.optional(name, number, type);
    }

    public IndexedFieldBuilder searchable(boolean value) {
        this.custom = true;
        this.searchable = value;
        return this;
    }

    public IndexedFieldBuilder sortable(boolean value) {
        this.custom = true;
        this.sortable = value;
        return this;
    }

    public IndexedFieldBuilder projectable(boolean value) {
        this.custom = true;
        this.projectable = value;
        return this;
    }

    public IndexedFieldBuilder aggregable(boolean value) {
        this.custom = true;
        this.aggregable = value;
        return this;
    }

    public IndexedFieldBuilder indexNullAs(String value) {
        this.custom = true;
        this.indexNullAs = value;
        return this;
    }

    public IndexedFieldBuilder analyzer(String value) {
        this.custom = true;
        this.analyzer = value;
        return this;
    }

    public IndexedFieldBuilder searchAnalyzer(String value) {
        this.custom = true;
        this.searchAnalyzer = value;
        return this;
    }

    public IndexedFieldBuilder normalizer(String value) {
        this.custom = true;
        this.normalizer = value;
        return this;
    }

    void write(StringBuilder builder) {
        ProtoBuf.tab(builder);
        builder.append("/**\n");
        ProtoBuf.tab(builder);
        builder.append(" * ");
        builder.append(this.indexing);
        this.writeCustomization(builder);
        builder.append("\n");
        ProtoBuf.tab(builder);
        builder.append(" */\n");
    }

    private void writeCustomization(StringBuilder builder) {
        if (!this.custom) {
            return;
        }
        builder.append("(");
        boolean first = true;
        if (this.searchable != null) {
            this.writeAttribute(builder, "searchable", this.searchable, first);
            first = false;
        }
        if (this.sortable != null) {
            this.writeAttribute(builder, "sortable", this.sortable, first);
            first = false;
        }
        if (this.projectable != null) {
            this.writeAttribute(builder, "projectable", this.projectable, first);
            first = false;
        }
        if (this.aggregable != null) {
            this.writeAttribute(builder, "aggregable", this.aggregable, first);
            first = false;
        }
        if (this.indexNullAs != null) {
            this.writeAttribute(builder, "indexNullAs", this.indexNullAs, first);
            first = false;
        }
        if (this.analyzer != null) {
            this.writeAttribute(builder, "analyzer", this.analyzer, first);
            first = false;
        }
        if (this.searchAnalyzer != null) {
            this.writeAttribute(builder, "searchAnalyzer", this.searchAnalyzer, first);
            first = false;
        }
        if (this.normalizer != null) {
            this.writeAttribute(builder, "normalizer", this.normalizer, first);
        }
        builder.append(")");
    }

    private void writeAttribute(StringBuilder builder, String attribute, Object value, boolean first) {
        if (!first) {
            builder.append(", ");
        }
        builder.append(attribute);
        builder.append("=");
        if (value instanceof String) {
            value = "\"" + String.valueOf(value) + "\"";
        }
        builder.append(value);
    }
}

