/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.$guava$.collect.$Iterators;
import org.immutables.value.internal.$processor$.meta.$ImportsTypeStringResolver;
import org.immutables.value.internal.$processor$.meta.$ObscureFeatures;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$TypeStringProvider;

public final class $Generics
implements Iterable<String> {
    private static final String[] NO_STRINGS = new String[0];
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private static final boolean noDiamonds = $ObscureFeatures.noDiamonds();
    public final String declaration;
    public final String arguments;
    public final String unknown;
    public final Parameter[] parameters;
    private final String[] vars;

    $Generics($Proto.Protoclass protoclass, Element element) {
        this.parameters = $Generics.computeParameters(protoclass, element);
        this.vars = $Generics.computeVars(this.parameters);
        if (this.parameters != NO_PARAMETERS) {
            this.declaration = $Generics.formatParameters(this.parameters, true, false);
            this.arguments = $Generics.formatParameters(this.parameters, false, false);
            this.unknown = $Generics.formatParameters(this.parameters, false, true);
        } else {
            this.declaration = "";
            this.arguments = "";
            this.unknown = "";
        }
    }

    private $Generics() {
        this.parameters = NO_PARAMETERS;
        this.vars = NO_STRINGS;
        this.declaration = "";
        this.arguments = "";
        this.unknown = "";
    }

    public static $Generics empty() {
        return new $Generics();
    }

    private static Parameter[] computeParameters(final $Proto.Protoclass protoclass, final Element element) {
        if (!(element instanceof Parameterizable)) {
            return NO_PARAMETERS;
        }
        final List<? extends TypeParameterElement> typeParameters = ((Parameterizable)element).getTypeParameters();
        if (typeParameters.isEmpty()) {
            return NO_PARAMETERS;
        }
        class Creator {
            final String[] vars;
            final $Proto.DeclaringType declaringType;

            Creator() {
                this.vars = $Generics.collectVars(typeParameters);
                this.declaringType = protoclass.environment().round().inferDeclaringTypeFor(element);
            }

            Parameter[] create() {
                Parameter[] parameters = new Parameter[typeParameters.size()];
                int i = 0;
                for (TypeParameterElement e : typeParameters) {
                    parameters[i] = new Parameter(i, e.getSimpleName().toString(), this.boundsFrom(e));
                    ++i;
                }
                return parameters;
            }

            String[] boundsFrom(TypeParameterElement e) {
                List<? extends TypeMirror> boundMirrors = e.getBounds();
                if (boundMirrors.isEmpty()) {
                    return NO_STRINGS;
                }
                String[] bounds = new String[boundMirrors.size()];
                int c = 0;
                for (TypeMirror typeMirror : boundMirrors) {
                    $TypeStringProvider provider = this.newProvider(typeMirror);
                    provider.process();
                    bounds[c++] = provider.returnTypeName();
                }
                if (bounds.length == 1 && bounds[0].equals(Object.class.getName())) {
                    return NO_STRINGS;
                }
                return bounds;
            }

            $TypeStringProvider newProvider(TypeMirror type) {
                return new $TypeStringProvider(protoclass.report(), element, type, new $ImportsTypeStringResolver(this.declaringType, this.declaringType), this.vars, null);
            }
        }
        return new Creator().create();
    }

    private static String[] collectVars(List<? extends TypeParameterElement> typeParameters) {
        String[] vars = new String[typeParameters.size()];
        int c = 0;
        for (TypeParameterElement typeParameterElement : typeParameters) {
            vars[c++] = typeParameterElement.getSimpleName().toString();
        }
        return vars;
    }

    private static String[] computeVars(Parameter[] paramerters) {
        if (paramerters == NO_PARAMETERS) {
            return NO_STRINGS;
        }
        String[] vars = new String[paramerters.length];
        for (int i = 0; i < paramerters.length; ++i) {
            vars[i] = paramerters[i].var;
        }
        return vars;
    }

    private static String formatParameters(Parameter[] paramerters, boolean outputBounds, boolean unknown) {
        StringBuilder builder = new StringBuilder("<");
        for (Parameter p : paramerters) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(unknown ? "?" : p.var);
            if (!outputBounds) continue;
            $Generics.formatBoundsIfPresent(builder, p);
        }
        return builder.append(">").toString();
    }

    private static void formatBoundsIfPresent(StringBuilder builder, Parameter p) {
        if (p.bounds.length > 0) {
            builder.append(" extends ").append(p.bounds[0]);
            for (int i = 1; i < p.bounds.length; ++i) {
                builder.append(" & ").append(p.bounds[i]);
            }
        }
    }

    @Nullable
    public Parameter get(String var) {
        for (Parameter p : this.parameters) {
            if (!p.var.equals(var)) continue;
            return p;
        }
        return null;
    }

    public boolean hasParameter(String var) {
        return this.get(var) != null;
    }

    public boolean isEmpty() {
        return this.parameters == NO_PARAMETERS;
    }

    public String args() {
        return this.arguments;
    }

    public String spaceAfter() {
        return this.isEmpty() ? "" : this.declaration + " ";
    }

    public String diamond() {
        return this.isEmpty() ? "" : (noDiamonds ? this.args() : "<>");
    }

    public String def() {
        return this.isEmpty() ? "" : " " + this.declaration;
    }

    public String[] vars() {
        return (String[])this.vars.clone();
    }

    public String toString() {
        return this.declaration;
    }

    @Override
    public Iterator<String> iterator() {
        return this.isEmpty() ? Collections.emptyIterator() : $Iterators.forArray(this.vars);
    }

    public static final class Parameter {
        public final String var;
        public final String[] bounds;
        public final int index;

        Parameter(int index, String var, String[] bounds) {
            this.var = var;
            this.index = index;
            this.bounds = bounds;
        }

        public String toString() {
            return this.var;
        }
    }
}

