/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.immutables.value.internal.$guava$.base.$CharMatcher;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.collect.$HashMultiset;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Multiset;
import org.immutables.value.internal.$processor$.meta.$AccessorAttributesCollector;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$FactoryMethodAttributesCollector;
import org.immutables.value.internal.$processor$.meta.$ImmutableMirror;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

public final class $ValueTypeComposer {
    private static final $CharMatcher ATTRIBUTE_NAME_CHARS = $CharMatcher.is('_').or($CharMatcher.inRange('a', 'z')).or($CharMatcher.inRange('A', 'Z')).or($CharMatcher.inRange('0', '9')).precomputed();

    void compose($ValueType type, $Proto.Protoclass protoclass) {
        type.element = protoclass.sourceElement();
        type.immutableFeatures = protoclass.features();
        type.constitution = protoclass.constitution();
        if (protoclass.kind().isFactory()) {
            new $FactoryMethodAttributesCollector(protoclass, type).collect();
        } else if (protoclass.kind().isValue() || protoclass.kind().isModifiable()) {
            ArrayList<String> violations = $Lists.newArrayList();
            if ($ValueTypeComposer.checkAbstractValueType(type.element, violations)) {
                if (protoclass.kind().isValue()) {
                    this.checkForMutableFields(protoclass, (TypeElement)type.element);
                    this.checkForTypeHierarchy(protoclass, type);
                }
                new $AccessorAttributesCollector(protoclass, type).collect();
            } else {
                protoclass.report().error("Value type '%s' %s", protoclass.sourceElement().getSimpleName(), $Joiner.on(", ").join(violations));
            }
            type.detectSerialization();
            type.detectParcelableCreator();
        }
        this.checkAttributeNamesIllegalCharacters(type);
        this.checkAttributeNamesForDuplicates(type, protoclass);
        this.checkConstructability(type);
        this.checkStyleConflicts(type, protoclass);
    }

    private void checkAttributeNamesIllegalCharacters($ValueType type) {
        for ($ValueAttribute a : type.attributes) {
            if (ATTRIBUTE_NAME_CHARS.matchesAllOf(a.name())) continue;
            a.report().warning("Name '%s' contains some unsupported characters (a-z,A-Z,0-9,_ are ok), name formatting might not work as expected", a.name());
        }
    }

    private void checkConstructability($ValueType type) {
        if (!type.isUseBuilder() || type.isUseConstructor()) {
            for ($ValueAttribute a : type.getConstructorExcluded()) {
                if (!a.isMandatory()) continue;
                a.report().error("Attribute '%s' is mandatory and should be a constructor @Value.Parameter when builder is disabled or there are other constructor parameters", a.name());
            }
        }
        if (!type.isUseBuilder() && !type.isUseCopyMethods()) {
            for ($ValueAttribute a : type.getConstructorExcluded()) {
                if (a.isMandatory()) continue;
                a.report().warning("There is no way to initialize '%s' attribute to non-default value. Enable builder=true or copy=true or add it as a constructor @Value.Parameter", a.name());
            }
        }
        if (type.isUseSingleton() && !type.getMandatoryAttributes().isEmpty()) {
            for ($ValueAttribute a : type.getMandatoryAttributes()) {
                a.report().error("Attribute '%s' is mandatory and cannot be used with singleton enabled. Singleton instance require all attributes to have default value, otherwise default instance could not be created", a.name());
            }
        }
    }

    private void checkStyleConflicts($ValueType type, $Proto.Protoclass protoclass) {
        if ((protoclass.features().singleton() || protoclass.features().intern()) && !protoclass.constitution().generics().isEmpty()) {
            protoclass.report().annotationNamed($ImmutableMirror.simpleName()).warning("'singleton' or 'intern' features are automatically turned off when a type have generic parameters", new Object[0]);
        }
        if (protoclass.features().prehash() && protoclass.styles().style().privateNoargConstructor()) {
            protoclass.report().annotationNamed($ImmutableMirror.simpleName()).warning("'prehash' feature is automatically disabled when 'privateNoargConstructor' style is turned on", new Object[0]);
        }
        if (type.isUseConstructor() && protoclass.constitution().factoryOf().isNew()) {
            if (type.isUseValidation()) {
                protoclass.report().annotationNamed($ImmutableMirror.simpleName()).error("Interning, singleton and validation will not work correctly with 'new' constructor configured in style", new Object[0]);
            } else if (type.constitution.isImplementationHidden() && (type.kind().isEnclosing() || type.kind().isNested())) {
                protoclass.report().annotationNamed($ImmutableMirror.simpleName()).error("Enclosing with hidden implementation do not mix with 'new' constructor configured in style", new Object[0]);
            }
        }
    }

    private void checkForTypeHierarchy($Proto.Protoclass protoclass, $ValueType type) {
        $ValueTypeComposer.scanAndReportInvalidInheritance(protoclass, type.element, type.extendedClasses());
        $ValueTypeComposer.scanAndReportInvalidInheritance(protoclass, type.element, type.implementedInterfaces());
    }

    private static void scanAndReportInvalidInheritance($Proto.Protoclass protoclass, Element element, Iterable<TypeElement> supertypes) {
        for (TypeElement s : supertypes) {
            if ($CachingElements.equals(element, s) || !$ImmutableMirror.isPresent(s)) continue;
            protoclass.report().error("Should not inherit %s which is a value type itself. Avoid extending from another abstract value type. Better to share common abstract class or interface which are not carrying @%s annotation", s, $ImmutableMirror.simpleName());
        }
    }

    private void checkForMutableFields($Proto.Protoclass protoclass, TypeElement element) {
        Elements elementUtils = protoclass.environment().processing().getElementUtils();
        for (VariableElement field : ElementFilter.fieldsIn(elementUtils.getAllMembers($CachingElements.getDelegate(element)))) {
            if (field.getModifiers().contains((Object)Modifier.FINAL)) continue;
            $Reporter report = protoclass.report();
            boolean ownField = $CachingElements.equals(element, field.getEnclosingElement());
            if (ownField) {
                report.withElement(field).warning("Avoid introduction of fields (except constants) in abstract value types", new Object[0]);
                continue;
            }
            report.warning("Abstract value type inherits mutable fields", new Object[0]);
        }
    }

    private void checkAttributeNamesForDuplicates($ValueType type, $Proto.Protoclass protoclass) {
        if (!type.attributes.isEmpty()) {
            $HashMultiset<String> attributeNames = $HashMultiset.create(type.attributes.size());
            for ($ValueAttribute attribute : type.attributes) {
                attributeNames.add(attribute.name());
            }
            ArrayList duplicates = $Lists.newArrayList();
            for ($Multiset.Entry entry : attributeNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                duplicates.add(entry.getElement());
            }
            if (!duplicates.isEmpty()) {
                protoclass.report().error("Duplicate attribute names %s. You should check if correct @Value.Style applied", duplicates);
            }
        }
    }

    static boolean checkAbstractValueType(Element element, Collection<String> violations) {
        boolean publicOrPackageVisible;
        boolean ofSupportedKind = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE || element.getKind() == ElementKind.CLASS;
        boolean staticOrTopLevel = element.getEnclosingElement().getKind() == ElementKind.PACKAGE || element.getModifiers().contains((Object)Modifier.STATIC);
        boolean nonFinal = !element.getModifiers().contains((Object)Modifier.FINAL);
        boolean bl = publicOrPackageVisible = !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.PROTECTED);
        if (!ofSupportedKind) {
            violations.add("must be class or interface or annotation type");
        }
        if (!nonFinal) {
            violations.add("must be non-final");
        }
        if (!publicOrPackageVisible) {
            violations.add("should be public or package-visible");
        }
        if (!staticOrTopLevel) {
            violations.add("should be top-level or static inner class");
        }
        return violations.isEmpty();
    }
}

