/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.encode.$EncodedElement;
import org.immutables.value.internal.$processor$.encode.$EncodingInfo;
import org.immutables.value.internal.$processor$.encode.$Type;

@ParametersAreNonnullByDefault
@Immutable
final class $ImmutableEncodingInfo
extends $EncodingInfo {
    private final String name;
    private final $ImmutableSet<String> imports;
    private final $Type.Parameters typeParameters;
    private final $Type.Factory typeFactory;
    private final $ImmutableList<$EncodedElement> element;
    @Nullable
    private final $EncodedElement builderCopy;
    private final $EncodedElement from;
    private final $EncodedElement impl;
    private final $EncodedElement build;
    private final $EncodedElement equals;
    private final $EncodedElement hash;
    private final $EncodedElement string;
    private final $ImmutableSet<String> crossReferencedMethods;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private $ImmutableEncodingInfo(String name, $ImmutableSet<String> imports, $Type.Parameters typeParameters, $Type.Factory typeFactory, $ImmutableList<$EncodedElement> element) {
        this.name = name;
        this.imports = imports;
        this.typeParameters = typeParameters;
        this.typeFactory = typeFactory;
        this.element = element;
        this.builderCopy = this.initShim.builderCopy();
        this.from = this.initShim.from();
        this.impl = this.initShim.impl();
        this.build = this.initShim.build();
        this.equals = this.initShim.equals();
        this.hash = this.initShim.hash();
        this.string = this.initShim.string();
        this.crossReferencedMethods = this.initShim.crossReferencedMethods();
        this.initShim = null;
    }

    @Override
    String name() {
        return this.name;
    }

    $ImmutableSet<String> imports() {
        return this.imports;
    }

    @Override
    $Type.Parameters typeParameters() {
        return this.typeParameters;
    }

    @Override
    $Type.Factory typeFactory() {
        return this.typeFactory;
    }

    $ImmutableList<$EncodedElement> element() {
        return this.element;
    }

    @Override
    @Nullable
    public $EncodedElement builderCopy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.builderCopy() : this.builderCopy;
    }

    @Override
    public $EncodedElement from() {
        InitShim shim = this.initShim;
        return shim != null ? shim.from() : this.from;
    }

    @Override
    public $EncodedElement impl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.impl() : this.impl;
    }

    @Override
    public $EncodedElement build() {
        InitShim shim = this.initShim;
        return shim != null ? shim.build() : this.build;
    }

    @Override
    public $EncodedElement equals() {
        InitShim shim = this.initShim;
        return shim != null ? shim.equals() : this.equals;
    }

    @Override
    public $EncodedElement hash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hash() : this.hash;
    }

    @Override
    public $EncodedElement string() {
        InitShim shim = this.initShim;
        return shim != null ? shim.string() : this.string;
    }

    @Override
    $ImmutableSet<String> crossReferencedMethods() {
        InitShim shim = this.initShim;
        return shim != null ? shim.crossReferencedMethods() : this.crossReferencedMethods;
    }

    public final $ImmutableEncodingInfo withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = $Preconditions.checkNotNull(name, "name");
        return new $ImmutableEncodingInfo(newValue, this.imports, this.typeParameters, this.typeFactory, this.element);
    }

    public final $ImmutableEncodingInfo withImports(String ... elements) {
        $ImmutableSet<String> newValue = $ImmutableSet.copyOf(elements);
        return new $ImmutableEncodingInfo(this.name, newValue, this.typeParameters, this.typeFactory, this.element);
    }

    public final $ImmutableEncodingInfo withImports(Iterable<String> elements) {
        if (this.imports == elements) {
            return this;
        }
        $ImmutableSet<String> newValue = $ImmutableSet.copyOf(elements);
        return new $ImmutableEncodingInfo(this.name, newValue, this.typeParameters, this.typeFactory, this.element);
    }

    public final $ImmutableEncodingInfo withTypeParameters($Type.Parameters typeParameters) {
        if (this.typeParameters == typeParameters) {
            return this;
        }
        $Type.Parameters newValue = $Preconditions.checkNotNull(typeParameters, "typeParameters");
        return new $ImmutableEncodingInfo(this.name, this.imports, newValue, this.typeFactory, this.element);
    }

    public final $ImmutableEncodingInfo withTypeFactory($Type.Factory typeFactory) {
        if (this.typeFactory == typeFactory) {
            return this;
        }
        $Type.Factory newValue = $Preconditions.checkNotNull(typeFactory, "typeFactory");
        return new $ImmutableEncodingInfo(this.name, this.imports, this.typeParameters, newValue, this.element);
    }

    public final $ImmutableEncodingInfo withElement($EncodedElement ... elements) {
        $ImmutableList<$EncodedElement> newValue = $ImmutableList.copyOf(elements);
        return new $ImmutableEncodingInfo(this.name, this.imports, this.typeParameters, this.typeFactory, newValue);
    }

    public final $ImmutableEncodingInfo withElement(Iterable<? extends $EncodedElement> elements) {
        if (this.element == elements) {
            return this;
        }
        $ImmutableList<$EncodedElement> newValue = $ImmutableList.copyOf(elements);
        return new $ImmutableEncodingInfo(this.name, this.imports, this.typeParameters, this.typeFactory, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof $ImmutableEncodingInfo && this.equalTo(($ImmutableEncodingInfo)another);
    }

    private boolean equalTo($ImmutableEncodingInfo another) {
        return this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        return h;
    }

    public String toString() {
        return $MoreObjects.toStringHelper("EncodingInfo").omitNullValues().add("name", this.name).toString();
    }

    public static $EncodingInfo copyOf($EncodingInfo instance) {
        if (instance instanceof $ImmutableEncodingInfo) {
            return ($ImmutableEncodingInfo)instance;
        }
        return new $EncodingInfo.Builder().name(instance.name()).addAllImports(instance.imports()).typeParameters(instance.typeParameters()).typeFactory(instance.typeFactory()).addAllElement(instance.element()).build();
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE_PARAMETERS = 2L;
        private static final long INIT_BIT_TYPE_FACTORY = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        private $ImmutableSet.Builder<String> imports = $ImmutableSet.builder();
        @Nullable
        private $Type.Parameters typeParameters;
        @Nullable
        private $Type.Factory typeFactory;
        private $ImmutableList.Builder<$EncodedElement> element = $ImmutableList.builder();

        Builder() {
            if (!(this instanceof $EncodingInfo.Builder)) {
                throw new UnsupportedOperationException("Use: new EncodingInfo.Builder()");
            }
        }

        public final $EncodingInfo.Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = $Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder addImports(String element) {
            this.imports.add((Object)element);
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder addImports(String ... elements) {
            this.imports.add(elements);
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder addAllImports(Iterable<String> elements) {
            this.imports.addAll((Iterable)elements);
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder typeParameters($Type.Parameters typeParameters) {
            this.checkNotIsSet(this.typeParametersIsSet(), "typeParameters");
            this.typeParameters = $Preconditions.checkNotNull(typeParameters, "typeParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder typeFactory($Type.Factory typeFactory) {
            this.checkNotIsSet(this.typeFactoryIsSet(), "typeFactory");
            this.typeFactory = $Preconditions.checkNotNull(typeFactory, "typeFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder addElement($EncodedElement element) {
            this.element.add((Object)element);
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder addElement($EncodedElement ... elements) {
            this.element.add(elements);
            return ($EncodingInfo.Builder)this;
        }

        public final $EncodingInfo.Builder addAllElement(Iterable<? extends $EncodedElement> elements) {
            this.element.addAll(elements);
            return ($EncodingInfo.Builder)this;
        }

        public $EncodingInfo build() {
            this.checkRequiredAttributes();
            return new $ImmutableEncodingInfo(this.name, ($ImmutableSet)this.imports.build(), this.typeParameters, this.typeFactory, ($ImmutableList)this.element.build());
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeParametersIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeFactoryIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of EncodingInfo is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = $Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeParametersIsSet()) {
                attributes.add("typeParameters");
            }
            if (!this.typeFactoryIsSet()) {
                attributes.add("typeFactory");
            }
            return "Cannot build EncodingInfo, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private $EncodedElement builderCopy;
        private int builderCopyStage;
        private $EncodedElement from;
        private int fromStage;
        private $EncodedElement impl;
        private int implStage;
        private $EncodedElement build;
        private int buildStage;
        private $EncodedElement equals;
        private int equalsStage;
        private $EncodedElement hash;
        private int hashStage;
        private $EncodedElement string;
        private int stringStage;
        private $ImmutableSet<String> crossReferencedMethods;
        private int crossReferencedMethodsStage;

        private InitShim() {
        }

        $EncodedElement builderCopy() {
            if (this.builderCopyStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.builderCopyStage == 0) {
                this.builderCopyStage = -1;
                this.builderCopy = $ImmutableEncodingInfo.super.builderCopy();
                this.builderCopyStage = 1;
            }
            return this.builderCopy;
        }

        $EncodedElement from() {
            if (this.fromStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromStage == 0) {
                this.fromStage = -1;
                this.from = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.from(), "from");
                this.fromStage = 1;
            }
            return this.from;
        }

        $EncodedElement impl() {
            if (this.implStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.implStage == 0) {
                this.implStage = -1;
                this.impl = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.impl(), "impl");
                this.implStage = 1;
            }
            return this.impl;
        }

        $EncodedElement build() {
            if (this.buildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.buildStage == 0) {
                this.buildStage = -1;
                this.build = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.build(), "build");
                this.buildStage = 1;
            }
            return this.build;
        }

        $EncodedElement equals() {
            if (this.equalsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.equalsStage == 0) {
                this.equalsStage = -1;
                this.equals = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.equals(), "equals");
                this.equalsStage = 1;
            }
            return this.equals;
        }

        $EncodedElement hash() {
            if (this.hashStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hashStage == 0) {
                this.hashStage = -1;
                this.hash = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.hash(), "hash");
                this.hashStage = 1;
            }
            return this.hash;
        }

        $EncodedElement string() {
            if (this.stringStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stringStage == 0) {
                this.stringStage = -1;
                this.string = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.string(), "string");
                this.stringStage = 1;
            }
            return this.string;
        }

        $ImmutableSet<String> crossReferencedMethods() {
            if (this.crossReferencedMethodsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.crossReferencedMethodsStage == 0) {
                this.crossReferencedMethodsStage = -1;
                this.crossReferencedMethods = $Preconditions.checkNotNull($ImmutableEncodingInfo.super.crossReferencedMethods(), "crossReferencedMethods");
                this.crossReferencedMethodsStage = 1;
            }
            return this.crossReferencedMethods;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = $Lists.newArrayList();
            if (this.builderCopyStage == -1) {
                attributes.add("builderCopy");
            }
            if (this.fromStage == -1) {
                attributes.add("from");
            }
            if (this.implStage == -1) {
                attributes.add("impl");
            }
            if (this.buildStage == -1) {
                attributes.add("build");
            }
            if (this.equalsStage == -1) {
                attributes.add("equals");
            }
            if (this.hashStage == -1) {
                attributes.add("hash");
            }
            if (this.stringStage == -1) {
                attributes.add("string");
            }
            if (this.crossReferencedMethodsStage == -1) {
                attributes.add("crossReferencedMethods");
            }
            return "Cannot build EncodingInfo, attribute initializers form cycle" + attributes;
        }
    }
}

