/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.with.ForEquals;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ForEquals", generator="Immutables")
@Immutable
public final class ImmutableForEquals
extends ForEquals {
    private final int myInt;
    @Nullable
    private final Integer myOptionalInt;
    private final ImmutableList<Integer> myIntList;
    private final BigDecimal myBigDecimal;
    @Nullable
    private final BigDecimal myOptionalBigDecimal;
    private final ImmutableList<BigDecimal> myBigDecimalList;
    private final RoundingMode myRoundingMode;
    @Nullable
    private final RoundingMode myOptionalRoundingMode;
    private final ImmutableList<RoundingMode> myRoundingModeList;
    private final Object myObject;
    @Nullable
    private final Object myOptionalObject;
    private final ImmutableList<Object> myObjectList;

    private ImmutableForEquals(int myInt, @Nullable Integer myOptionalInt, ImmutableList<Integer> myIntList, BigDecimal myBigDecimal, @Nullable BigDecimal myOptionalBigDecimal, ImmutableList<BigDecimal> myBigDecimalList, RoundingMode myRoundingMode, @Nullable RoundingMode myOptionalRoundingMode, ImmutableList<RoundingMode> myRoundingModeList, Object myObject, @Nullable Object myOptionalObject, ImmutableList<Object> myObjectList) {
        this.myInt = myInt;
        this.myOptionalInt = myOptionalInt;
        this.myIntList = myIntList;
        this.myBigDecimal = myBigDecimal;
        this.myOptionalBigDecimal = myOptionalBigDecimal;
        this.myBigDecimalList = myBigDecimalList;
        this.myRoundingMode = myRoundingMode;
        this.myOptionalRoundingMode = myOptionalRoundingMode;
        this.myRoundingModeList = myRoundingModeList;
        this.myObject = myObject;
        this.myOptionalObject = myOptionalObject;
        this.myObjectList = myObjectList;
    }

    @Override
    public int myInt() {
        return this.myInt;
    }

    @Override
    public Optional<Integer> myOptionalInt() {
        return Optional.ofNullable(this.myOptionalInt);
    }

    public ImmutableList<Integer> myIntList() {
        return this.myIntList;
    }

    @Override
    public BigDecimal myBigDecimal() {
        return this.myBigDecimal;
    }

    @Override
    public Optional<BigDecimal> myOptionalBigDecimal() {
        return Optional.ofNullable(this.myOptionalBigDecimal);
    }

    public ImmutableList<BigDecimal> myBigDecimalList() {
        return this.myBigDecimalList;
    }

    @Override
    public RoundingMode myRoundingMode() {
        return this.myRoundingMode;
    }

    @Override
    public Optional<RoundingMode> myOptionalRoundingMode() {
        return Optional.ofNullable(this.myOptionalRoundingMode);
    }

    public ImmutableList<RoundingMode> myRoundingModeList() {
        return this.myRoundingModeList;
    }

    @Override
    public Object myObject() {
        return this.myObject;
    }

    @Override
    public Optional<Object> myOptionalObject() {
        return Optional.ofNullable(this.myOptionalObject);
    }

    public ImmutableList<Object> myObjectList() {
        return this.myObjectList;
    }

    public final ImmutableForEquals withMyInt(int value) {
        if (this.myInt == value) {
            return this;
        }
        return new ImmutableForEquals(value, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalInt(int value) {
        Integer newValue = value;
        if (Objects.equals(this.myOptionalInt, newValue)) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, newValue, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalInt(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.myOptionalInt, value)) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, value, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyIntList(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, (ImmutableList<Integer>)newValue, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyIntList(Iterable<Integer> elements) {
        if (this.myIntList == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, (ImmutableList<Integer>)newValue, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyBigDecimal(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "myBigDecimal");
        if (this.myBigDecimal.equals(newValue)) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, newValue, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalBigDecimal(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "myOptionalBigDecimal");
        if (Objects.equals(this.myOptionalBigDecimal, newValue)) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, newValue, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalBigDecimal(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.myOptionalBigDecimal, value)) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, value, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyBigDecimalList(BigDecimal ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, (ImmutableList<BigDecimal>)newValue, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyBigDecimalList(Iterable<? extends BigDecimal> elements) {
        if (this.myBigDecimalList == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, (ImmutableList<BigDecimal>)newValue, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyRoundingMode(RoundingMode value) {
        RoundingMode newValue = Objects.requireNonNull(value, "myRoundingMode");
        if (this.myRoundingMode == newValue) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, newValue, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalRoundingMode(RoundingMode value) {
        RoundingMode newValue = Objects.requireNonNull(value, "myOptionalRoundingMode");
        if (this.myOptionalRoundingMode == newValue) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, newValue, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalRoundingMode(Optional<? extends RoundingMode> optional) {
        RoundingMode value = optional.orElse(null);
        if (this.myOptionalRoundingMode == value) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, value, this.myRoundingModeList, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyRoundingModeList(RoundingMode ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, (ImmutableList<RoundingMode>)newValue, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyRoundingModeList(Iterable<? extends RoundingMode> elements) {
        if (this.myRoundingModeList == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, (ImmutableList<RoundingMode>)newValue, this.myObject, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyObject(Object value) {
        if (this.myObject == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "myObject");
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, newValue, this.myOptionalObject, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalObject(Object value) {
        Object newValue = Objects.requireNonNull(value, "myOptionalObject");
        if (this.myOptionalObject == newValue) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, newValue, this.myObjectList);
    }

    public final ImmutableForEquals withMyOptionalObject(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.myOptionalObject == value) {
            return this;
        }
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, value, this.myObjectList);
    }

    public final ImmutableForEquals withMyObjectList(Object ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, (ImmutableList<Object>)newValue);
    }

    public final ImmutableForEquals withMyObjectList(Iterable<? extends Object> elements) {
        if (this.myObjectList == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList, this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList, this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList, this.myObject, this.myOptionalObject, (ImmutableList<Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableForEquals && this.equalTo(0, (ImmutableForEquals)another);
    }

    private boolean equalTo(int synthetic, ImmutableForEquals another) {
        return this.myInt == another.myInt && Objects.equals(this.myOptionalInt, another.myOptionalInt) && this.myIntList.equals(another.myIntList) && this.myBigDecimal.equals(another.myBigDecimal) && Objects.equals(this.myOptionalBigDecimal, another.myOptionalBigDecimal) && this.myBigDecimalList.equals(another.myBigDecimalList) && this.myRoundingMode.equals((Object)another.myRoundingMode) && Objects.equals((Object)this.myOptionalRoundingMode, (Object)another.myOptionalRoundingMode) && this.myRoundingModeList.equals(another.myRoundingModeList) && this.myObject.equals(another.myObject) && Objects.equals(this.myOptionalObject, another.myOptionalObject) && this.myObjectList.equals(another.myObjectList);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.myInt;
        h += (h << 5) + Objects.hashCode(this.myOptionalInt);
        h += (h << 5) + this.myIntList.hashCode();
        h += (h << 5) + this.myBigDecimal.hashCode();
        h += (h << 5) + Objects.hashCode(this.myOptionalBigDecimal);
        h += (h << 5) + this.myBigDecimalList.hashCode();
        h += (h << 5) + this.myRoundingMode.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.myOptionalRoundingMode);
        h += (h << 5) + this.myRoundingModeList.hashCode();
        h += (h << 5) + this.myObject.hashCode();
        h += (h << 5) + Objects.hashCode(this.myOptionalObject);
        h += (h << 5) + this.myObjectList.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ForEquals").omitNullValues().add("myInt", this.myInt).add("myOptionalInt", (Object)this.myOptionalInt).add("myIntList", this.myIntList).add("myBigDecimal", (Object)this.myBigDecimal).add("myOptionalBigDecimal", (Object)this.myOptionalBigDecimal).add("myBigDecimalList", this.myBigDecimalList).add("myRoundingMode", (Object)this.myRoundingMode).add("myOptionalRoundingMode", (Object)this.myOptionalRoundingMode).add("myRoundingModeList", this.myRoundingModeList).add("myObject", this.myObject).add("myOptionalObject", this.myOptionalObject).add("myObjectList", this.myObjectList).toString();
    }

    public static ImmutableForEquals copyOf(ForEquals instance) {
        if (instance instanceof ImmutableForEquals) {
            return (ImmutableForEquals)instance;
        }
        return ImmutableForEquals.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ForEquals", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MY_INT = 1L;
        private static final long INIT_BIT_MY_BIG_DECIMAL = 2L;
        private static final long INIT_BIT_MY_ROUNDING_MODE = 4L;
        private static final long INIT_BIT_MY_OBJECT = 8L;
        private long initBits = 15L;
        private int myInt;
        @Nullable
        private Integer myOptionalInt;
        private ImmutableList.Builder<Integer> myIntList = ImmutableList.builder();
        @Nullable
        private BigDecimal myBigDecimal;
        @Nullable
        private BigDecimal myOptionalBigDecimal;
        private ImmutableList.Builder<BigDecimal> myBigDecimalList = ImmutableList.builder();
        @Nullable
        private RoundingMode myRoundingMode;
        @Nullable
        private RoundingMode myOptionalRoundingMode;
        private ImmutableList.Builder<RoundingMode> myRoundingModeList = ImmutableList.builder();
        @Nullable
        private Object myObject;
        @Nullable
        private Object myOptionalObject;
        private ImmutableList.Builder<Object> myObjectList = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ForEquals instance) {
            Objects.requireNonNull(instance, "instance");
            this.myInt(instance.myInt());
            Optional<Integer> myOptionalIntOptional = instance.myOptionalInt();
            if (myOptionalIntOptional.isPresent()) {
                this.myOptionalInt(myOptionalIntOptional);
            }
            this.addAllMyIntList(instance.myIntList());
            this.myBigDecimal(instance.myBigDecimal());
            Optional<BigDecimal> myOptionalBigDecimalOptional = instance.myOptionalBigDecimal();
            if (myOptionalBigDecimalOptional.isPresent()) {
                this.myOptionalBigDecimal(myOptionalBigDecimalOptional);
            }
            this.addAllMyBigDecimalList(instance.myBigDecimalList());
            this.myRoundingMode(instance.myRoundingMode());
            Optional<RoundingMode> myOptionalRoundingModeOptional = instance.myOptionalRoundingMode();
            if (myOptionalRoundingModeOptional.isPresent()) {
                this.myOptionalRoundingMode(myOptionalRoundingModeOptional);
            }
            this.addAllMyRoundingModeList(instance.myRoundingModeList());
            this.myObject(instance.myObject());
            Optional<Object> myOptionalObjectOptional = instance.myOptionalObject();
            if (myOptionalObjectOptional.isPresent()) {
                this.myOptionalObject(myOptionalObjectOptional);
            }
            this.addAllMyObjectList(instance.myObjectList());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myInt(int myInt) {
            this.myInt = myInt;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalInt(int myOptionalInt) {
            this.myOptionalInt = myOptionalInt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalInt(Optional<Integer> myOptionalInt) {
            this.myOptionalInt = myOptionalInt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyIntList(int element) {
            this.myIntList.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyIntList(int ... elements) {
            this.myIntList.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myIntList(Iterable<Integer> elements) {
            this.myIntList = ImmutableList.builder();
            return this.addAllMyIntList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMyIntList(Iterable<Integer> elements) {
            this.myIntList.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myBigDecimal(BigDecimal myBigDecimal) {
            this.myBigDecimal = Objects.requireNonNull(myBigDecimal, "myBigDecimal");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalBigDecimal(BigDecimal myOptionalBigDecimal) {
            this.myOptionalBigDecimal = Objects.requireNonNull(myOptionalBigDecimal, "myOptionalBigDecimal");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalBigDecimal(Optional<? extends BigDecimal> myOptionalBigDecimal) {
            this.myOptionalBigDecimal = myOptionalBigDecimal.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyBigDecimalList(BigDecimal element) {
            this.myBigDecimalList.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyBigDecimalList(BigDecimal ... elements) {
            this.myBigDecimalList.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myBigDecimalList(Iterable<? extends BigDecimal> elements) {
            this.myBigDecimalList = ImmutableList.builder();
            return this.addAllMyBigDecimalList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMyBigDecimalList(Iterable<? extends BigDecimal> elements) {
            this.myBigDecimalList.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myRoundingMode(RoundingMode myRoundingMode) {
            this.myRoundingMode = Objects.requireNonNull(myRoundingMode, "myRoundingMode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalRoundingMode(RoundingMode myOptionalRoundingMode) {
            this.myOptionalRoundingMode = Objects.requireNonNull(myOptionalRoundingMode, "myOptionalRoundingMode");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalRoundingMode(Optional<? extends RoundingMode> myOptionalRoundingMode) {
            this.myOptionalRoundingMode = myOptionalRoundingMode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyRoundingModeList(RoundingMode element) {
            this.myRoundingModeList.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyRoundingModeList(RoundingMode ... elements) {
            this.myRoundingModeList.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myRoundingModeList(Iterable<? extends RoundingMode> elements) {
            this.myRoundingModeList = ImmutableList.builder();
            return this.addAllMyRoundingModeList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMyRoundingModeList(Iterable<? extends RoundingMode> elements) {
            this.myRoundingModeList.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myObject(Object myObject) {
            this.myObject = Objects.requireNonNull(myObject, "myObject");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalObject(Object myOptionalObject) {
            this.myOptionalObject = Objects.requireNonNull(myOptionalObject, "myOptionalObject");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myOptionalObject(Optional<? extends Object> myOptionalObject) {
            this.myOptionalObject = myOptionalObject.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyObjectList(Object element) {
            this.myObjectList.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMyObjectList(Object ... elements) {
            this.myObjectList.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder myObjectList(Iterable<? extends Object> elements) {
            this.myObjectList = ImmutableList.builder();
            return this.addAllMyObjectList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMyObjectList(Iterable<? extends Object> elements) {
            this.myObjectList.addAll(elements);
            return this;
        }

        public ImmutableForEquals build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableForEquals(this.myInt, this.myOptionalInt, this.myIntList.build(), this.myBigDecimal, this.myOptionalBigDecimal, this.myBigDecimalList.build(), this.myRoundingMode, this.myOptionalRoundingMode, this.myRoundingModeList.build(), this.myObject, this.myOptionalObject, this.myObjectList.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("myInt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("myBigDecimal");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("myRoundingMode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("myObject");
            }
            return "Cannot build ForEquals, some of required attributes are not set " + attributes;
        }
    }
}

