/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.with;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.with.Enc;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Enc", generator="Immutables")
public final class ImmutableEnc {
    private ImmutableEnc() {
    }

    @Generated(from="Enc.Suppied", generator="Immutables")
    public static interface WithSuppied<T extends Number> {
        public Enc.Suppied<T> withA(String var1);

        public Enc.Suppied<T> withNum(T var1);

        public Enc.Suppied<T> withMm(Multimap<String, ? extends T> var1);

        public Enc.Suppied<T> withOpt(T var1);

        public Enc.Suppied<T> withOpt(Optional<? extends T> var1);

        public Enc.Suppied<T> withArray(int ... var1);

        public Enc.Suppied<T> withNularr(String ... var1);
    }

    @CheckReturnValue
    @Generated(from="Enc.Suppied", generator="Immutables")
    @Immutable
    public static final class Suppied<T extends Number>
    implements Enc.Suppied<T> {
        private final String a;
        private final T num;
        private final ImmutableMultimap<String, T> mm;
        @Nullable
        private final T opt;
        private final int[] array;
        @Nullable
        private final String[] nularr;

        private Suppied(String a, T num, ImmutableMultimap<String, T> mm, @Nullable T opt, int[] array, @Nullable String[] nularr) {
            this.a = a;
            this.num = num;
            this.mm = mm;
            this.opt = opt;
            this.array = array;
            this.nularr = nularr;
        }

        @Override
        @JsonProperty(value="a")
        public String a() {
            return this.a;
        }

        @Override
        @JsonProperty(value="num")
        public T num() {
            return this.num;
        }

        @Override
        @JsonProperty(value="mm")
        public ImmutableMultimap<String, T> mm() {
            return this.mm;
        }

        @Override
        @JsonProperty(value="opt")
        public Optional<T> opt() {
            return Optional.ofNullable(this.opt);
        }

        @Override
        @JsonProperty(value="array")
        public int[] array() {
            return (int[])this.array.clone();
        }

        @Override
        @JsonProperty(value="nularr")
        @Nullable
        public String[] nularr() {
            return this.nularr;
        }

        @Override
        public final Suppied<T> withA(String value) {
            String newValue = Objects.requireNonNull(value, "a");
            if (this.a.equals(newValue)) {
                return this;
            }
            return new Suppied<T>(newValue, this.num, this.mm, this.opt, this.array, this.nularr);
        }

        @Override
        public final Suppied<T> withNum(T value) {
            if (this.num == value) {
                return this;
            }
            Number newValue = (Number)Objects.requireNonNull(value, "num");
            return new Suppied<Number>(this.a, newValue, (ImmutableMultimap<String, Number>)this.mm, (Number)this.opt, this.array, this.nularr);
        }

        @Override
        public final Suppied<T> withMm(Multimap<String, ? extends T> entries) {
            if (this.mm == entries) {
                return this;
            }
            ImmutableMultimap newValue = ImmutableMultimap.copyOf(entries);
            return new Suppied<T>(this.a, this.num, newValue, this.opt, this.array, this.nularr);
        }

        @Override
        public final Suppied<T> withOpt(T value) {
            Number newValue = (Number)Objects.requireNonNull(value, "opt");
            if (this.opt == newValue) {
                return this;
            }
            return new Suppied<Number>(this.a, (Number)this.num, (ImmutableMultimap<String, Number>)this.mm, newValue, this.array, this.nularr);
        }

        @Override
        public final Suppied<T> withOpt(Optional<? extends T> optional) {
            Number value = optional.orElse(null);
            if (this.opt == value) {
                return this;
            }
            return new Suppied<Number>(this.a, (Number)this.num, (ImmutableMultimap<String, Number>)this.mm, value, this.array, this.nularr);
        }

        @Override
        public final Suppied<T> withArray(int ... elements) {
            int[] newValue = (int[])elements.clone();
            return new Suppied<T>(this.a, this.num, this.mm, this.opt, newValue, this.nularr);
        }

        @Override
        public final Suppied<T> withNularr(String ... elements) {
            String[] newValue = elements == null ? null : (String[])elements.clone();
            return new Suppied<T>(this.a, this.num, this.mm, this.opt, this.array, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Suppied && this.equalTo(0, (Suppied)another);
        }

        private boolean equalTo(int synthetic, Suppied<?> another) {
            return this.a.equals(another.a) && this.num.equals(another.num) && this.mm.equals(another.mm) && Objects.equals(this.opt, another.opt) && Arrays.equals(this.array, another.array) && Arrays.equals(this.nularr, another.nularr);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.a.hashCode();
            h += (h << 5) + this.num.hashCode();
            h += (h << 5) + this.mm.hashCode();
            h += (h << 5) + Objects.hashCode(this.opt);
            h += (h << 5) + Arrays.hashCode(this.array);
            h += (h << 5) + Arrays.hashCode(this.nularr);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Suppied").omitNullValues().add("a", (Object)this.a).add("num", this.num).add("mm", this.mm).add("opt", this.opt).add("array", (Object)Arrays.toString(this.array)).add("nularr", (Object)Arrays.toString(this.nularr)).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static <T extends Number> Suppied<T> fromJson(Json<T> json) {
            Enc.Suppied.Builder builder = new Enc.Suppied.Builder();
            if (json.a != null) {
                builder.a(json.a);
            }
            if (json.num != null) {
                builder.num(json.num);
            }
            if (json.mm != null) {
                builder.putAllMm(json.mm);
            }
            if (json.opt != null) {
                builder.opt(json.opt);
            }
            if (json.array != null) {
                builder.array(json.array);
            }
            if (json.nularr != null) {
                builder.nularr(json.nularr);
            }
            return builder.build();
        }

        /* synthetic */ Suppied(String x0, Number x1, ImmutableMultimap x2, Number x3, int[] x4, String[] x5, 1 x6) {
            this(x0, x1, x2, x3, x4, x5);
        }

        @Generated(from="Enc.Suppied", generator="Immutables")
        @NotThreadSafe
        public static class Builder<T extends Number> {
            private static final long INIT_BIT_A = 1L;
            private static final long INIT_BIT_NUM = 2L;
            private static final long INIT_BIT_ARRAY = 4L;
            private long initBits = 7L;
            @Nullable
            private String a;
            @Nullable
            private T num;
            private ImmutableMultimap.Builder<String, T> mm = ImmutableMultimap.builder();
            @Nullable
            private T opt;
            @Nullable
            private int[] array;
            @Nullable
            private String[] nularr;

            public Builder() {
                if (!(this instanceof Enc.Suppied.Builder)) {
                    throw new UnsupportedOperationException("Use: new Enc.Suppied.Builder<T>()");
                }
            }

            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> from(Enc.Suppied<T> instance) {
                Objects.requireNonNull(instance, "instance");
                this.a(instance.a());
                this.num(instance.num());
                this.putAllMm(instance.mm());
                Optional<T> optOptional = instance.opt();
                if (optOptional.isPresent()) {
                    this.opt(optOptional);
                }
                this.array(instance.array());
                String[] nularrValue = instance.nularr();
                if (nularrValue != null) {
                    this.nularr(nularrValue);
                }
                return (Enc.Suppied.Builder)this;
            }

            @JsonProperty(value="a")
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> a(String a) {
                this.a = Objects.requireNonNull(a, "a");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return (Enc.Suppied.Builder)this;
            }

            @JsonProperty(value="num")
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> num(T num) {
                this.num = (Number)Objects.requireNonNull(num, "num");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return (Enc.Suppied.Builder)this;
            }

            @SafeVarargs
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> putMm(String key, T ... values) {
                this.mm.putAll((Object)key, Arrays.asList(values));
                return (Enc.Suppied.Builder)this;
            }

            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> putAllMm(String key, Iterable<T> values) {
                this.mm.putAll((Object)key, values);
                return (Enc.Suppied.Builder)this;
            }

            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> putMm(String key, T value) {
                this.mm.put((Object)key, value);
                return (Enc.Suppied.Builder)this;
            }

            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> putMm(Map.Entry<String, ? extends T> entry) {
                this.mm.put(entry);
                return (Enc.Suppied.Builder)this;
            }

            @JsonProperty(value="mm")
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> mm(Multimap<String, ? extends T> entries) {
                this.mm = ImmutableMultimap.builder();
                return this.putAllMm(entries);
            }

            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> putAllMm(Multimap<String, ? extends T> entries) {
                this.mm.putAll(entries);
                return (Enc.Suppied.Builder)this;
            }

            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> opt(T opt) {
                this.opt = (Number)Objects.requireNonNull(opt, "opt");
                return (Enc.Suppied.Builder)this;
            }

            @JsonProperty(value="opt")
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> opt(Optional<? extends T> opt) {
                this.opt = opt.orElse(null);
                return (Enc.Suppied.Builder)this;
            }

            @JsonProperty(value="array")
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> array(int ... array) {
                this.array = (int[])array.clone();
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return (Enc.Suppied.Builder)this;
            }

            @JsonProperty(value="nularr")
            @CanIgnoreReturnValue
            public final Enc.Suppied.Builder<T> nularr(String ... nularr) {
                this.nularr = nularr;
                return (Enc.Suppied.Builder)this;
            }

            public Suppied<T> build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Suppied(this.a, (Number)this.num, this.mm.build(), (Number)this.opt, this.array, this.nularr, null);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("a");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("num");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("array");
                }
                return "Cannot build Suppied, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="Enc.Suppied", generator="Immutables")
        static final class Json<T extends Number>
        implements Enc.Suppied<T> {
            @Nullable
            String a;
            @Nullable
            T num;
            @Nullable
            Multimap<String, T> mm = ImmutableMultimap.of();
            @Nullable
            Optional<T> opt = Optional.empty();
            @Nullable
            int[] array;
            @Nullable
            String[] nularr;

            Json() {
            }

            @JsonProperty(value="a")
            public void setA(String a) {
                this.a = a;
            }

            @JsonProperty(value="num")
            public void setNum(T num) {
                this.num = num;
            }

            @JsonProperty(value="mm")
            public void setMm(Multimap<String, T> mm) {
                this.mm = mm;
            }

            @JsonProperty(value="opt")
            public void setOpt(Optional<T> opt) {
                this.opt = opt;
            }

            @JsonProperty(value="array")
            public void setArray(int[] array) {
                this.array = array;
            }

            @JsonProperty(value="nularr")
            public void setNularr(@Nullable String[] nularr) {
                this.nularr = nularr;
            }

            @Override
            public String a() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T num() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Multimap<String, T> mm() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<T> opt() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int[] array() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String[] nularr() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enc.Suppied<T> withA(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enc.Suppied<T> withNum(T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enc.Suppied<T> withMm(Multimap<String, ? extends T> entries) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enc.Suppied<T> withOpt(T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Enc.Suppied<T> withOpt(Optional<? extends T> optional) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final Enc.Suppied<T> withArray(int ... elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final Enc.Suppied<T> withNularr(String ... elements) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

