/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.subpack;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SillySubstructure", generator="Repositories")
@ThreadSafe
public class SillySubstructureRepository
extends Repositories.Repository<SillySubstructure> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillySubstructure";
    private final Serialization serialization = new Serialization(this.codecRegistry(), this.fieldNamingStrategy());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public SillySubstructureRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, SillySubstructure.class);
    }

    public FluentFuture<Integer> insert(SillySubstructure document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillySubstructure> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    @Beta
    Bson toBson(Criteria criteria) {
        return Support.convertToBson((Constraints.ConstraintHost)criteria.constraint);
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    private static class Serialization {
        final Encoder<RetentionPolicy> enum1Encoder;
        final Encoder<ElementType> set2Encoder;
        final Encoder<Integer> set3Encoder;
        final Encoder<Float> floats4Encoder;
        final CodecRegistry registry;
        final String enum1Name;
        final String set2Name;
        final String set3Name;
        final String floats4Name;

        Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
            this.registry = registry;
            this.enum1Encoder = this.registry.get(RetentionPolicy.class);
            this.set2Encoder = this.registry.get(ElementType.class);
            this.set3Encoder = this.registry.get(Integer.class);
            this.floats4Encoder = this.registry.get(Float.class);
            this.enum1Name = "e1";
            this.set2Name = Serialization.translateName(fieldNamingStrategy, "set2");
            this.set3Name = Serialization.translateName(fieldNamingStrategy, "set3");
            this.floats4Name = Serialization.translateName(fieldNamingStrategy, "floats4");
        }

        private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
            try {
                return fieldNamingStrategy.translateName((Member)SillySubstructureNamingFields.class.getField(fieldName));
            }
            catch (NoSuchFieldException noSuchField) {
                throw new AssertionError((Object)noSuchField);
            }
        }

        @Generated(from="SillySubstructure", generator="Repositories")
        static final class SillySubstructureNamingFields {
            public RetentionPolicy enum1;
            public Set<ElementType> set2;
            public Set<Integer> set3;
            public List<Float> floats4;

            SillySubstructureNamingFields() {
            }
        }
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria enum1(RetentionPolicy value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1Encoder, (Object)((Object)value))));
        }

        public Criteria enum1Not(RetentionPolicy value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.enum1Name, true, Support.writable(this.serialization.enum1Encoder, (Object)((Object)value))));
        }

        public Criteria enum1In(Iterable<RetentionPolicy> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (RetentionPolicy value : values) {
                wrappedValues.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, false, wrappedValues));
        }

        public Criteria enum1In(RetentionPolicy first, RetentionPolicy second, RetentionPolicy ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)first)));
            values.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)second)));
            for (RetentionPolicy value : rest) {
                values.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, false, values));
        }

        public Criteria enum1NotIn(Iterable<RetentionPolicy> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (RetentionPolicy value : values) {
                wrappedValues.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, true, wrappedValues));
        }

        public Criteria enum1NotIn(RetentionPolicy first, RetentionPolicy second, RetentionPolicy ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)first)));
            values.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)second)));
            for (RetentionPolicy value : rest) {
                values.add(Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, true, values));
        }

        public Criteria enum1GreaterThan(RetentionPolicy lower) {
            return this.enum1In((Range<RetentionPolicy>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria enum1LessThan(RetentionPolicy upper) {
            return this.enum1In((Range<RetentionPolicy>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria enum1AtMost(RetentionPolicy upperInclusive) {
            return this.enum1In((Range<RetentionPolicy>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria enum1AtLeast(RetentionPolicy lowerInclusive) {
            return this.enum1In((Range<RetentionPolicy>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria enum1In(Range<RetentionPolicy> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1Encoder, range)));
        }

        public Criteria enum1NotIn(Range<RetentionPolicy> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.enum1Name, true, Support.writable(this.serialization.enum1Encoder, range)));
        }

        public Criteria set2Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set2Name, false, 0));
        }

        public Criteria set2NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set2Name, true, 0));
        }

        public Criteria set2Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set2Name, false, size));
        }

        public Criteria set2Contains(ElementType value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2Encoder, (Object)((Object)value))));
        }

        public Criteria set2ContainsAll(Iterable<ElementType> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.set2Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria set3Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set3Name, false, 0));
        }

        public Criteria set3NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set3Name, true, 0));
        }

        public Criteria set3Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set3Name, false, size));
        }

        public Criteria set3Contains(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.set3Name, false, Support.writable(this.serialization.set3Encoder, (Object)value)));
        }

        public Criteria set3ContainsAll(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.set3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.set3Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria floats4Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.floats4Name, false, 0));
        }

        public Criteria floats4NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.floats4Name, true, 0));
        }

        public Criteria floats4Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.floats4Name, false, size));
        }

        public Criteria floats4Contains(float value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.floats4Name, false, Support.writable(this.serialization.floats4Encoder, (Object)Float.valueOf(value))));
        }

        public Criteria floats4ContainsAll(Iterable<Float> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Float value : values) {
                wrappedValues.add(Support.writable(this.serialization.floats4Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.floats4Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public Criteria with(Criteria criteria) {
            return new Criteria(this.serialization, (Constraints.Constraint)criteria.constraint.accept((Constraints.ConstraintVisitor)this.constraint));
        }

        public String toString() {
            return "SillySubstructureRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillySubstructure, Indexer> {
        private final Serialization serialization;

        private Indexer(SillySubstructureRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withEnum1() {
            this.fields = this.fields.equal(this.serialization.enum1Name, false, (Object)1);
            return this;
        }

        public Indexer withEnum1Desceding() {
            this.fields = this.fields.equal(this.serialization.enum1Name, false, (Object)-1);
            return this;
        }

        public Indexer withSet2() {
            this.fields = this.fields.equal(this.serialization.set2Name, false, (Object)1);
            return this;
        }

        public Indexer withSet2Desceding() {
            this.fields = this.fields.equal(this.serialization.set2Name, false, (Object)-1);
            return this;
        }

        public Indexer withSet3() {
            this.fields = this.fields.equal(this.serialization.set3Name, false, (Object)1);
            return this;
        }

        public Indexer withSet3Desceding() {
            this.fields = this.fields.equal(this.serialization.set3Name, false, (Object)-1);
            return this;
        }

        public Indexer withFloats4() {
            this.fields = this.fields.equal(this.serialization.floats4Name, false, (Object)1);
            return this;
        }

        public Indexer withFloats4Desceding() {
            this.fields = this.fields.equal(this.serialization.floats4Name, false, (Object)-1);
            return this;
        }
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    @NotThreadSafe
    public static final class Replacer
    extends Repositories.Replacer<SillySubstructure, Replacer> {
        protected Replacer(SillySubstructureRepository repository, SillySubstructure document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super((Repositories.Repository)repository, (Object)document, criteria, ordering);
        }
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillySubstructure, Modifier> {
        private final Serialization serialization;

        private Modifier(SillySubstructureRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setEnum1(RetentionPolicy value) {
            this.setFields = this.setFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            return this;
        }

        public Modifier initEnum1(RetentionPolicy value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            return this;
        }

        public Modifier clearSet2() {
            this.setFields = this.setFields.equal(this.serialization.set2Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeSet2(ElementType value) {
            this.pullFields = this.pullFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            return this;
        }

        public Modifier addSet2(ElementType value) {
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            return this;
        }

        public Modifier setSet2(Iterable<ElementType> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            }
            this.setFields = this.setFields.equal(this.serialization.set2Name, false, wrappedValues);
            return this;
        }

        public Modifier addAllSet2(Iterable<ElementType> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, v);
            return this;
        }

        public Modifier clearSet3() {
            this.setFields = this.setFields.equal(this.serialization.set3Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeSet3(int value) {
            this.pullFields = this.pullFields.equal(this.serialization.set3Name, false, Support.writable(this.serialization.set3Encoder, (Object)value));
            return this;
        }

        public Modifier addSet3(int value) {
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, Support.writable(this.serialization.set3Encoder, (Object)value));
            return this;
        }

        public Modifier setSet3(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.set3Encoder, (Object)value));
            }
            this.setFields = this.setFields.equal(this.serialization.set3Name, false, wrappedValues);
            return this;
        }

        public Modifier addAllSet3(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.set3Encoder, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, v);
            return this;
        }

        public Modifier clearFloats4() {
            this.setFields = this.setFields.equal(this.serialization.floats4Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeFloats4(float value) {
            this.pullFields = this.pullFields.equal(this.serialization.floats4Name, false, Support.writable(this.serialization.floats4Encoder, (Object)Float.valueOf(value)));
            return this;
        }

        public Modifier addFloats4(float value) {
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, Support.writable(this.serialization.floats4Encoder, (Object)Float.valueOf(value)));
            return this;
        }

        public Modifier setFloats4(Iterable<Float> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Float value : values) {
                wrappedValues.add(Support.writable(this.serialization.floats4Encoder, (Object)value));
            }
            this.setFields = this.setFields.equal(this.serialization.floats4Name, false, wrappedValues);
            return this;
        }

        public Modifier addAllFloats4(Iterable<Float> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Float value : values) {
                wrappedValues.add(Support.writable(this.serialization.floats4Encoder, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, v);
            return this;
        }
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillySubstructure> {
        private final Serialization serialization;

        private Updater(SillySubstructureRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setEnum1(RetentionPolicy value) {
            this.setFields = this.setFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            return this;
        }

        public Updater initEnum1(RetentionPolicy value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1Encoder, (Object)((Object)value)));
            return this;
        }

        public Updater clearSet2() {
            this.setFields = this.setFields.equal(this.serialization.set2Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeSet2(ElementType value) {
            this.pullFields = this.pullFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            return this;
        }

        public Updater addSet2(ElementType value) {
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            return this;
        }

        public Updater setSet2(Iterable<ElementType> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            }
            this.setFields = this.setFields.equal(this.serialization.set2Name, false, wrappedValues);
            return this;
        }

        public Updater addAllSet2(Iterable<ElementType> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2Encoder, (Object)((Object)value)));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, v);
            return this;
        }

        public Updater clearSet3() {
            this.setFields = this.setFields.equal(this.serialization.set3Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeSet3(int value) {
            this.pullFields = this.pullFields.equal(this.serialization.set3Name, false, Support.writable(this.serialization.set3Encoder, (Object)value));
            return this;
        }

        public Updater addSet3(int value) {
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, Support.writable(this.serialization.set3Encoder, (Object)value));
            return this;
        }

        public Updater setSet3(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.set3Encoder, (Object)value));
            }
            this.setFields = this.setFields.equal(this.serialization.set3Name, false, wrappedValues);
            return this;
        }

        public Updater addAllSet3(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.set3Encoder, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, v);
            return this;
        }

        public Updater clearFloats4() {
            this.setFields = this.setFields.equal(this.serialization.floats4Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeFloats4(float value) {
            this.pullFields = this.pullFields.equal(this.serialization.floats4Name, false, Support.writable(this.serialization.floats4Encoder, (Object)Float.valueOf(value)));
            return this;
        }

        public Updater addFloats4(float value) {
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, Support.writable(this.serialization.floats4Encoder, (Object)Float.valueOf(value)));
            return this;
        }

        public Updater setFloats4(Iterable<Float> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Float value : values) {
                wrappedValues.add(Support.writable(this.serialization.floats4Encoder, (Object)value));
            }
            this.setFields = this.setFields.equal(this.serialization.floats4Name, false, wrappedValues);
            return this;
        }

        public Updater addAllFloats4(Iterable<Float> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Float value : values) {
                wrappedValues.add(Support.writable(this.serialization.floats4Encoder, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, v);
            return this;
        }
    }

    @Generated(from="SillySubstructure", generator="Repositories")
    @NotThreadSafe
    public static final class Finder
    extends Repositories.FinderWithDelete<SillySubstructure, Finder> {
        private final Serialization serialization;

        private Finder(SillySubstructureRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderByEnum1() {
            this.ordering = this.ordering.equal(this.serialization.enum1Name, false, (Object)1);
            return this;
        }

        public Finder orderByEnum1Desceding() {
            this.ordering = this.ordering.equal(this.serialization.enum1Name, false, (Object)-1);
            return this;
        }

        public Finder orderBySet2() {
            this.ordering = this.ordering.equal(this.serialization.set2Name, false, (Object)1);
            return this;
        }

        public Finder orderBySet2Desceding() {
            this.ordering = this.ordering.equal(this.serialization.set2Name, false, (Object)-1);
            return this;
        }

        public Finder orderBySet3() {
            this.ordering = this.ordering.equal(this.serialization.set3Name, false, (Object)1);
            return this;
        }

        public Finder orderBySet3Desceding() {
            this.ordering = this.ordering.equal(this.serialization.set3Name, false, (Object)-1);
            return this;
        }

        public Finder orderByFloats4() {
            this.ordering = this.ordering.equal(this.serialization.floats4Name, false, (Object)1);
            return this;
        }

        public Finder orderByFloats4Desceding() {
            this.ordering = this.ordering.equal(this.serialization.floats4Name, false, (Object)-1);
            return this;
        }

        public Finder excludeSet2() {
            this.exclusion = this.exclusion.equal(this.serialization.set2Name, false, (Object)-1);
            return this;
        }

        public Finder excludeSet3() {
            this.exclusion = this.exclusion.equal(this.serialization.set3Name, false, (Object)-1);
            return this;
        }

        public Finder excludeFloats4() {
            this.exclusion = this.exclusion.equal(this.serialization.floats4Name, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((SillySubstructureRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }

        @CheckReturnValue
        public Replacer andReplaceFirst(SillySubstructure document) {
            return new Replacer((SillySubstructureRepository)this.repository, document, this.criteria, this.ordering);
        }
    }
}

