/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.TrimToString;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TrimToString", generator="Immutables")
@Immutable
public final class ImmutableTrimToString
implements TrimToString {
    private final boolean a;
    private final String b;

    private ImmutableTrimToString(boolean a, String b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean a() {
        return this.a;
    }

    @Override
    public String b() {
        return this.b;
    }

    public final ImmutableTrimToString withA(boolean value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableTrimToString(value, this.b);
    }

    public final ImmutableTrimToString withB(String value) {
        String newValue = Objects.requireNonNull(value, "b");
        if (this.b.equals(newValue)) {
            return this;
        }
        return new ImmutableTrimToString(this.a, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrimToString && this.equalTo(0, (ImmutableTrimToString)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrimToString another) {
        return this.a == another.a && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.a);
        h += (h << 5) + this.b.hashCode();
        return h;
    }

    private static String toStringTrimmed(Object input, int limit) {
        if (input == null) {
            return null;
        }
        String output = input.toString();
        return output.length() > limit ? output.substring(0, limit).concat("\u2026") : output;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TrimToString").omitNullValues().add("a", this.a).add("b", (Object)ImmutableTrimToString.toStringTrimmed(this.b, 2)).toString();
    }

    public static ImmutableTrimToString copyOf(TrimToString instance) {
        if (instance instanceof ImmutableTrimToString) {
            return (ImmutableTrimToString)instance;
        }
        return ImmutableTrimToString.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrimToString", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        private boolean a;
        @Nullable
        private String b;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TrimToString instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.b(instance.b());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder a(boolean a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(String b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTrimToString build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrimToString(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build TrimToString, some of required attributes are not set " + attributes;
        }
    }
}

