/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.SampleRuntimeException;
import org.immutables.fixture.style.SpecifiedException;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SpecifiedException", generator="Immutables")
@Immutable
public final class ImmutableSpecifiedException
implements SpecifiedException {
    private final int someRequiredInteger;
    private final String someRequiredString;

    private ImmutableSpecifiedException(int someRequiredInteger, String someRequiredString) {
        this.someRequiredInteger = someRequiredInteger;
        this.someRequiredString = someRequiredString;
    }

    @Override
    public int getSomeRequiredInteger() {
        return this.someRequiredInteger;
    }

    @Override
    public String getSomeRequiredString() {
        return this.someRequiredString;
    }

    public final ImmutableSpecifiedException withSomeRequiredInteger(int value) {
        if (this.someRequiredInteger == value) {
            return this;
        }
        return new ImmutableSpecifiedException(value, this.someRequiredString);
    }

    public final ImmutableSpecifiedException withSomeRequiredString(String value) {
        String newValue = ImmutableSpecifiedException.requireNonNull(value, "someRequiredString");
        if (this.someRequiredString.equals(newValue)) {
            return this;
        }
        return new ImmutableSpecifiedException(this.someRequiredInteger, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpecifiedException && this.equalTo(0, (ImmutableSpecifiedException)another);
    }

    private boolean equalTo(int synthetic, ImmutableSpecifiedException another) {
        return this.someRequiredInteger == another.someRequiredInteger && this.someRequiredString.equals(another.someRequiredString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.someRequiredInteger;
        h += (h << 5) + this.someRequiredString.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SpecifiedException").omitNullValues().add("someRequiredInteger", this.someRequiredInteger).add("someRequiredString", (Object)this.someRequiredString).toString();
    }

    public static ImmutableSpecifiedException copyOf(SpecifiedException instance) {
        if (instance instanceof ImmutableSpecifiedException) {
            return (ImmutableSpecifiedException)instance;
        }
        return ImmutableSpecifiedException.builder().someRequiredInteger(instance.getSomeRequiredInteger()).someRequiredString(instance.getSomeRequiredString()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new SampleRuntimeException(message);
        }
        return object;
    }

    @Generated(from="SpecifiedException", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOME_REQUIRED_INTEGER = 1L;
        private static final long INIT_BIT_SOME_REQUIRED_STRING = 2L;
        private long initBits = 3L;
        private int someRequiredInteger;
        @Nullable
        private String someRequiredString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder someRequiredInteger(int someRequiredInteger) {
            Builder.checkNotIsSet(this.someRequiredIntegerIsSet(), "someRequiredInteger");
            this.someRequiredInteger = someRequiredInteger;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder someRequiredString(String someRequiredString) {
            Builder.checkNotIsSet(this.someRequiredStringIsSet(), "someRequiredString");
            this.someRequiredString = (String)ImmutableSpecifiedException.requireNonNull(someRequiredString, "someRequiredString");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSpecifiedException build() {
            this.checkRequiredAttributes();
            return new ImmutableSpecifiedException(this.someRequiredInteger, this.someRequiredString);
        }

        public <BOT extends Exception> ImmutableSpecifiedException buildOrThrow(Function<String, BOT> exceptionSupplier) throws BOT {
            this.checkRequiredAttributesOrThrow(exceptionSupplier);
            return new ImmutableSpecifiedException(this.someRequiredInteger, this.someRequiredString);
        }

        private boolean someRequiredIntegerIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean someRequiredStringIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SpecifiedException is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new SampleRuntimeException(this.formatRequiredAttributesMessage());
            }
        }

        private <T extends Exception> void checkRequiredAttributesOrThrow(Function<String, T> exceptionSupplier) throws T {
            if (this.initBits != 0L) {
                throw (Exception)exceptionSupplier.apply(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.someRequiredIntegerIsSet()) {
                attributes.add("someRequiredInteger");
            }
            if (!this.someRequiredStringIsSet()) {
                attributes.add("someRequiredString");
            }
            return "Cannot build SpecifiedException, some of required attributes are not set " + attributes;
        }
    }
}

