/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.BeanStyleDetected;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BeanStyleDetected", generator="Immutables")
@Immutable
final class ImmutableBeanStyleDetected
extends BeanStyleDetected {
    private final int it;
    private final ImmutableList<String> em;

    private ImmutableBeanStyleDetected(int it, ImmutableList<String> em) {
        this.it = it;
        this.em = em;
    }

    @Override
    int isIt() {
        return this.it;
    }

    ImmutableList<String> getEm() {
        return this.em;
    }

    public final ImmutableBeanStyleDetected withIt(int value) {
        if (this.it == value) {
            return this;
        }
        return new ImmutableBeanStyleDetected(value, this.em);
    }

    public final ImmutableBeanStyleDetected withEm(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBeanStyleDetected(this.it, (ImmutableList<String>)newValue);
    }

    public final ImmutableBeanStyleDetected withEm(Iterable<String> elements) {
        if (this.em == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBeanStyleDetected(this.it, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBeanStyleDetected && this.equalTo(0, (ImmutableBeanStyleDetected)another);
    }

    private boolean equalTo(int synthetic, ImmutableBeanStyleDetected another) {
        return this.it == another.it && this.em.equals(another.em);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.it;
        h += (h << 5) + this.em.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BeanStyleDetected").omitNullValues().add("it", this.it).add("em", this.em).toString();
    }

    public static ImmutableBeanStyleDetected copyOf(BeanStyleDetected instance) {
        if (instance instanceof ImmutableBeanStyleDetected) {
            return (ImmutableBeanStyleDetected)instance;
        }
        return ImmutableBeanStyleDetected.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BeanStyleDetected", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IT = 1L;
        private long initBits = 1L;
        private int it;
        private ImmutableList.Builder<String> em = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BeanStyleDetected instance) {
            Objects.requireNonNull(instance, "instance");
            this.setIt(instance.isIt());
            this.addAllEm(instance.getEm());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setIt(int it) {
            this.it = it;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEm(String element) {
            this.em.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEm(String ... elements) {
            this.em.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setEm(Iterable<String> elements) {
            this.em = ImmutableList.builder();
            return this.addAllEm(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEm(Iterable<String> elements) {
            this.em.addAll(elements);
            return this;
        }

        public ImmutableBeanStyleDetected build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBeanStyleDetected(this.it, this.em.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("it");
            }
            return "Cannot build BeanStyleDetected, some of required attributes are not set " + attributes;
        }
    }
}

