/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.Constr;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Constr.Build", generator="Immutables")
@Immutable
public final class ImBuild
implements Constr.Build {
    private final String date;
    private final String qualifier;

    public ImBuild(String date, String qualifier) {
        this.date = Objects.requireNonNull(date, "date");
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier");
    }

    private ImBuild(ImBuild original, String date, String qualifier) {
        this.date = date;
        this.qualifier = qualifier;
    }

    @Override
    public String date() {
        return this.date;
    }

    @Override
    public String qualifier() {
        return this.qualifier;
    }

    public final ImBuild withDate(String value) {
        String newValue = Objects.requireNonNull(value, "date");
        if (this.date.equals(newValue)) {
            return this;
        }
        return new ImBuild(this, newValue, this.qualifier);
    }

    public final ImBuild withQualifier(String value) {
        String newValue = Objects.requireNonNull(value, "qualifier");
        if (this.qualifier.equals(newValue)) {
            return this;
        }
        return new ImBuild(this, this.date, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImBuild && this.equalTo(0, (ImBuild)another);
    }

    private boolean equalTo(int synthetic, ImBuild another) {
        return this.date.equals(another.date) && this.qualifier.equals(another.qualifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.date.hashCode();
        h += (h << 5) + this.qualifier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Build").omitNullValues().add("date", (Object)this.date).add("qualifier", (Object)this.qualifier).toString();
    }

    public static ImBuild copyOf(Constr.Build instance) {
        if (instance instanceof ImBuild) {
            return (ImBuild)instance;
        }
        return ImBuild.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Constr.Build", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_QUALIFIER = 2L;
        private long initBits = 3L;
        @Nullable
        private String date;
        @Nullable
        private String qualifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Constr.Build instance) {
            Objects.requireNonNull(instance, "instance");
            this.date(instance.date());
            this.qualifier(instance.qualifier());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder date(String date) {
            this.date = Objects.requireNonNull(date, "date");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder qualifier(String qualifier) {
            this.qualifier = Objects.requireNonNull(qualifier, "qualifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImBuild build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImBuild(null, this.date, this.qualifier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("qualifier");
            }
            return "Cannot build Build, some of required attributes are not set " + attributes;
        }
    }
}

