/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.NullableCompact;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullableCompact", generator="Immutables")
@Immutable
public final class ImmutableNullableCompact
extends NullableCompact {
    @Nullable
    private final Integer[] array;
    @Nullable
    private final ImmutableMap<String, Object> map;

    private ImmutableNullableCompact(@Nullable Integer[] array, @Nullable Map<String, ? extends Object> map) {
        this.array = array;
        this.map = map == null ? null : ImmutableMap.copyOf(map);
    }

    private ImmutableNullableCompact(ImmutableNullableCompact original, @Nullable Integer[] array, @Nullable ImmutableMap<String, Object> map) {
        this.array = array;
        this.map = map;
    }

    @Override
    @JsonProperty(value="array")
    @Nullable
    public Integer[] array() {
        return this.array;
    }

    @JsonProperty(value="map")
    @Nullable
    public ImmutableMap<String, Object> map() {
        return this.map;
    }

    public final ImmutableNullableCompact withArray(Integer ... elements) {
        Integer[] newValue = elements == null ? null : (Integer[])elements.clone();
        return new ImmutableNullableCompact(this, newValue, this.map);
    }

    public final ImmutableNullableCompact withMap(@Nullable Map<String, ? extends Object> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableNullableCompact(this, this.array, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableCompact && this.equalTo(0, (ImmutableNullableCompact)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableCompact another) {
        return Arrays.equals((Object[])this.array, (Object[])another.array) && Objects.equals(this.map, another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode((Object[])this.array);
        h += (h << 5) + Objects.hashCode(this.map);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableCompact").omitNullValues().add("array", (Object)Arrays.toString((Object[])this.array)).add("map", this.map).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNullableCompact fromJson(Json json) {
        Builder builder = ImmutableNullableCompact.builder();
        if (json.array != null) {
            builder.array(json.array);
        }
        if (json.map != null) {
            builder.putAllMap(json.map);
        }
        return builder.build();
    }

    public static ImmutableNullableCompact of(@Nullable Integer[] array, @Nullable Map<String, ? extends Object> map) {
        return new ImmutableNullableCompact(array, map);
    }

    public static ImmutableNullableCompact copyOf(NullableCompact instance) {
        if (instance instanceof ImmutableNullableCompact) {
            return (ImmutableNullableCompact)instance;
        }
        return ImmutableNullableCompact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NullableCompact", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer[] array;
        private ImmutableMap.Builder<String, Object> map = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NullableCompact instance) {
            Map<String, Object> mapValue;
            Objects.requireNonNull(instance, "instance");
            Integer[] arrayValue = instance.array();
            if (arrayValue != null) {
                this.array(arrayValue);
            }
            if ((mapValue = instance.map()) != null) {
                this.putAllMap(mapValue);
            }
            return this;
        }

        @JsonProperty(value="array")
        @CanIgnoreReturnValue
        public final Builder array(Integer ... array) {
            this.array = array;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, Object value) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends Object> entry) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.put(entry);
            return this;
        }

        @JsonProperty(value="map")
        @CanIgnoreReturnValue
        public final Builder map(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.map = null;
                return this;
            }
            this.map = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends Object> entries) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.putAll(entries);
            return this;
        }

        public ImmutableNullableCompact build() {
            return new ImmutableNullableCompact(null, this.array, this.map == null ? null : this.map.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NullableCompact", generator="Immutables")
    static final class Json
    extends NullableCompact {
        @Nullable
        Integer[] array;
        @Nullable
        Map<String, Object> map = null;

        Json() {
        }

        @JsonProperty(value="array")
        public void setArray(@Nullable Integer[] array) {
            this.array = array;
        }

        @JsonProperty(value="map")
        public void setMap(@Nullable Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Integer[] array() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> map() {
            throw new UnsupportedOperationException();
        }
    }
}

