/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.CheckForNull;
import org.immutables.fixture.nullable.CustomNullableAnnotation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CustomNullableAnnotation", generator="Immutables")
@Immutable
public final class ImmutableCustomNullableAnnotation
implements CustomNullableAnnotation {
    @CheckForNull
    private final String string1;
    private final String string2;

    private ImmutableCustomNullableAnnotation(@CheckForNull String string1, String string2) {
        this.string1 = string1;
        this.string2 = string2;
    }

    @Override
    @CheckForNull
    public String string1() {
        return this.string1;
    }

    @Override
    public String string2() {
        return this.string2;
    }

    public final ImmutableCustomNullableAnnotation withString1(@CheckForNull String value) {
        if (Objects.equals(this.string1, value)) {
            return this;
        }
        return new ImmutableCustomNullableAnnotation(value, this.string2);
    }

    public final ImmutableCustomNullableAnnotation withString2(String value) {
        String newValue = Objects.requireNonNull(value, "string2");
        if (this.string2.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomNullableAnnotation(this.string1, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomNullableAnnotation && this.equalTo(0, (ImmutableCustomNullableAnnotation)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomNullableAnnotation another) {
        return Objects.equals(this.string1, another.string1) && this.string2.equals(another.string2);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.string1);
        h += (h << 5) + this.string2.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomNullableAnnotation").omitNullValues().add("string1", (Object)this.string1).add("string2", (Object)this.string2).toString();
    }

    public static ImmutableCustomNullableAnnotation copyOf(CustomNullableAnnotation instance) {
        if (instance instanceof ImmutableCustomNullableAnnotation) {
            return (ImmutableCustomNullableAnnotation)instance;
        }
        return ImmutableCustomNullableAnnotation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CustomNullableAnnotation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STRING2 = 1L;
        private long initBits = 1L;
        @Nullable
        private String string1;
        @Nullable
        private String string2;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CustomNullableAnnotation instance) {
            Objects.requireNonNull(instance, "instance");
            String string1Value = instance.string1();
            if (string1Value != null) {
                this.string1(string1Value);
            }
            this.string2(instance.string2());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder string1(@CheckForNull String string1) {
            this.string1 = string1;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder string2(String string2) {
            this.string2 = Objects.requireNonNull(string2, "string2");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCustomNullableAnnotation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomNullableAnnotation(this.string1, this.string2);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("string2");
            }
            return "Cannot build CustomNullableAnnotation, some of required attributes are not set " + attributes;
        }
    }
}

