/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.nullable.ImmutableNullableCompact;
import org.immutables.fixture.nullable.NullableCompact;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.nullable", generator="Gsons")
public final class GsonAdaptersNullableCompact
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (NullableCompactTypeAdapter.adapts(type)) {
            return new NullableCompactTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersNullableCompact(NullableCompact)";
    }

    @Generated(from="NullableCompact", generator="Gsons")
    private static class NullableCompactTypeAdapter
    extends TypeAdapter<NullableCompact> {
        public final Integer arrayTypeSample = null;
        public final Object mapSecondaryTypeSample = null;
        private final TypeAdapter<Integer> arrayTypeAdapter;
        private final TypeAdapter<Object> mapSecondaryTypeAdapter;

        NullableCompactTypeAdapter(Gson gson) {
            this.arrayTypeAdapter = gson.getAdapter(Integer.class);
            this.mapSecondaryTypeAdapter = gson.getAdapter(Object.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return NullableCompact.class == type.getRawType() || ImmutableNullableCompact.class == type.getRawType();
        }

        public void write(JsonWriter out, NullableCompact value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeNullableCompact(out, value);
            }
        }

        public NullableCompact read(JsonReader in) throws IOException {
            return this.readNullableCompact(in);
        }

        private void writeNullableCompact(JsonWriter out, NullableCompact instance) throws IOException {
            out.beginObject();
            Integer[] arrayElements = instance.array();
            if (arrayElements != null) {
                out.name("array");
                out.beginArray();
                for (Integer e : arrayElements) {
                    this.arrayTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("array");
                out.nullValue();
            }
            Map<String, Object> mapMapping = instance.map();
            if (mapMapping != null) {
                out.name("map");
                out.beginObject();
                for (Map.Entry<String, Object> e : mapMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    Object value = e.getValue();
                    this.mapSecondaryTypeAdapter.write(out, value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("map");
                out.nullValue();
            }
            out.endObject();
        }

        private NullableCompact readNullableCompact(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableNullableCompact.Builder builder = ImmutableNullableCompact.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableNullableCompact.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if (!"array".equals(attributeName)) break;
                    this.readInArray(in, builder);
                    return;
                }
                case 'm': {
                    if (!"map".equals(attributeName)) break;
                    this.readInMap(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInArray(JsonReader in, ImmutableNullableCompact.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ArrayList<Integer> elements = new ArrayList<Integer>();
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        Integer value = (Integer)this.arrayTypeAdapter.read(in);
                        elements.add(value);
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    Integer value = (Integer)this.arrayTypeAdapter.read(in);
                    elements.add(value);
                }
                builder.array(elements.toArray(new Integer[elements.size()]));
            }
        }

        private void readInMap(JsonReader in, ImmutableNullableCompact.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                boolean empty = true;
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    Object value = this.mapSecondaryTypeAdapter.read(in);
                    builder.putMap(key, value);
                    empty = false;
                }
                if (empty) {
                    builder.putAllMap(Collections.emptyMap());
                }
                in.endObject();
            }
        }
    }
}

