/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.nullable.ImmutableNullableAttributes;
import org.immutables.fixture.nullable.NullableAttributes;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.nullable", generator="Gsons")
public final class GsonAdaptersNullableAttributes
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (NullableAttributesTypeAdapter.adapts(type)) {
            return new NullableAttributesTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersNullableAttributes(NullableAttributes)";
    }

    @Generated(from="NullableAttributes", generator="Gsons")
    private static class NullableAttributesTypeAdapter
    extends TypeAdapter<NullableAttributes> {
        public final Integer integerTypeSample = null;
        public final Integer setTypeSample = null;
        public final Integer arrayTypeSample = null;
        public final Double defArrayTypeSample = null;
        public final Object mapSecondaryTypeSample = null;
        private final TypeAdapter<Integer> integerTypeAdapter;
        private final TypeAdapter<Integer> setTypeAdapter;
        private final TypeAdapter<Integer> arrayTypeAdapter;
        private final TypeAdapter<Double> defArrayTypeAdapter;
        private final TypeAdapter<Object> mapSecondaryTypeAdapter;

        NullableAttributesTypeAdapter(Gson gson) {
            this.integerTypeAdapter = gson.getAdapter(Integer.class);
            this.setTypeAdapter = gson.getAdapter(Integer.class);
            this.arrayTypeAdapter = gson.getAdapter(Integer.class);
            this.defArrayTypeAdapter = gson.getAdapter(Double.class);
            this.mapSecondaryTypeAdapter = gson.getAdapter(Object.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return NullableAttributes.class == type.getRawType() || ImmutableNullableAttributes.class == type.getRawType();
        }

        public void write(JsonWriter out, NullableAttributes value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeNullableAttributes(out, value);
            }
        }

        public NullableAttributes read(JsonReader in) throws IOException {
            return this.readNullableAttributes(in);
        }

        private void writeNullableAttributes(JsonWriter out, NullableAttributes instance) throws IOException {
            out.beginObject();
            Integer integerValue = instance.integer();
            if (integerValue != null) {
                out.name("integer");
                this.integerTypeAdapter.write(out, (Object)integerValue);
            } else if (out.getSerializeNulls()) {
                out.name("integer");
                out.nullValue();
            }
            List<String> listElements = instance.list();
            if (listElements != null) {
                out.name("list");
                out.beginArray();
                for (String string : listElements) {
                    out.value(string);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("list");
                out.nullValue();
            }
            Set<Integer> setElements = instance.set();
            if (setElements != null) {
                out.name("set");
                out.beginArray();
                for (Integer n : setElements) {
                    this.setTypeAdapter.write(out, (Object)n);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("set");
                out.nullValue();
            }
            Integer[] integerArray = instance.array();
            if (integerArray != null) {
                out.name("array");
                out.beginArray();
                for (Integer e : integerArray) {
                    this.arrayTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("array");
                out.nullValue();
            }
            Double[] doubleArray = instance.defArray();
            if (doubleArray != null) {
                out.name("defArray");
                out.beginArray();
                for (Double e : doubleArray) {
                    this.defArrayTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("defArray");
                out.nullValue();
            }
            Map<String, Object> mapMapping = instance.map();
            if (mapMapping != null) {
                out.name("map");
                out.beginObject();
                for (Map.Entry<String, Object> e : mapMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    Object value = e.getValue();
                    this.mapSecondaryTypeAdapter.write(out, value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("map");
                out.nullValue();
            }
            out.endObject();
        }

        private NullableAttributes readNullableAttributes(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableNullableAttributes.Builder builder = ImmutableNullableAttributes.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"integer".equals(attributeName)) break;
                    this.readInInteger(in, builder);
                    return;
                }
                case 'l': {
                    if (!"list".equals(attributeName)) break;
                    this.readInList(in, builder);
                    return;
                }
                case 's': {
                    if (!"set".equals(attributeName)) break;
                    this.readInSet(in, builder);
                    return;
                }
                case 'a': {
                    if (!"array".equals(attributeName)) break;
                    this.readInArray(in, builder);
                    return;
                }
                case 'd': {
                    if (!"defArray".equals(attributeName)) break;
                    this.readInDefArray(in, builder);
                    return;
                }
                case 'm': {
                    if (!"map".equals(attributeName)) break;
                    this.readInMap(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInInteger(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.integerTypeAdapter.read(in);
                builder.integer(value);
            }
        }

        private void readInList(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                boolean empty = true;
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        builder.addList(in.nextString());
                        empty = false;
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    builder.addList(in.nextString());
                    empty = false;
                }
                if (empty) {
                    builder.addAllList(Collections.emptyList());
                }
            }
        }

        private void readInSet(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                builder.set(null);
            } else {
                boolean empty = true;
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        builder.addSet(in.nextInt());
                        empty = false;
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    builder.addSet(in.nextInt());
                    empty = false;
                }
                if (empty) {
                    builder.addAllSet(Collections.emptyList());
                }
            }
        }

        private void readInArray(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ArrayList<Integer> elements = new ArrayList<Integer>();
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        Integer value = (Integer)this.arrayTypeAdapter.read(in);
                        elements.add(value);
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    Integer value = (Integer)this.arrayTypeAdapter.read(in);
                    elements.add(value);
                }
                builder.array(elements.toArray(new Integer[elements.size()]));
            }
        }

        private void readInDefArray(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                builder.defArray(null);
            } else {
                ArrayList<Double> elements = new ArrayList<Double>();
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        Double value = (Double)this.defArrayTypeAdapter.read(in);
                        elements.add(value);
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    Double value = (Double)this.defArrayTypeAdapter.read(in);
                    elements.add(value);
                }
                builder.defArray(elements.toArray(new Double[elements.size()]));
            }
        }

        private void readInMap(JsonReader in, ImmutableNullableAttributes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                boolean empty = true;
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    Object value = this.mapSecondaryTypeAdapter.read(in);
                    builder.putMap(key, value);
                    empty = false;
                }
                if (empty) {
                    builder.putAllMap(Collections.emptyMap());
                }
                in.endObject();
            }
        }
    }
}

