/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ImmutableMutableImmutableCollection;
import org.immutables.fixture.modifiable.MutableImmutableCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MutableImmutableCollection", generator="Modifiables")
@NotThreadSafe
public final class ModifiableMutableImmutableCollection
extends MutableImmutableCollection {
    private final ArrayList<String> a = new ArrayList();
    private final LinkedHashSet<String> b = new LinkedHashSet();
    private final ArrayListMultimap<String, Integer> c = ArrayListMultimap.create();
    private final Map<Void, Void> d = new LinkedHashMap<Void, Void>();

    private ModifiableMutableImmutableCollection() {
    }

    public static ModifiableMutableImmutableCollection create() {
        return new ModifiableMutableImmutableCollection();
    }

    @Override
    final ImmutableList<String> a() {
        return ImmutableList.copyOf(this.a);
    }

    @Override
    final ImmutableSet<String> b() {
        return ImmutableSet.copyOf(this.b);
    }

    @Override
    final ImmutableMultimap<String, Integer> c() {
        return ImmutableMultimap.copyOf(this.c);
    }

    @Override
    final ImmutableMap<Void, Void> d() {
        return ImmutableMap.copyOf(this.d);
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection clear() {
        this.a.clear();
        this.b.clear();
        this.c.clear();
        this.d.clear();
        return this;
    }

    public ModifiableMutableImmutableCollection from(MutableImmutableCollection instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableMutableImmutableCollection) {
            this.from((ModifiableMutableImmutableCollection)instance);
            return this;
        }
        this.addAllA((Iterable<String>)instance.a());
        this.addAllB((Iterable<String>)instance.b());
        this.putAllC((Multimap<String, ? extends Integer>)instance.c());
        this.putAllD((Map<? extends Void, ? extends Void>)instance.d());
        return this;
    }

    public ModifiableMutableImmutableCollection from(ModifiableMutableImmutableCollection instance) {
        Objects.requireNonNull(instance, "instance");
        this.addAllA((Iterable<String>)instance.a());
        this.addAllB((Iterable<String>)instance.b());
        this.putAllC((Multimap<String, ? extends Integer>)instance.c());
        this.putAllD((Map<? extends Void, ? extends Void>)instance.d());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection addA(String element) {
        Objects.requireNonNull(element, "a element");
        this.a.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableMutableImmutableCollection addA(String ... elements) {
        for (String e : elements) {
            this.addA(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection setA(Iterable<String> elements) {
        this.a.clear();
        this.addAllA(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection addAllA(Iterable<String> elements) {
        for (String e : elements) {
            this.addA(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection addB(String element) {
        Objects.requireNonNull(element, "b element");
        this.b.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableMutableImmutableCollection addB(String ... elements) {
        for (String e : elements) {
            this.addB(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection setB(Iterable<String> elements) {
        this.b.clear();
        this.addAllB(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection addAllB(Iterable<String> elements) {
        for (String e : elements) {
            this.addB(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableMutableImmutableCollection putC(String key, int ... values) {
        this.putAllC(key, Ints.asList((int[])values));
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection putAllC(String key, Iterable<Integer> values) {
        for (Integer v : values) {
            this.c.put((Object)Objects.requireNonNull(key, "c key"), (Object)Objects.requireNonNull(v, "c value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection putC(String key, int value) {
        this.c.put((Object)Objects.requireNonNull(key, "c key"), (Object)value);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection setC(Multimap<String, ? extends Integer> entries) {
        this.c.clear();
        for (Map.Entry e : entries.entries()) {
            String k = (String)e.getKey();
            Integer v = (Integer)e.getValue();
            this.c.put((Object)Objects.requireNonNull(k, "c key"), (Object)Objects.requireNonNull(v, "c value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection putAllC(Multimap<String, ? extends Integer> entries) {
        for (Map.Entry e : entries.entries()) {
            String k = (String)e.getKey();
            Integer v = (Integer)e.getValue();
            this.c.put((Object)Objects.requireNonNull(k, "c key"), (Object)Objects.requireNonNull(v, "c value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection putD(Void key, Void value) {
        this.d.put(Objects.requireNonNull(key, "d key"), Objects.requireNonNull(value, "d value"));
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection setD(Map<? extends Void, ? extends Void> entries) {
        this.d.clear();
        for (Map.Entry<? extends Void, ? extends Void> e : entries.entrySet()) {
            Void k = e.getKey();
            Void v = e.getValue();
            this.d.put(Objects.requireNonNull(k, "d key"), Objects.requireNonNull(v, "d value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableMutableImmutableCollection putAllD(Map<? extends Void, ? extends Void> entries) {
        for (Map.Entry<? extends Void, ? extends Void> e : entries.entrySet()) {
            Void k = e.getKey();
            Void v = e.getValue();
            this.d.put(Objects.requireNonNull(k, "d key"), Objects.requireNonNull(v, "d value"));
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableMutableImmutableCollection toImmutable() {
        return ImmutableMutableImmutableCollection.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableMutableImmutableCollection)) {
            return false;
        }
        ModifiableMutableImmutableCollection other = (ModifiableMutableImmutableCollection)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableMutableImmutableCollection another) {
        return this.a.equals(another.a) && this.b.equals(another.b) && this.c.equals(another.c) && this.d.equals(another.d);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a.hashCode();
        h += (h << 5) + this.b.hashCode();
        h += (h << 5) + this.c.hashCode();
        h += (h << 5) + this.d.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableMutableImmutableCollection").add("a", this.a()).add("b", this.b()).add("c", this.c()).add("d", this.d()).toString();
    }
}

