/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.DefaultMap;
import org.immutables.fixture.modifiable.ImmutableDefaultMap;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DefaultMap", generator="Modifiables")
@NotThreadSafe
public final class ModifiableDefaultMap
implements DefaultMap {
    private static final long OPT_BIT_MAP = 1L;
    private long optBits;
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    private ModifiableDefaultMap() {
    }

    public static ModifiableDefaultMap create() {
        return new ModifiableDefaultMap();
    }

    @Override
    public final Map<String, String> getMap() {
        if (this.mapIsSet()) {
            return this.map;
        }
        return DefaultMap.super.getMap();
    }

    @CanIgnoreReturnValue
    public ModifiableDefaultMap clear() {
        this.optBits = 0L;
        this.map.clear();
        return this;
    }

    public ModifiableDefaultMap from(DefaultMap instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableDefaultMap) {
            this.from((ModifiableDefaultMap)instance);
            return this;
        }
        this.putAllMap(instance.getMap());
        return this;
    }

    public ModifiableDefaultMap from(ModifiableDefaultMap instance) {
        Objects.requireNonNull(instance, "instance");
        this.putAllMap(instance.getMap());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableDefaultMap putMap(String key, String value) {
        this.map.put(Objects.requireNonNull(key, "map key"), Objects.requireNonNull(value, "map value"));
        this.optBits |= 1L;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableDefaultMap setMap(Map<String, ? extends String> entries) {
        this.map.clear();
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), Objects.requireNonNull(v, "map value"));
        }
        this.optBits |= 1L;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableDefaultMap putAllMap(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), Objects.requireNonNull(v, "map value"));
        }
        this.optBits |= 1L;
        return this;
    }

    public final boolean mapIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiableDefaultMap unsetMap() {
        this.optBits |= 0L;
        this.map.clear();
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableDefaultMap toImmutable() {
        return ImmutableDefaultMap.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableDefaultMap)) {
            return false;
        }
        ModifiableDefaultMap other = (ModifiableDefaultMap)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableDefaultMap another) {
        Map<String, String> map = this.getMap();
        return map.equals(another.getMap());
    }

    public int hashCode() {
        int h = 5381;
        Map<String, String> map = this.getMap();
        h += (h << 5) + map.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableDefaultMap{map=" + this.getMap() + "}";
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

