/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;
import org.immutables.fixture.modifiable.ImmutableCompanion;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Companion", generator="Modifiables")
@NotThreadSafe
public final class ModifiableCompanion
implements Companion {
    private static final long INIT_BIT_INTEGER = 1L;
    private static final long INIT_BIT_STRING = 2L;
    private static final long INIT_BIT_ARRAY_INTS = 4L;
    private static final long INIT_BIT_ARRAY_STRINGS = 8L;
    private long initBits = 15L;
    private int integer;
    private String string;
    @Nullable
    private Boolean bools;
    private final ArrayList<String> str = new ArrayList();
    private final LinkedHashSet<Integer> ints = new LinkedHashSet();
    private int[] arrayInts;
    private String[] arrayStrings;
    private final TreeSet<Integer> ords = new TreeSet();
    private final EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
    private final TreeSet<Integer> navs = new TreeSet(Collections.reverseOrder());
    private final Map<Long, Integer> just = new LinkedHashMap<Long, Integer>();
    private final TreeMap<Integer, String> ordsmap = new TreeMap();
    private final EnumMap<RetentionPolicy, Integer> polsmap = new EnumMap(RetentionPolicy.class);
    private final TreeMap<String, Integer> navsmap = new TreeMap(Collections.reverseOrder());

    private ModifiableCompanion() {
    }

    public static ModifiableCompanion create() {
        return new ModifiableCompanion();
    }

    @Override
    public final int integer() {
        if (!this.integerIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.integer;
    }

    @Override
    public final String string() {
        if (!this.stringIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.string;
    }

    @Override
    @Nullable
    public final Boolean bools() {
        return this.bools;
    }

    @Override
    public final List<String> str() {
        return this.str;
    }

    @Override
    public final Set<Integer> ints() {
        return this.ints;
    }

    @Override
    public final int[] arrayInts() {
        if (!this.arrayIntsIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.arrayInts;
    }

    @Override
    public final String[] arrayStrings() {
        if (!this.arrayStringsIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.arrayStrings;
    }

    @Override
    public final SortedSet<Integer> ords() {
        return this.ords;
    }

    @Override
    public final Set<RetentionPolicy> pols() {
        return this.pols;
    }

    @Override
    public final NavigableSet<Integer> navs() {
        return this.navs;
    }

    @Override
    public final Map<Long, Integer> just() {
        return this.just;
    }

    @Override
    public final SortedMap<Integer, String> ordsmap() {
        return this.ordsmap;
    }

    @Override
    public final Map<RetentionPolicy, Integer> polsmap() {
        return this.polsmap;
    }

    @Override
    public final NavigableMap<String, Integer> navsmap() {
        return this.navsmap;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion clear() {
        this.initBits = 15L;
        this.integer = 0;
        this.string = null;
        this.bools = null;
        this.str.clear();
        this.ints.clear();
        this.arrayInts = null;
        this.arrayStrings = null;
        this.ords.clear();
        this.pols.clear();
        this.navs.clear();
        this.just.clear();
        this.ordsmap.clear();
        this.polsmap.clear();
        this.navsmap.clear();
        return this;
    }

    public ModifiableCompanion from(Companion instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableCompanion) {
            this.from((ModifiableCompanion)instance);
            return this;
        }
        this.setInteger(instance.integer());
        this.setString(instance.string());
        Boolean boolsValue = instance.bools();
        if (boolsValue != null) {
            this.setBools(boolsValue);
        }
        this.addAllStr(instance.str());
        this.addAllInts(instance.ints());
        this.setArrayInts(instance.arrayInts());
        this.setArrayStrings(instance.arrayStrings());
        this.addAllOrds(instance.ords());
        this.addAllPols(instance.pols());
        this.addAllNavs(instance.navs());
        this.putAllJust(instance.just());
        this.putAllOrdsmap(instance.ordsmap());
        this.putAllPolsmap(instance.polsmap());
        this.putAllNavsmap(instance.navsmap());
        return this;
    }

    public ModifiableCompanion from(ModifiableCompanion instance) {
        Boolean boolsValue;
        Objects.requireNonNull(instance, "instance");
        if (instance.integerIsSet()) {
            this.setInteger(instance.integer());
        }
        if (instance.stringIsSet()) {
            this.setString(instance.string());
        }
        if ((boolsValue = instance.bools()) != null) {
            this.setBools(boolsValue);
        }
        this.addAllStr(instance.str());
        this.addAllInts(instance.ints());
        if (instance.arrayIntsIsSet()) {
            this.setArrayInts(instance.arrayInts());
        }
        if (instance.arrayStringsIsSet()) {
            this.setArrayStrings(instance.arrayStrings());
        }
        this.addAllOrds(instance.ords());
        this.addAllPols(instance.pols());
        this.addAllNavs(instance.navs());
        this.putAllJust(instance.just());
        this.putAllOrdsmap(instance.ordsmap());
        this.putAllPolsmap(instance.polsmap());
        this.putAllNavsmap(instance.navsmap());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setInteger(int integer) {
        this.integer = integer;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setString(String string) {
        this.string = Objects.requireNonNull(string, "string");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setBools(@Nullable Boolean bools) {
        this.bools = bools;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addStr(String element) {
        Objects.requireNonNull(element, "str element");
        this.str.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion addStr(String ... elements) {
        for (String e : elements) {
            this.addStr(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setStr(Iterable<String> elements) {
        this.str.clear();
        this.addAllStr(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addAllStr(Iterable<String> elements) {
        for (String e : elements) {
            this.addStr(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addInts(int element) {
        this.ints.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion addInts(int ... elements) {
        for (int e : elements) {
            this.addInts((int)Objects.requireNonNull(Integer.valueOf(e), "ints element"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setInts(Iterable<Integer> elements) {
        this.ints.clear();
        this.addAllInts(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addAllInts(Iterable<Integer> elements) {
        for (int e : elements) {
            this.addInts(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion setArrayInts(int ... elements) {
        this.arrayInts = (int[])elements.clone();
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion setArrayStrings(String ... elements) {
        this.arrayStrings = (String[])elements.clone();
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addOrds(int element) {
        this.ords.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion addOrds(int ... elements) {
        for (int e : elements) {
            this.addOrds((int)Objects.requireNonNull(Integer.valueOf(e), "ords element"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setOrds(Iterable<Integer> elements) {
        this.ords.clear();
        this.addAllOrds(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addAllOrds(Iterable<Integer> elements) {
        for (int e : elements) {
            this.addOrds(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addPols(RetentionPolicy element) {
        Objects.requireNonNull(element, "pols element");
        this.pols.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion addPols(RetentionPolicy ... elements) {
        for (RetentionPolicy e : elements) {
            this.addPols(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setPols(Iterable<RetentionPolicy> elements) {
        this.pols.clear();
        this.addAllPols(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addAllPols(Iterable<RetentionPolicy> elements) {
        for (RetentionPolicy e : elements) {
            this.addPols(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addNavs(int element) {
        this.navs.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion addNavs(int ... elements) {
        for (int e : elements) {
            this.addNavs((int)Objects.requireNonNull(Integer.valueOf(e), "navs element"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setNavs(Iterable<Integer> elements) {
        this.navs.clear();
        this.addAllNavs(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion addAllNavs(Iterable<Integer> elements) {
        for (int e : elements) {
            this.addNavs(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putJust(long key, int value) {
        this.just.put(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setJust(Map<Long, ? extends Integer> entries) {
        this.just.clear();
        for (Map.Entry<Long, ? extends Integer> e : entries.entrySet()) {
            Long k = e.getKey();
            Integer v = e.getValue();
            this.just.put(Objects.requireNonNull(k, "just key"), Objects.requireNonNull(v, "just value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putAllJust(Map<Long, ? extends Integer> entries) {
        for (Map.Entry<Long, ? extends Integer> e : entries.entrySet()) {
            Long k = e.getKey();
            Integer v = e.getValue();
            this.just.put(Objects.requireNonNull(k, "just key"), Objects.requireNonNull(v, "just value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putOrdsmap(int key, String value) {
        this.ordsmap.put(key, Objects.requireNonNull(value, "ordsmap value"));
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setOrdsmap(Map<Integer, ? extends String> entries) {
        this.ordsmap.clear();
        for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
            Integer k = e.getKey();
            String v = e.getValue();
            this.ordsmap.put(Objects.requireNonNull(k, "ordsmap key"), Objects.requireNonNull(v, "ordsmap value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putAllOrdsmap(Map<Integer, ? extends String> entries) {
        for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
            Integer k = e.getKey();
            String v = e.getValue();
            this.ordsmap.put(Objects.requireNonNull(k, "ordsmap key"), Objects.requireNonNull(v, "ordsmap value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putPolsmap(RetentionPolicy key, int value) {
        this.polsmap.put((RetentionPolicy)((Enum)Objects.requireNonNull(key, "polsmap key")), value);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
        this.polsmap.clear();
        for (Map.Entry<RetentionPolicy, ? extends Integer> e : entries.entrySet()) {
            RetentionPolicy k = e.getKey();
            Integer v = e.getValue();
            this.polsmap.put((RetentionPolicy)((Enum)Objects.requireNonNull(k, "polsmap key")), Objects.requireNonNull(v, "polsmap value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putAllPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
        for (Map.Entry<RetentionPolicy, ? extends Integer> e : entries.entrySet()) {
            RetentionPolicy k = e.getKey();
            Integer v = e.getValue();
            this.polsmap.put((RetentionPolicy)((Enum)Objects.requireNonNull(k, "polsmap key")), Objects.requireNonNull(v, "polsmap value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putNavsmap(String key, int value) {
        this.navsmap.put(Objects.requireNonNull(key, "navsmap key"), value);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion setNavsmap(Map<String, ? extends Integer> entries) {
        this.navsmap.clear();
        for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
            String k = e.getKey();
            Integer v = e.getValue();
            this.navsmap.put(Objects.requireNonNull(k, "navsmap key"), Objects.requireNonNull(v, "navsmap value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableCompanion putAllNavsmap(Map<String, ? extends Integer> entries) {
        for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
            String k = e.getKey();
            Integer v = e.getValue();
            this.navsmap.put(Objects.requireNonNull(k, "navsmap key"), Objects.requireNonNull(v, "navsmap value"));
        }
        return this;
    }

    public final boolean integerIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean stringIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final boolean arrayIntsIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    public final boolean arrayStringsIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion unsetInteger() {
        this.initBits |= 1L;
        this.integer = 0;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion unsetString() {
        this.initBits |= 2L;
        this.string = null;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion unsetArrayInts() {
        this.initBits |= 4L;
        this.arrayInts = null;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableCompanion unsetArrayStrings() {
        this.initBits |= 8L;
        this.arrayStrings = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.integerIsSet()) {
            attributes.add("integer");
        }
        if (!this.stringIsSet()) {
            attributes.add("string");
        }
        if (!this.arrayIntsIsSet()) {
            attributes.add("arrayInts");
        }
        if (!this.arrayStringsIsSet()) {
            attributes.add("arrayStrings");
        }
        return "Companion is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableCompanion toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableCompanion.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableCompanion)) {
            return false;
        }
        ModifiableCompanion other = (ModifiableCompanion)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableCompanion another) {
        return this.integer == another.integer && this.string.equals(another.string) && Objects.equals(this.bools, another.bools) && this.str.equals(another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Arrays.equals(this.arrayStrings, another.arrayStrings) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs) && this.just.equals(another.just) && this.ordsmap.equals(another.ordsmap) && this.polsmap.equals((Object)another.polsmap) && this.navsmap.equals(another.navsmap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.integer;
        h += (h << 5) + this.string.hashCode();
        h += (h << 5) + Objects.hashCode(this.bools);
        h += (h << 5) + this.str.hashCode();
        h += (h << 5) + this.ints.hashCode();
        h += (h << 5) + Arrays.hashCode(this.arrayInts);
        h += (h << 5) + Arrays.hashCode(this.arrayStrings);
        h += (h << 5) + this.ords.hashCode();
        h += (h << 5) + this.pols.hashCode();
        h += (h << 5) + this.navs.hashCode();
        h += (h << 5) + this.just.hashCode();
        h += (h << 5) + this.ordsmap.hashCode();
        h += (h << 5) + this.polsmap.hashCode();
        h += (h << 5) + this.navsmap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableCompanion").add("integer", this.integerIsSet() ? Integer.valueOf(this.integer()) : "?").add("string", (Object)(this.stringIsSet() ? this.string() : "?")).add("bools", (Object)this.bools()).add("str", this.str()).add("ints", this.ints()).add("arrayInts", (Object)(this.arrayIntsIsSet() ? Arrays.toString(this.arrayInts()) : "?")).add("arrayStrings", (Object)(this.arrayStringsIsSet() ? Arrays.toString(this.arrayStrings()) : "?")).add("ords", this.ords()).add("pols", this.pols()).add("navs", this.navs()).add("just", this.just()).add("ordsmap", this.ordsmap()).add("polsmap", this.polsmap()).add("navsmap", this.navsmap()).toString();
    }
}

