/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.AllowNullsObject;
import org.immutables.fixture.modifiable.ImmutableAllowNullsObject;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AllowNullsObject", generator="Modifiables")
@NotThreadSafe
public final class ModifiableAllowNullsObject
implements AllowNullsObject {
    private final Map<String, String> map = new LinkedHashMap<String, String>();
    private final ArrayList<String> list = new ArrayList();

    private ModifiableAllowNullsObject() {
    }

    public static ModifiableAllowNullsObject create() {
        return new ModifiableAllowNullsObject();
    }

    @Override
    public final Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public final List<String> getList() {
        return this.list;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject clear() {
        this.map.clear();
        this.list.clear();
        return this;
    }

    public ModifiableAllowNullsObject from(AllowNullsObject instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableAllowNullsObject) {
            this.from((ModifiableAllowNullsObject)instance);
            return this;
        }
        this.putAllMap(instance.getMap());
        this.addAllList(instance.getList());
        return this;
    }

    public ModifiableAllowNullsObject from(ModifiableAllowNullsObject instance) {
        Objects.requireNonNull(instance, "instance");
        this.putAllMap(instance.getMap());
        this.addAllList(instance.getList());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject putMap(String key, String value) {
        this.map.put(Objects.requireNonNull(key, "map key"), value);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject setMap(Map<String, ? extends String> entries) {
        this.map.clear();
        this.putAllMap(entries);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject putAllMap(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), v);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject addList(String element) {
        this.list.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableAllowNullsObject addList(String ... elements) {
        for (String e : elements) {
            this.addList(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject setList(Iterable<String> elements) {
        this.list.clear();
        this.addAllList(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableAllowNullsObject addAllList(Iterable<String> elements) {
        for (String e : elements) {
            this.addList(e);
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableAllowNullsObject toImmutable() {
        return ImmutableAllowNullsObject.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableAllowNullsObject)) {
            return false;
        }
        ModifiableAllowNullsObject other = (ModifiableAllowNullsObject)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableAllowNullsObject another) {
        return this.map.equals(another.map) && this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.list.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableAllowNullsObject{map=" + this.getMap() + ", list=" + this.getList() + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

