/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ModifiableNullableList;
import org.immutables.fixture.modifiable.NullableList;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullableList", generator="Immutables")
@Immutable
public final class ImmutableNullableList
implements NullableList {
    @Nullable
    private final Object object;
    @Nullable
    private final ImmutableList<Object> objects;

    private ImmutableNullableList(@Nullable Object object, @Nullable ImmutableList<Object> objects) {
        this.object = object;
        this.objects = objects;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.object;
    }

    @Nullable
    public ImmutableList<Object> getObjects() {
        return this.objects;
    }

    public final ImmutableNullableList withObject(@Nullable Object value) {
        if (this.object == value) {
            return this;
        }
        return new ImmutableNullableList(value, this.objects);
    }

    public final ImmutableNullableList withObjects(Object ... elements) {
        if (elements == null) {
            return new ImmutableNullableList(this.object, null);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableNullableList(this.object, (ImmutableList<Object>)newValue);
    }

    public final ImmutableNullableList withObjects(@Nullable Iterable<? extends Object> elements) {
        if (this.objects == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableNullableList(this.object, (ImmutableList<Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableList && this.equalTo(0, (ImmutableNullableList)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableList another) {
        return Objects.equals(this.object, another.object) && Objects.equals(this.objects, another.objects);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.object);
        h += (h << 5) + Objects.hashCode(this.objects);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableList").omitNullValues().add("object", this.object).add("objects", this.objects).toString();
    }

    public static ImmutableNullableList copyOf(NullableList instance) {
        if (instance instanceof ImmutableNullableList) {
            return (ImmutableNullableList)instance;
        }
        return ImmutableNullableList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NullableList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Object object;
        private ImmutableList.Builder<Object> objects = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableNullableList instance) {
            List<Object> objectsValue;
            Objects.requireNonNull(instance, "instance");
            Object objectValue = instance.getObject();
            if (objectValue != null) {
                this.object(objectValue);
            }
            if ((objectsValue = instance.getObjects()) != null) {
                this.addAllObjects(objectsValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NullableList instance) {
            List<Object> objectsValue;
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableNullableList) {
                return this.from((ModifiableNullableList)instance);
            }
            Object objectValue = instance.getObject();
            if (objectValue != null) {
                this.object(objectValue);
            }
            if ((objectsValue = instance.getObjects()) != null) {
                this.addAllObjects(objectsValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(@Nullable Object object) {
            this.object = object;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjects(Object element) {
            if (this.objects == null) {
                this.objects = ImmutableList.builder();
            }
            this.objects.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjects(Object ... elements) {
            if (this.objects == null) {
                this.objects = ImmutableList.builder();
            }
            this.objects.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objects(@Nullable Iterable<? extends Object> elements) {
            if (elements == null) {
                this.objects = null;
                return this;
            }
            this.objects = ImmutableList.builder();
            return this.addAllObjects(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjects(Iterable<? extends Object> elements) {
            Objects.requireNonNull(elements, "objects element");
            if (this.objects == null) {
                this.objects = ImmutableList.builder();
            }
            this.objects.addAll(elements);
            return this;
        }

        public ImmutableNullableList build() {
            return new ImmutableNullableList(this.object, this.objects == null ? null : this.objects.build());
        }
    }
}

