/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;
import org.immutables.fixture.modifiable.ModifiableNullableAndDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Companion.NullableAndDefault", generator="Immutables")
@Immutable
public final class ImmutableNullableAndDefault
implements Companion.NullableAndDefault {
    private final ImmutableList<String> lst;
    @Nullable
    private final ImmutableList<String> str;
    private final ImmutableSet<Integer> ints;
    private final int[] arrayInts;
    @Nullable
    private final ImmutableSortedSet<Integer> ords;
    private final ImmutableSet<RetentionPolicy> pols;
    private final ImmutableSortedSet<Integer> navs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNullableAndDefault(Builder builder) {
        ImmutableList immutableList = this.lst = builder.lst == null ? ImmutableList.of() : builder.lst.build();
        if (builder.strIsSet()) {
            this.initShim.str(builder.str == null ? null : builder.str.build());
        }
        if (builder.intsIsSet()) {
            this.initShim.ints((ImmutableSet<Integer>)(builder.ints == null ? ImmutableSet.of() : builder.ints.build()));
        }
        if (builder.arrayInts != null) {
            this.initShim.arrayInts(builder.arrayInts);
        }
        if (builder.ordsIsSet()) {
            this.initShim.ords(builder.ords == null ? null : builder.ords.build());
        }
        if (builder.polsIsSet()) {
            this.initShim.pols((ImmutableSet<RetentionPolicy>)(builder.pols == null ? ImmutableSet.of() : Sets.immutableEnumSet((Iterable)builder.pols.build())));
        }
        if (builder.navsIsSet()) {
            this.initShim.navs((ImmutableSortedSet<Integer>)(builder.navs == null ? ImmutableSortedSet.of() : builder.navs.build()));
        }
        this.str = this.initShim.str();
        this.ints = this.initShim.ints();
        this.arrayInts = this.initShim.arrayInts();
        this.ords = this.initShim.ords();
        this.pols = this.initShim.pols();
        this.navs = this.initShim.navs();
        this.initShim = null;
    }

    private ImmutableNullableAndDefault(ImmutableList<String> lst, @Nullable ImmutableList<String> str, ImmutableSet<Integer> ints, int[] arrayInts, @Nullable ImmutableSortedSet<Integer> ords, ImmutableSet<RetentionPolicy> pols, ImmutableSortedSet<Integer> navs) {
        this.lst = lst;
        this.str = str;
        this.ints = ints;
        this.arrayInts = arrayInts;
        this.ords = ords;
        this.pols = pols;
        this.navs = navs;
        this.initShim = null;
    }

    @Nullable
    private List<String> strInitialize() {
        return Companion.NullableAndDefault.super.str();
    }

    private Set<Integer> intsInitialize() {
        return Companion.NullableAndDefault.super.ints();
    }

    private int[] arrayIntsInitialize() {
        return Companion.NullableAndDefault.super.arrayInts();
    }

    @Nullable
    private SortedSet<Integer> ordsInitialize() {
        return Companion.NullableAndDefault.super.ords();
    }

    private Set<RetentionPolicy> polsInitialize() {
        return Companion.NullableAndDefault.super.pols();
    }

    private NavigableSet<Integer> navsInitialize() {
        return Companion.NullableAndDefault.super.navs();
    }

    public ImmutableList<String> lst() {
        return this.lst;
    }

    @Nullable
    public ImmutableList<String> str() {
        InitShim shim = this.initShim;
        return shim != null ? shim.str() : this.str;
    }

    public ImmutableSet<Integer> ints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ints() : this.ints;
    }

    @Override
    public int[] arrayInts() {
        InitShim shim = this.initShim;
        return shim != null ? (int[])shim.arrayInts().clone() : (int[])this.arrayInts.clone();
    }

    @Nullable
    public ImmutableSortedSet<Integer> ords() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ords() : this.ords;
    }

    public ImmutableSet<RetentionPolicy> pols() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pols() : this.pols;
    }

    public ImmutableSortedSet<Integer> navs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.navs() : this.navs;
    }

    public final ImmutableNullableAndDefault withLst(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNullableAndDefault((ImmutableList<String>)newValue, this.str, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withLst(Iterable<String> elements) {
        if (this.lst == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNullableAndDefault((ImmutableList<String>)newValue, this.str, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withStr(String ... elements) {
        if (elements == null) {
            return new ImmutableNullableAndDefault(this.lst, null, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableNullableAndDefault(this.lst, (ImmutableList<String>)newValue, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withStr(@Nullable Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableNullableAndDefault(this.lst, (ImmutableList<String>)newValue, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withInts(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableNullableAndDefault(this.lst, this.str, (ImmutableSet<Integer>)newValue, this.arrayInts, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableNullableAndDefault(this.lst, this.str, (ImmutableSet<Integer>)newValue, this.arrayInts, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withArrayInts(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, newValue, this.ords, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withOrds(int ... elements) {
        if (elements == null) {
            return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, null, this.pols, this.navs);
        }
        ImmutableSortedSet newValue = Ints.asList((int[])elements) == null ? null : ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), (Collection)Ints.asList((int[])elements));
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, (ImmutableSortedSet<Integer>)newValue, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withOrds(@Nullable Iterable<Integer> elements) {
        if (this.ords == elements) {
            return this;
        }
        ImmutableSortedSet newValue = elements == null ? null : ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, (ImmutableSortedSet<Integer>)newValue, this.pols, this.navs);
    }

    public final ImmutableNullableAndDefault withPols(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, (ImmutableSet<RetentionPolicy>)newValue, this.navs);
    }

    public final ImmutableNullableAndDefault withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, (ImmutableSet<RetentionPolicy>)newValue, this.navs);
    }

    public final ImmutableNullableAndDefault withNavs(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), (Collection)Ints.asList((int[])elements));
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, this.pols, (ImmutableSortedSet<Integer>)newValue);
    }

    public final ImmutableNullableAndDefault withNavs(Iterable<Integer> elements) {
        if (this.navs == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, this.pols, (ImmutableSortedSet<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableAndDefault && this.equalTo(0, (ImmutableNullableAndDefault)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableAndDefault another) {
        return this.lst.equals(another.lst) && Objects.equals(this.str, another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Objects.equals(this.ords, another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lst.hashCode();
        h += (h << 5) + Objects.hashCode(this.str);
        h += (h << 5) + this.ints.hashCode();
        h += (h << 5) + Arrays.hashCode(this.arrayInts);
        h += (h << 5) + Objects.hashCode(this.ords);
        h += (h << 5) + this.pols.hashCode();
        h += (h << 5) + this.navs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableAndDefault").omitNullValues().add("lst", this.lst).add("str", this.str).add("ints", this.ints).add("arrayInts", (Object)Arrays.toString(this.arrayInts)).add("ords", this.ords).add("pols", this.pols).add("navs", this.navs).toString();
    }

    public static ImmutableNullableAndDefault copyOf(Companion.NullableAndDefault instance) {
        if (instance instanceof ImmutableNullableAndDefault) {
            return (ImmutableNullableAndDefault)instance;
        }
        return ImmutableNullableAndDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Companion.NullableAndDefault", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_STR = 1L;
        private static final long OPT_BIT_INTS = 2L;
        private static final long OPT_BIT_ORDS = 4L;
        private static final long OPT_BIT_POLS = 8L;
        private static final long OPT_BIT_NAVS = 16L;
        private long optBits;
        private ImmutableList.Builder<String> lst = null;
        private ImmutableList.Builder<String> str = null;
        private ImmutableSet.Builder<Integer> ints = null;
        @Nullable
        private int[] arrayInts;
        private ImmutableSortedSet.Builder<Integer> ords = null;
        private ImmutableSet.Builder<RetentionPolicy> pols = null;
        private ImmutableSortedSet.Builder<Integer> navs = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableNullableAndDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllLst(instance.lst());
            List<String> strValue = instance.str();
            if (strValue != null) {
                this.addAllStr(strValue);
            }
            this.addAllInts(instance.ints());
            this.arrayInts(instance.arrayInts());
            SortedSet<Integer> ordsValue = instance.ords();
            if (ordsValue != null) {
                this.addAllOrds(ordsValue);
            }
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Companion.NullableAndDefault instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableNullableAndDefault) {
                return this.from((ModifiableNullableAndDefault)instance);
            }
            this.addAllLst(instance.lst());
            List<String> strValue = instance.str();
            if (strValue != null) {
                this.addAllStr(strValue);
            }
            this.addAllInts(instance.ints());
            this.arrayInts(instance.arrayInts());
            SortedSet<Integer> ordsValue = instance.ords();
            if (ordsValue != null) {
                this.addAllOrds(ordsValue);
            }
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLst(String element) {
            if (this.lst == null) {
                this.lst = ImmutableList.builder();
            }
            this.lst.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLst(String ... elements) {
            if (this.lst == null) {
                this.lst = ImmutableList.builder();
            }
            this.lst.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lst(Iterable<String> elements) {
            this.lst = ImmutableList.builder();
            return this.addAllLst(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLst(Iterable<String> elements) {
            Objects.requireNonNull(elements, "lst element");
            if (this.lst == null) {
                this.lst = ImmutableList.builder();
            }
            this.lst.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStr(String element) {
            if (this.str == null) {
                this.str = ImmutableList.builder();
            }
            this.str.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStr(String ... elements) {
            if (this.str == null) {
                this.str = ImmutableList.builder();
            }
            this.str.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder str(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.str = null;
                this.optBits |= 1L;
                return this;
            }
            this.str = ImmutableList.builder();
            return this.addAllStr(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStr(Iterable<String> elements) {
            Objects.requireNonNull(elements, "str element");
            if (this.str == null) {
                this.str = ImmutableList.builder();
            }
            this.str.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int element) {
            if (this.ints == null) {
                this.ints = ImmutableSet.builder();
            }
            this.ints.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int ... elements) {
            if (this.ints == null) {
                this.ints = ImmutableSet.builder();
            }
            this.ints.addAll((Iterable)Ints.asList((int[])elements));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ints(Iterable<Integer> elements) {
            this.ints = ImmutableSet.builder();
            return this.addAllInts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ints element");
            if (this.ints == null) {
                this.ints = ImmutableSet.builder();
            }
            this.ints.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder arrayInts(int ... arrayInts) {
            this.arrayInts = (int[])arrayInts.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOrds(int element) {
            if (this.ords == null) {
                this.ords = ImmutableSortedSet.naturalOrder();
            }
            this.ords.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOrds(int ... elements) {
            if (this.ords == null) {
                this.ords = ImmutableSortedSet.naturalOrder();
            }
            this.ords.addAll((Iterable)Ints.asList((int[])elements));
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ords(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ords = null;
                this.optBits |= 4L;
                return this;
            }
            this.ords = ImmutableSortedSet.naturalOrder();
            return this.addAllOrds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOrds(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ords element");
            if (this.ords == null) {
                this.ords = ImmutableSortedSet.naturalOrder();
            }
            this.ords.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPols(RetentionPolicy element) {
            if (this.pols == null) {
                this.pols = ImmutableSet.builder();
            }
            this.pols.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPols(RetentionPolicy ... elements) {
            if (this.pols == null) {
                this.pols = ImmutableSet.builder();
            }
            this.pols.addAll(Arrays.asList(elements));
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.pols = ImmutableSet.builder();
            return this.addAllPols(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            Objects.requireNonNull(elements, "pols element");
            if (this.pols == null) {
                this.pols = ImmutableSet.builder();
            }
            this.pols.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNavs(int element) {
            if (this.navs == null) {
                this.navs = ImmutableSortedSet.reverseOrder();
            }
            this.navs.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNavs(int ... elements) {
            if (this.navs == null) {
                this.navs = ImmutableSortedSet.reverseOrder();
            }
            this.navs.addAll((Iterable)Ints.asList((int[])elements));
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder navs(Iterable<Integer> elements) {
            this.navs = ImmutableSortedSet.reverseOrder();
            return this.addAllNavs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNavs(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "navs element");
            if (this.navs == null) {
                this.navs = ImmutableSortedSet.reverseOrder();
            }
            this.navs.addAll(elements);
            this.optBits |= 0x10L;
            return this;
        }

        public ImmutableNullableAndDefault build() {
            return new ImmutableNullableAndDefault(this);
        }

        private boolean strIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean intsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean ordsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean polsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean navsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Generated(from="Companion.NullableAndDefault", generator="Immutables")
    private final class InitShim {
        private byte strBuildStage = 0;
        private ImmutableList<String> str;
        private byte intsBuildStage = 0;
        private ImmutableSet<Integer> ints;
        private byte arrayIntsBuildStage = 0;
        private int[] arrayInts;
        private byte ordsBuildStage = 0;
        private ImmutableSortedSet<Integer> ords;
        private byte polsBuildStage = 0;
        private ImmutableSet<RetentionPolicy> pols;
        private byte navsBuildStage = 0;
        private ImmutableSortedSet<Integer> navs;

        private InitShim() {
        }

        ImmutableList<String> str() {
            if (this.strBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.strBuildStage == 0) {
                this.strBuildStage = (byte)-1;
                this.str = ImmutableNullableAndDefault.this.strInitialize() == null ? null : ImmutableList.copyOf((Collection)ImmutableNullableAndDefault.this.strInitialize());
                this.strBuildStage = 1;
            }
            return this.str;
        }

        void str(ImmutableList<String> str) {
            this.str = str;
            this.strBuildStage = 1;
        }

        ImmutableSet<Integer> ints() {
            if (this.intsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.intsBuildStage == 0) {
                this.intsBuildStage = (byte)-1;
                this.ints = ImmutableSet.copyOf((Collection)ImmutableNullableAndDefault.this.intsInitialize());
                this.intsBuildStage = 1;
            }
            return this.ints;
        }

        void ints(ImmutableSet<Integer> ints) {
            this.ints = ints;
            this.intsBuildStage = 1;
        }

        int[] arrayInts() {
            if (this.arrayIntsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.arrayIntsBuildStage == 0) {
                this.arrayIntsBuildStage = (byte)-1;
                this.arrayInts = (int[])ImmutableNullableAndDefault.this.arrayIntsInitialize().clone();
                this.arrayIntsBuildStage = 1;
            }
            return this.arrayInts;
        }

        void arrayInts(int[] arrayInts) {
            this.arrayInts = arrayInts;
            this.arrayIntsBuildStage = 1;
        }

        ImmutableSortedSet<Integer> ords() {
            if (this.ordsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ordsBuildStage == 0) {
                this.ordsBuildStage = (byte)-1;
                this.ords = ImmutableNullableAndDefault.this.ordsInitialize() == null ? null : ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), (Collection)ImmutableNullableAndDefault.this.ordsInitialize());
                this.ordsBuildStage = 1;
            }
            return this.ords;
        }

        void ords(ImmutableSortedSet<Integer> ords) {
            this.ords = ords;
            this.ordsBuildStage = 1;
        }

        ImmutableSet<RetentionPolicy> pols() {
            if (this.polsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.polsBuildStage == 0) {
                this.polsBuildStage = (byte)-1;
                this.pols = Sets.immutableEnumSet((Iterable)ImmutableNullableAndDefault.this.polsInitialize());
                this.polsBuildStage = 1;
            }
            return this.pols;
        }

        void pols(ImmutableSet<RetentionPolicy> pols) {
            this.pols = pols;
            this.polsBuildStage = 1;
        }

        ImmutableSortedSet<Integer> navs() {
            if (this.navsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.navsBuildStage == 0) {
                this.navsBuildStage = (byte)-1;
                this.navs = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), (Collection)ImmutableNullableAndDefault.this.navsInitialize());
                this.navsBuildStage = 1;
            }
            return this.navs;
        }

        void navs(ImmutableSortedSet<Integer> navs) {
            this.navs = navs;
            this.navsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.strBuildStage == -1) {
                attributes.add("str");
            }
            if (this.intsBuildStage == -1) {
                attributes.add("ints");
            }
            if (this.arrayIntsBuildStage == -1) {
                attributes.add("arrayInts");
            }
            if (this.ordsBuildStage == -1) {
                attributes.add("ords");
            }
            if (this.polsBuildStage == -1) {
                attributes.add("pols");
            }
            if (this.navsBuildStage == -1) {
                attributes.add("navs");
            }
            return "Cannot build NullableAndDefault, attribute initializers form cycle " + attributes;
        }
    }
}

