/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;
import org.immutables.fixture.modifiable.ModifiableCompanion;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Companion", generator="Immutables")
@Immutable
public final class ImmutableCompanion
implements Companion {
    private final int integer;
    private final String string;
    @Nullable
    private final Boolean bools;
    private final ImmutableList<String> str;
    private final ImmutableSet<Integer> ints;
    private final int[] arrayInts;
    private final String[] arrayStrings;
    private final ImmutableSortedSet<Integer> ords;
    private final ImmutableSet<RetentionPolicy> pols;
    private final ImmutableSortedSet<Integer> navs;
    private final ImmutableMap<Long, Integer> just;
    private final ImmutableSortedMap<Integer, String> ordsmap;
    private final ImmutableMap<RetentionPolicy, Integer> polsmap;
    private final ImmutableSortedMap<String, Integer> navsmap;

    private ImmutableCompanion(int integer, String string, @Nullable Boolean bools, ImmutableList<String> str, ImmutableSet<Integer> ints, int[] arrayInts, String[] arrayStrings, ImmutableSortedSet<Integer> ords, ImmutableSet<RetentionPolicy> pols, ImmutableSortedSet<Integer> navs, ImmutableMap<Long, Integer> just, ImmutableSortedMap<Integer, String> ordsmap, ImmutableMap<RetentionPolicy, Integer> polsmap, ImmutableSortedMap<String, Integer> navsmap) {
        this.integer = integer;
        this.string = string;
        this.bools = bools;
        this.str = str;
        this.ints = ints;
        this.arrayInts = arrayInts;
        this.arrayStrings = arrayStrings;
        this.ords = ords;
        this.pols = pols;
        this.navs = navs;
        this.just = just;
        this.ordsmap = ordsmap;
        this.polsmap = polsmap;
        this.navsmap = navsmap;
    }

    @Override
    public int integer() {
        return this.integer;
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    @Nullable
    public Boolean bools() {
        return this.bools;
    }

    public ImmutableList<String> str() {
        return this.str;
    }

    public ImmutableSet<Integer> ints() {
        return this.ints;
    }

    @Override
    public int[] arrayInts() {
        return (int[])this.arrayInts.clone();
    }

    @Override
    public String[] arrayStrings() {
        return (String[])this.arrayStrings.clone();
    }

    public ImmutableSortedSet<Integer> ords() {
        return this.ords;
    }

    public ImmutableSet<RetentionPolicy> pols() {
        return this.pols;
    }

    public ImmutableSortedSet<Integer> navs() {
        return this.navs;
    }

    public ImmutableMap<Long, Integer> just() {
        return this.just;
    }

    public ImmutableSortedMap<Integer, String> ordsmap() {
        return this.ordsmap;
    }

    public ImmutableMap<RetentionPolicy, Integer> polsmap() {
        return this.polsmap;
    }

    public ImmutableSortedMap<String, Integer> navsmap() {
        return this.navsmap;
    }

    public final ImmutableCompanion withInteger(int value) {
        if (this.integer == value) {
            return this;
        }
        return new ImmutableCompanion(value, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withString(String value) {
        String newValue = Objects.requireNonNull(value, "string");
        if (this.string.equals(newValue)) {
            return this;
        }
        return new ImmutableCompanion(this.integer, newValue, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withBools(@Nullable Boolean value) {
        if (Objects.equals(this.bools, value)) {
            return this;
        }
        return new ImmutableCompanion(this.integer, this.string, value, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withStr(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, (ImmutableList<String>)newValue, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withStr(Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, (ImmutableList<String>)newValue, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withInts(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, (ImmutableSet<Integer>)newValue, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, (ImmutableSet<Integer>)newValue, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withArrayInts(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, newValue, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withArrayStrings(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, newValue, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withOrds(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), (Collection)Ints.asList((int[])elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, (ImmutableSortedSet<Integer>)newValue, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withOrds(Iterable<Integer> elements) {
        if (this.ords == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, (ImmutableSortedSet<Integer>)newValue, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withPols(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, (ImmutableSet<RetentionPolicy>)newValue, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, (ImmutableSet<RetentionPolicy>)newValue, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withNavs(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), (Collection)Ints.asList((int[])elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, (ImmutableSortedSet<Integer>)newValue, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withNavs(Iterable<Integer> elements) {
        if (this.navs == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, (ImmutableSortedSet<Integer>)newValue, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withJust(Map<Long, ? extends Integer> entries) {
        if (this.just == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, (ImmutableMap<Long, Integer>)newValue, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withOrdsmap(Map<Integer, ? extends String> entries) {
        if (this.ordsmap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, (ImmutableSortedMap<Integer, String>)newValue, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
        if (this.polsmap == entries) {
            return this;
        }
        ImmutableMap newValue = Maps.immutableEnumMap(entries);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, (ImmutableMap<RetentionPolicy, Integer>)newValue, this.navsmap);
    }

    public final ImmutableCompanion withNavsmap(Map<String, ? extends Integer> entries) {
        if (this.navsmap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural().reverse());
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, (ImmutableSortedMap<String, Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompanion && this.equalTo(0, (ImmutableCompanion)another);
    }

    private boolean equalTo(int synthetic, ImmutableCompanion another) {
        return this.integer == another.integer && this.string.equals(another.string) && Objects.equals(this.bools, another.bools) && this.str.equals(another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Arrays.equals(this.arrayStrings, another.arrayStrings) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs) && this.just.equals(another.just) && this.ordsmap.equals(another.ordsmap) && this.polsmap.equals(another.polsmap) && this.navsmap.equals(another.navsmap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.integer;
        h += (h << 5) + this.string.hashCode();
        h += (h << 5) + Objects.hashCode(this.bools);
        h += (h << 5) + this.str.hashCode();
        h += (h << 5) + this.ints.hashCode();
        h += (h << 5) + Arrays.hashCode(this.arrayInts);
        h += (h << 5) + Arrays.hashCode(this.arrayStrings);
        h += (h << 5) + this.ords.hashCode();
        h += (h << 5) + this.pols.hashCode();
        h += (h << 5) + this.navs.hashCode();
        h += (h << 5) + this.just.hashCode();
        h += (h << 5) + this.ordsmap.hashCode();
        h += (h << 5) + this.polsmap.hashCode();
        h += (h << 5) + this.navsmap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Companion").omitNullValues().add("integer", this.integer).add("string", (Object)this.string).add("bools", (Object)this.bools).add("str", this.str).add("ints", this.ints).add("arrayInts", (Object)Arrays.toString(this.arrayInts)).add("arrayStrings", (Object)Arrays.toString(this.arrayStrings)).add("ords", this.ords).add("pols", this.pols).add("navs", this.navs).add("just", this.just).add("ordsmap", this.ordsmap).add("polsmap", this.polsmap).add("navsmap", this.navsmap).toString();
    }

    public static ImmutableCompanion copyOf(Companion instance) {
        if (instance instanceof ImmutableCompanion) {
            return (ImmutableCompanion)instance;
        }
        return ImmutableCompanion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Companion", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INTEGER = 1L;
        private static final long INIT_BIT_STRING = 2L;
        private static final long INIT_BIT_ARRAY_INTS = 4L;
        private static final long INIT_BIT_ARRAY_STRINGS = 8L;
        private long initBits = 15L;
        private int integer;
        @Nullable
        private String string;
        @Nullable
        private Boolean bools;
        private ImmutableList.Builder<String> str = ImmutableList.builder();
        private ImmutableSet.Builder<Integer> ints = ImmutableSet.builder();
        @Nullable
        private int[] arrayInts;
        @Nullable
        private String[] arrayStrings;
        private ImmutableSortedSet.Builder<Integer> ords = ImmutableSortedSet.naturalOrder();
        private ImmutableSet.Builder<RetentionPolicy> pols = ImmutableSet.builder();
        private ImmutableSortedSet.Builder<Integer> navs = ImmutableSortedSet.reverseOrder();
        private ImmutableMap.Builder<Long, Integer> just = ImmutableMap.builder();
        private ImmutableSortedMap.Builder<Integer, String> ordsmap = ImmutableSortedMap.naturalOrder();
        private ImmutableMap.Builder<RetentionPolicy, Integer> polsmap = ImmutableMap.builder();
        private ImmutableSortedMap.Builder<String, Integer> navsmap = ImmutableSortedMap.reverseOrder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableCompanion instance) {
            Boolean boolsValue;
            Objects.requireNonNull(instance, "instance");
            if (instance.integerIsSet()) {
                this.integer(instance.integer());
            }
            if (instance.stringIsSet()) {
                this.string(instance.string());
            }
            if ((boolsValue = instance.bools()) != null) {
                this.bools(boolsValue);
            }
            this.addAllStr(instance.str());
            this.addAllInts(instance.ints());
            if (instance.arrayIntsIsSet()) {
                this.arrayInts(instance.arrayInts());
            }
            if (instance.arrayStringsIsSet()) {
                this.arrayStrings(instance.arrayStrings());
            }
            this.addAllOrds(instance.ords());
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            this.putAllJust(instance.just());
            this.putAllOrdsmap(instance.ordsmap());
            this.putAllPolsmap(instance.polsmap());
            this.putAllNavsmap(instance.navsmap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Companion instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableCompanion) {
                return this.from((ModifiableCompanion)instance);
            }
            this.integer(instance.integer());
            this.string(instance.string());
            Boolean boolsValue = instance.bools();
            if (boolsValue != null) {
                this.bools(boolsValue);
            }
            this.addAllStr(instance.str());
            this.addAllInts(instance.ints());
            this.arrayInts(instance.arrayInts());
            this.arrayStrings(instance.arrayStrings());
            this.addAllOrds(instance.ords());
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            this.putAllJust(instance.just());
            this.putAllOrdsmap(instance.ordsmap());
            this.putAllPolsmap(instance.polsmap());
            this.putAllNavsmap(instance.navsmap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder integer(int integer) {
            this.integer = integer;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder string(String string) {
            this.string = Objects.requireNonNull(string, "string");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bools(@Nullable Boolean bools) {
            this.bools = bools;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStr(String element) {
            this.str.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStr(String ... elements) {
            this.str.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder str(Iterable<String> elements) {
            this.str = ImmutableList.builder();
            return this.addAllStr(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStr(Iterable<String> elements) {
            this.str.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int element) {
            this.ints.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int ... elements) {
            this.ints.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ints(Iterable<Integer> elements) {
            this.ints = ImmutableSet.builder();
            return this.addAllInts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInts(Iterable<Integer> elements) {
            this.ints.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder arrayInts(int ... arrayInts) {
            this.arrayInts = (int[])arrayInts.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder arrayStrings(String ... arrayStrings) {
            this.arrayStrings = (String[])arrayStrings.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOrds(int element) {
            this.ords.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOrds(int ... elements) {
            this.ords.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ords(Iterable<Integer> elements) {
            this.ords = ImmutableSortedSet.naturalOrder();
            return this.addAllOrds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOrds(Iterable<Integer> elements) {
            this.ords.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPols(RetentionPolicy element) {
            this.pols.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPols(RetentionPolicy ... elements) {
            this.pols.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.pols = ImmutableSet.builder();
            return this.addAllPols(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            this.pols.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNavs(int element) {
            this.navs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNavs(int ... elements) {
            this.navs.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder navs(Iterable<Integer> elements) {
            this.navs = ImmutableSortedSet.reverseOrder();
            return this.addAllNavs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNavs(Iterable<Integer> elements) {
            this.navs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putJust(long key, int value) {
            this.just.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putJust(Map.Entry<Long, ? extends Integer> entry) {
            this.just.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder just(Map<Long, ? extends Integer> entries) {
            this.just = ImmutableMap.builder();
            return this.putAllJust(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllJust(Map<Long, ? extends Integer> entries) {
            this.just.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOrdsmap(int key, String value) {
            this.ordsmap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOrdsmap(Map.Entry<Integer, ? extends String> entry) {
            this.ordsmap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ordsmap(Map<Integer, ? extends String> entries) {
            this.ordsmap = ImmutableSortedMap.naturalOrder();
            return this.putAllOrdsmap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOrdsmap(Map<Integer, ? extends String> entries) {
            this.ordsmap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPolsmap(RetentionPolicy key, int value) {
            this.polsmap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPolsmap(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
            this.polsmap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder polsmap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.polsmap = ImmutableMap.builder();
            return this.putAllPolsmap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.polsmap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNavsmap(String key, int value) {
            this.navsmap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNavsmap(Map.Entry<String, ? extends Integer> entry) {
            this.navsmap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder navsmap(Map<String, ? extends Integer> entries) {
            this.navsmap = ImmutableSortedMap.reverseOrder();
            return this.putAllNavsmap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNavsmap(Map<String, ? extends Integer> entries) {
            this.navsmap.putAll(entries);
            return this;
        }

        public ImmutableCompanion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompanion(this.integer, this.string, this.bools, this.str.build(), this.ints.build(), this.arrayInts, this.arrayStrings, this.ords.build(), Sets.immutableEnumSet((Iterable)this.pols.build()), this.navs.build(), this.just.build(), this.ordsmap.build(), Maps.immutableEnumMap((Map)this.polsmap.build()), this.navsmap.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("integer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("string");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arrayInts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("arrayStrings");
            }
            return "Cannot build Companion, some of required attributes are not set " + attributes;
        }
    }
}

