/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javaslang.control.Option;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.jdkonly.ImmutableUsingAllOptionals;
import org.immutables.fixture.jdkonly.UsingAllOptionals;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.jdkonly", generator="Gsons")
public final class GsonAdaptersUsingAllOptionals
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (UsingAllOptionalsTypeAdapter.adapts(type)) {
            return new UsingAllOptionalsTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersUsingAllOptionals(UsingAllOptionals)";
    }

    @Generated(from="UsingAllOptionals", generator="Gsons")
    private static class UsingAllOptionalsTypeAdapter
    extends TypeAdapter<UsingAllOptionals> {
        public final Integer v1TypeSample = null;
        public final Integer v2TypeSample = null;
        private final TypeAdapter<Integer> v1TypeAdapter;
        private final TypeAdapter<Integer> v2TypeAdapter;

        UsingAllOptionalsTypeAdapter(Gson gson) {
            this.v1TypeAdapter = gson.getAdapter(Integer.class);
            this.v2TypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return UsingAllOptionals.class == type.getRawType() || ImmutableUsingAllOptionals.class == type.getRawType();
        }

        public void write(JsonWriter out, UsingAllOptionals value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeUsingAllOptionals(out, value);
            }
        }

        public UsingAllOptionals read(JsonReader in) throws IOException {
            return this.readUsingAllOptionals(in);
        }

        private void writeUsingAllOptionals(JsonWriter out, UsingAllOptionals instance) throws IOException {
            out.beginObject();
            com.google.common.base.Optional<Integer> v1Optional = instance.v1();
            if (v1Optional.isPresent()) {
                out.name("v1");
                Integer v1Value = (Integer)v1Optional.get();
                this.v1TypeAdapter.write(out, (Object)v1Value);
            } else if (out.getSerializeNulls()) {
                out.name("v1");
                out.nullValue();
            }
            Optional<Integer> v2Optional = instance.v2();
            if (v2Optional.isPresent()) {
                out.name("v2");
                Integer v2Value = v2Optional.get();
                this.v2TypeAdapter.write(out, (Object)v2Value);
            } else if (out.getSerializeNulls()) {
                out.name("v2");
                out.nullValue();
            }
            OptionalInt i1Optional = instance.i1();
            if (i1Optional.isPresent()) {
                out.name("i1");
                int i1Value = i1Optional.getAsInt();
                out.value((long)i1Value);
            } else if (out.getSerializeNulls()) {
                out.name("i1");
                out.nullValue();
            }
            OptionalLong l1Optional = instance.l1();
            if (l1Optional.isPresent()) {
                out.name("l1");
                long l1Value = l1Optional.getAsLong();
                out.value(l1Value);
            } else if (out.getSerializeNulls()) {
                out.name("l1");
                out.nullValue();
            }
            OptionalDouble d1Optional = instance.d1();
            if (d1Optional.isPresent()) {
                out.name("d1");
                double d1Value = d1Optional.getAsDouble();
                out.value(d1Value);
            } else if (out.getSerializeNulls()) {
                out.name("d1");
                out.nullValue();
            }
            io.atlassian.fugue.Option<String> fo3Optional = instance.fo3();
            if (fo3Optional.isDefined()) {
                out.name("fo3");
                String fo3Value = (String)fo3Optional.get();
                out.value(fo3Value);
            } else if (out.getSerializeNulls()) {
                out.name("fo3");
                out.nullValue();
            }
            Option<String> jsoOptional = instance.jso();
            if (jsoOptional.isDefined()) {
                out.name("jso");
                String jsoValue = (String)jsoOptional.get();
                out.value(jsoValue);
            } else if (out.getSerializeNulls()) {
                out.name("jso");
                out.nullValue();
            }
            out.endObject();
        }

        private UsingAllOptionals readUsingAllOptionals(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableUsingAllOptionals.Builder builder = ImmutableUsingAllOptionals.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'v': {
                    if ("v1".equals(attributeName)) {
                        this.readInV1(in, builder);
                        return;
                    }
                    if (!"v2".equals(attributeName)) break;
                    this.readInV2(in, builder);
                    return;
                }
                case 'i': {
                    if (!"i1".equals(attributeName)) break;
                    this.readInI1(in, builder);
                    return;
                }
                case 'l': {
                    if (!"l1".equals(attributeName)) break;
                    this.readInL1(in, builder);
                    return;
                }
                case 'd': {
                    if (!"d1".equals(attributeName)) break;
                    this.readInD1(in, builder);
                    return;
                }
                case 'f': {
                    if (!"fo3".equals(attributeName)) break;
                    this.readInFo3(in, builder);
                    return;
                }
                case 'j': {
                    if (!"jso".equals(attributeName)) break;
                    this.readInJso(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInV1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.v1TypeAdapter.read(in);
                builder.v1(value);
            }
        }

        private void readInV2(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.v2TypeAdapter.read(in);
                builder.v2(value);
            }
        }

        private void readInI1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.i1(in.nextInt());
            }
        }

        private void readInL1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.l1(in.nextLong());
            }
        }

        private void readInD1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.d1(in.nextDouble());
            }
        }

        private void readInFo3(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.fo3(in.nextString());
            }
        }

        private void readInJso(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.jso(in.nextString());
            }
        }
    }
}

