/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.jdkonly.ImmutableJdkOptionals;
import org.immutables.fixture.jdkonly.JdkOptionals;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.jdkonly", generator="Gsons")
public final class GsonAdaptersJdkOptionals
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (JdkOptionalsTypeAdapter.adapts(type)) {
            return new JdkOptionalsTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersJdkOptionals(JdkOptionals)";
    }

    @Generated(from="JdkOptionals", generator="Gsons")
    private static class JdkOptionalsTypeAdapter
    extends TypeAdapter<JdkOptionals> {
        JdkOptionalsTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return JdkOptionals.class == type.getRawType() || ImmutableJdkOptionals.class == type.getRawType();
        }

        public void write(JsonWriter out, JdkOptionals value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeJdkOptionals(out, value);
            }
        }

        public JdkOptionals read(JsonReader in) throws IOException {
            return this.readJdkOptionals(in);
        }

        private void writeJdkOptionals(JsonWriter out, JdkOptionals instance) throws IOException {
            out.beginArray();
            Optional<String> v2Optional = instance.v2();
            if (v2Optional.isPresent()) {
                String v2Value = v2Optional.get();
                out.value(v2Value);
            } else {
                out.nullValue();
            }
            OptionalInt i1Optional = instance.i1();
            if (i1Optional.isPresent()) {
                int i1Value = i1Optional.getAsInt();
                out.value((long)i1Value);
            } else {
                out.nullValue();
            }
            OptionalLong l1Optional = instance.l1();
            if (l1Optional.isPresent()) {
                long l1Value = l1Optional.getAsLong();
                out.value(l1Value);
            } else {
                out.nullValue();
            }
            OptionalDouble d1Optional = instance.d1();
            if (d1Optional.isPresent()) {
                double d1Value = d1Optional.getAsDouble();
                out.value(d1Value);
            } else {
                out.nullValue();
            }
            out.endArray();
        }

        private JdkOptionals readJdkOptionals(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            ImmutableJdkOptionals instance = ImmutableJdkOptionals.of(this.readParameterV2(in), this.readParameterI1(in), this.readParameterL1(in), this.readParameterD1(in));
            in.endArray();
            return instance;
        }

        private Optional<String> readParameterV2(JsonReader in) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
                return Optional.empty();
            }
            return Optional.of(in.nextString());
        }

        private OptionalInt readParameterI1(JsonReader in) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
                return OptionalInt.empty();
            }
            return OptionalInt.of(in.nextInt());
        }

        private OptionalLong readParameterL1(JsonReader in) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
                return OptionalLong.empty();
            }
            return OptionalLong.of(in.nextLong());
        }

        private OptionalDouble readParameterD1(JsonReader in) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(in.nextDouble());
        }
    }
}

