/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.ToStringAndHashCodeAbstract;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ToStringAndHashCodeAbstract", generator="Immutables")
@Immutable
public final class ImmutableToStringAndHashCodeAbstract
extends ToStringAndHashCodeAbstract {
    private final long test;

    private ImmutableToStringAndHashCodeAbstract(long test) {
        this.test = test;
    }

    @Override
    @JsonProperty(value="test")
    public long test() {
        return this.test;
    }

    public final ImmutableToStringAndHashCodeAbstract withTest(long value) {
        if (this.test == value) {
            return this;
        }
        return new ImmutableToStringAndHashCodeAbstract(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToStringAndHashCodeAbstract && this.equalTo(0, (ImmutableToStringAndHashCodeAbstract)another);
    }

    private boolean equalTo(int synthetic, ImmutableToStringAndHashCodeAbstract another) {
        return this.test == another.test;
    }

    @Override
    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.test);
        return h;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"ToStringAndHashCodeAbstract").omitNullValues().add("test", this.test).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableToStringAndHashCodeAbstract fromJson(Json json) {
        Builder builder = ImmutableToStringAndHashCodeAbstract.builder();
        if (json.testIsSet) {
            builder.test(json.test);
        }
        return builder.build();
    }

    public static ImmutableToStringAndHashCodeAbstract copyOf(ToStringAndHashCodeAbstract instance) {
        if (instance instanceof ImmutableToStringAndHashCodeAbstract) {
            return (ImmutableToStringAndHashCodeAbstract)instance;
        }
        return ImmutableToStringAndHashCodeAbstract.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ToStringAndHashCodeAbstract", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEST = 1L;
        private long initBits = 1L;
        private long test;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ToStringAndHashCodeAbstract instance) {
            Objects.requireNonNull(instance, "instance");
            this.test(instance.test());
            return this;
        }

        @JsonProperty(value="test")
        @CanIgnoreReturnValue
        public final Builder test(long test) {
            this.test = test;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableToStringAndHashCodeAbstract build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToStringAndHashCodeAbstract(this.test);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("test");
            }
            return "Cannot build ToStringAndHashCodeAbstract, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ToStringAndHashCodeAbstract", generator="Immutables")
    static final class Json
    extends ToStringAndHashCodeAbstract {
        long test;
        boolean testIsSet;

        Json() {
        }

        @JsonProperty(value="test")
        public void setTest(long test) {
            this.test = test;
            this.testIsSet = true;
        }

        @Override
        public String toString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long test() {
            throw new UnsupportedOperationException();
        }
    }
}

