/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.SampleJacksonMapped;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SampleJacksonMapped", generator="Immutables")
@Immutable
public final class ImmutableSampleJacksonMapped
implements SampleJacksonMapped {
    private final String a;
    private final ImmutableList<Integer> b;
    private final Optional<SampleJacksonMapped.RegularPojo> pojo;

    private ImmutableSampleJacksonMapped(String a, ImmutableList<Integer> b, Optional<SampleJacksonMapped.RegularPojo> pojo) {
        this.a = a;
        this.b = b;
        this.pojo = pojo;
    }

    @Override
    @JsonProperty(value="a")
    public String a() {
        return this.a;
    }

    @JsonProperty(value="b")
    public ImmutableList<Integer> b() {
        return this.b;
    }

    @Override
    @JsonProperty(value="pojo")
    public Optional<SampleJacksonMapped.RegularPojo> pojo() {
        return this.pojo;
    }

    public final ImmutableSampleJacksonMapped withA(String value) {
        String newValue = Objects.requireNonNull(value, "a");
        if (this.a.equals(newValue)) {
            return this;
        }
        return new ImmutableSampleJacksonMapped(newValue, this.b, this.pojo);
    }

    public final ImmutableSampleJacksonMapped withB(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableSampleJacksonMapped(this.a, (ImmutableList<Integer>)newValue, this.pojo);
    }

    public final ImmutableSampleJacksonMapped withB(Iterable<Integer> elements) {
        if (this.b == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSampleJacksonMapped(this.a, (ImmutableList<Integer>)newValue, this.pojo);
    }

    public final ImmutableSampleJacksonMapped withPojo(SampleJacksonMapped.RegularPojo value) {
        Optional newValue = Optional.of((Object)value);
        if (this.pojo.isPresent() && this.pojo.get() == value) {
            return this;
        }
        return new ImmutableSampleJacksonMapped(this.a, this.b, (Optional<SampleJacksonMapped.RegularPojo>)newValue);
    }

    public final ImmutableSampleJacksonMapped withPojo(Optional<? extends SampleJacksonMapped.RegularPojo> optional) {
        Optional<? extends SampleJacksonMapped.RegularPojo> value = optional;
        if (!this.pojo.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.pojo.isPresent() && value.isPresent() && this.pojo.get() == value.get()) {
            return this;
        }
        return new ImmutableSampleJacksonMapped(this.a, this.b, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSampleJacksonMapped && this.equalTo(0, (ImmutableSampleJacksonMapped)another);
    }

    private boolean equalTo(int synthetic, ImmutableSampleJacksonMapped another) {
        return this.a.equals(another.a) && this.b.equals(another.b) && this.pojo.equals(another.pojo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a.hashCode();
        h += (h << 5) + this.b.hashCode();
        h += (h << 5) + this.pojo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SampleJacksonMapped").omitNullValues().add("a", (Object)this.a).add("b", this.b).add("pojo", this.pojo.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSampleJacksonMapped fromJson(Json json) {
        Builder builder = ImmutableSampleJacksonMapped.builder();
        if (json.a != null) {
            builder.a(json.a);
        }
        if (json.b != null) {
            builder.addAllB(json.b);
        }
        if (json.pojo != null) {
            builder.pojo(json.pojo);
        }
        return builder.build();
    }

    public static ImmutableSampleJacksonMapped copyOf(SampleJacksonMapped instance) {
        if (instance instanceof ImmutableSampleJacksonMapped) {
            return (ImmutableSampleJacksonMapped)instance;
        }
        return ImmutableSampleJacksonMapped.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SampleJacksonMapped", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        @Nullable
        private String a;
        private ImmutableList.Builder<Integer> b = ImmutableList.builder();
        private Optional<SampleJacksonMapped.RegularPojo> pojo = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SampleJacksonMapped instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.addAllB(instance.b());
            Optional<SampleJacksonMapped.RegularPojo> pojoOptional = instance.pojo();
            if (pojoOptional.isPresent()) {
                this.pojo(pojoOptional);
            }
            return this;
        }

        @JsonProperty(value="a")
        @CanIgnoreReturnValue
        public final Builder a(String a) {
            this.a = Objects.requireNonNull(a, "a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addB(int element) {
            this.b.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addB(int ... elements) {
            this.b.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @JsonProperty(value="b")
        @CanIgnoreReturnValue
        public final Builder b(Iterable<Integer> elements) {
            this.b = ImmutableList.builder();
            return this.addAllB(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllB(Iterable<Integer> elements) {
            this.b.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pojo(SampleJacksonMapped.RegularPojo pojo) {
            this.pojo = Optional.of((Object)pojo);
            return this;
        }

        @JsonProperty(value="pojo")
        @CanIgnoreReturnValue
        public final Builder pojo(Optional<? extends SampleJacksonMapped.RegularPojo> pojo) {
            this.pojo = pojo;
            return this;
        }

        public ImmutableSampleJacksonMapped build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSampleJacksonMapped(this.a, this.b.build(), this.pojo);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build SampleJacksonMapped, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SampleJacksonMapped", generator="Immutables")
    static final class Json
    implements SampleJacksonMapped {
        @Nullable
        String a;
        @Nullable
        List<Integer> b = ImmutableList.of();
        @Nullable
        Optional<SampleJacksonMapped.RegularPojo> pojo = Optional.absent();

        Json() {
        }

        @JsonProperty(value="a")
        public void setA(String a) {
            this.a = a;
        }

        @JsonProperty(value="b")
        public void setB(List<Integer> b) {
            this.b = b;
        }

        @JsonProperty(value="pojo")
        public void setPojo(Optional<SampleJacksonMapped.RegularPojo> pojo) {
            this.pojo = pojo;
        }

        @Override
        public String a() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> b() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SampleJacksonMapped.RegularPojo> pojo() {
            throw new UnsupportedOperationException();
        }
    }
}

