/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.MinimumAnnotationsMapped;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="MinimumAnnotationsMapped", generator="Immutables")
@Immutable
public final class ImmutableMinimumAnnotationsMapped
implements MinimumAnnotationsMapped {
    private final String a;
    private final ImmutableList<Integer> b;

    private ImmutableMinimumAnnotationsMapped(String a, ImmutableList<Integer> b) {
        this.a = a;
        this.b = b;
    }

    @Override
    @JsonProperty(value="A")
    public String a() {
        return this.a;
    }

    @JsonProperty(value="B")
    public ImmutableList<Integer> b() {
        return this.b;
    }

    public final ImmutableMinimumAnnotationsMapped withA(String value) {
        String newValue = Objects.requireNonNull(value, "a");
        if (this.a.equals(newValue)) {
            return this;
        }
        return new ImmutableMinimumAnnotationsMapped(newValue, this.b);
    }

    public final ImmutableMinimumAnnotationsMapped withB(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableMinimumAnnotationsMapped(this.a, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableMinimumAnnotationsMapped withB(Iterable<Integer> elements) {
        if (this.b == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMinimumAnnotationsMapped(this.a, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMinimumAnnotationsMapped && this.equalTo(0, (ImmutableMinimumAnnotationsMapped)another);
    }

    private boolean equalTo(int synthetic, ImmutableMinimumAnnotationsMapped another) {
        return this.a.equals(another.a) && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a.hashCode();
        h += (h << 5) + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MinimumAnnotationsMapped").omitNullValues().add("a", (Object)this.a).add("b", this.b).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMinimumAnnotationsMapped fromJson(Json json) {
        Builder builder = ImmutableMinimumAnnotationsMapped.builder();
        if (json.a != null) {
            builder.a(json.a);
        }
        if (json.b != null) {
            builder.addAllB(json.b);
        }
        return builder.build();
    }

    public static ImmutableMinimumAnnotationsMapped copyOf(MinimumAnnotationsMapped instance) {
        if (instance instanceof ImmutableMinimumAnnotationsMapped) {
            return (ImmutableMinimumAnnotationsMapped)instance;
        }
        return ImmutableMinimumAnnotationsMapped.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MinimumAnnotationsMapped", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        @Nullable
        private String a;
        private ImmutableList.Builder<Integer> b = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MinimumAnnotationsMapped instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.addAllB(instance.b());
            return this;
        }

        @JsonProperty(value="A")
        @CanIgnoreReturnValue
        public final Builder a(String a) {
            this.a = Objects.requireNonNull(a, "a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addB(int element) {
            this.b.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addB(int ... elements) {
            this.b.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @JsonProperty(value="B")
        @CanIgnoreReturnValue
        public final Builder b(Iterable<Integer> elements) {
            this.b = ImmutableList.builder();
            return this.addAllB(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllB(Iterable<Integer> elements) {
            this.b.addAll(elements);
            return this;
        }

        public ImmutableMinimumAnnotationsMapped build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMinimumAnnotationsMapped(this.a, this.b.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build MinimumAnnotationsMapped, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MinimumAnnotationsMapped", generator="Immutables")
    static final class Json
    implements MinimumAnnotationsMapped {
        @Nullable
        String a;
        @Nullable
        List<Integer> b = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="A")
        public void setA(String a) {
            this.a = a;
        }

        @JsonProperty(value="B")
        public void setB(List<Integer> b) {
            this.b = b;
        }

        @Override
        public String a() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> b() {
            throw new UnsupportedOperationException();
        }
    }
}

