/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.JsonValueCreator;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonValueCreator", generator="Immutables")
@Immutable
public final class ImmutableJsonValueCreator
implements JsonValueCreator {
    private final String value;

    private ImmutableJsonValueCreator(String value) {
        this.value = value;
    }

    @Override
    @JsonProperty(value="value")
    @JsonValue
    public String value() {
        return this.value;
    }

    public final ImmutableJsonValueCreator withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableJsonValueCreator(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonValueCreator && this.equalTo(0, (ImmutableJsonValueCreator)another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonValueCreator another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonValueCreator").omitNullValues().add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJsonValueCreator fromJson(String jsonValue) {
        Builder builder = ImmutableJsonValueCreator.builder();
        builder.value(jsonValue);
        return builder.build();
    }

    public static ImmutableJsonValueCreator copyOf(JsonValueCreator instance) {
        if (instance instanceof ImmutableJsonValueCreator) {
            return (ImmutableJsonValueCreator)instance;
        }
        return ImmutableJsonValueCreator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @CheckReturnValue
    @Generated(from="JsonValueCreator.Constructor", generator="Immutables")
    @Immutable
    public static final class Constructor
    implements JsonValueCreator.Constructor {
        private final boolean value;

        private Constructor(boolean value) {
            this.value = value;
        }

        @Override
        @JsonProperty(value="value")
        @JsonValue
        public boolean value() {
            return this.value;
        }

        public final Constructor withValue(boolean value) {
            if (this.value == value) {
                return this;
            }
            return new Constructor(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Constructor && this.equalTo(0, (Constructor)another);
        }

        private boolean equalTo(int synthetic, Constructor another) {
            return this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Booleans.hashCode((boolean)this.value);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Constructor").omitNullValues().add("value", this.value).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Constructor fromJson(boolean jsonValue) {
            Constructor instance = Constructor.of(jsonValue);
            return instance;
        }

        public static Constructor of(boolean value) {
            return new Constructor(value);
        }

        public static Constructor copyOf(JsonValueCreator.Constructor instance) {
            if (instance instanceof Constructor) {
                return (Constructor)instance;
            }
            return Constructor.of(instance.value());
        }
    }

    @CheckReturnValue
    @Generated(from="JsonValueCreator.Singleton", generator="Immutables")
    @Immutable
    public static final class Singleton
    implements JsonValueCreator.Singleton {
        private final double value;
        private static final Singleton INSTANCE = Singleton.validate(new Singleton());

        private Singleton() {
            this.value = JsonValueCreator.Singleton.super.value();
        }

        private Singleton(double value) {
            this.value = value;
        }

        @Override
        @JsonProperty(value="value")
        @JsonValue
        public double value() {
            return this.value;
        }

        public final Singleton withValue(double value) {
            if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(value)) {
                return this;
            }
            return Singleton.validate(new Singleton(value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Singleton && this.equalTo(0, (Singleton)another);
        }

        private boolean equalTo(int synthetic, Singleton another) {
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Doubles.hashCode((double)this.value);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Singleton").omitNullValues().add("value", this.value).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Singleton fromJson(double jsonValue) {
            Singleton instance = Singleton.of();
            instance = instance.withValue(jsonValue);
            return instance;
        }

        public static Singleton of() {
            return INSTANCE;
        }

        private static Singleton validate(Singleton instance) {
            return instance;
        }
    }

    @Generated(from="JsonValueCreator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonValueCreator instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJsonValueCreator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonValueCreator(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build JsonValueCreator, some of required attributes are not set " + attributes;
        }
    }
}

