/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.JacksonMappedWithNoAnnotations;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JacksonMappedWithNoAnnotations", generator="Immutables")
@Immutable
public final class ImmutableJacksonMappedWithNoAnnotations
implements JacksonMappedWithNoAnnotations {
    private final String someString;

    private ImmutableJacksonMappedWithNoAnnotations(String someString) {
        this.someString = someString;
    }

    @Override
    @JsonProperty(value="someString")
    public String getSomeString() {
        return this.someString;
    }

    public final ImmutableJacksonMappedWithNoAnnotations withSomeString(String value) {
        String newValue = Objects.requireNonNull(value, "someString");
        if (this.someString.equals(newValue)) {
            return this;
        }
        return new ImmutableJacksonMappedWithNoAnnotations(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJacksonMappedWithNoAnnotations && this.equalTo(0, (ImmutableJacksonMappedWithNoAnnotations)another);
    }

    private boolean equalTo(int synthetic, ImmutableJacksonMappedWithNoAnnotations another) {
        return this.someString.equals(another.someString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.someString.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JacksonMappedWithNoAnnotations").omitNullValues().add("someString", (Object)this.someString).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJacksonMappedWithNoAnnotations fromJson(Json json) {
        Builder builder = ImmutableJacksonMappedWithNoAnnotations.builder();
        if (json.someString != null) {
            builder.someString(json.someString);
        }
        return builder.build();
    }

    public static ImmutableJacksonMappedWithNoAnnotations copyOf(JacksonMappedWithNoAnnotations instance) {
        if (instance instanceof ImmutableJacksonMappedWithNoAnnotations) {
            return (ImmutableJacksonMappedWithNoAnnotations)instance;
        }
        return ImmutableJacksonMappedWithNoAnnotations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JacksonMappedWithNoAnnotations", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOME_STRING = 1L;
        private long initBits = 1L;
        @Nullable
        private String someString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JacksonMappedWithNoAnnotations instance) {
            Objects.requireNonNull(instance, "instance");
            this.someString(instance.getSomeString());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder someString(String someString) {
            this.someString = Objects.requireNonNull(someString, "someString");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJacksonMappedWithNoAnnotations build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJacksonMappedWithNoAnnotations(this.someString);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("someString");
            }
            return "Cannot build JacksonMappedWithNoAnnotations, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JacksonMappedWithNoAnnotations", generator="Immutables")
    static final class Json
    implements JacksonMappedWithNoAnnotations {
        @Nullable
        String someString;

        Json() {
        }

        @JsonProperty(value="someString")
        public void setSomeString(String someString) {
            this.someString = someString;
        }

        @Override
        public String getSomeString() {
            throw new UnsupportedOperationException();
        }
    }
}

