/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.AdditionalJacksonAnnotation;
import org.immutables.fixture.jackson.JacksonMappedWithExtraAnnotation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JacksonMappedWithExtraAnnotation", generator="Immutables")
@Immutable
public final class ImmutableJacksonMappedWithExtraAnnotation
implements JacksonMappedWithExtraAnnotation {
    private final Long someLong;

    private ImmutableJacksonMappedWithExtraAnnotation(Long someLong) {
        this.someLong = someLong;
    }

    @Override
    @AdditionalJacksonAnnotation(value="some_long")
    @JsonProperty(value="some_long_string")
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getSomeLong() {
        return this.someLong;
    }

    public final ImmutableJacksonMappedWithExtraAnnotation withSomeLong(Long value) {
        Long newValue = Objects.requireNonNull(value, "someLong");
        if (this.someLong.equals(newValue)) {
            return this;
        }
        return new ImmutableJacksonMappedWithExtraAnnotation(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJacksonMappedWithExtraAnnotation && this.equalTo(0, (ImmutableJacksonMappedWithExtraAnnotation)another);
    }

    private boolean equalTo(int synthetic, ImmutableJacksonMappedWithExtraAnnotation another) {
        return this.someLong.equals(another.someLong);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.someLong.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JacksonMappedWithExtraAnnotation").omitNullValues().add("someLong", (Object)this.someLong).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJacksonMappedWithExtraAnnotation fromJson(Json json) {
        Builder builder = ImmutableJacksonMappedWithExtraAnnotation.builder();
        if (json.someLong != null) {
            builder.someLong(json.someLong);
        }
        return builder.build();
    }

    public static ImmutableJacksonMappedWithExtraAnnotation copyOf(JacksonMappedWithExtraAnnotation instance) {
        if (instance instanceof ImmutableJacksonMappedWithExtraAnnotation) {
            return (ImmutableJacksonMappedWithExtraAnnotation)instance;
        }
        return ImmutableJacksonMappedWithExtraAnnotation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JacksonMappedWithExtraAnnotation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOME_LONG = 1L;
        private long initBits = 1L;
        @Nullable
        private Long someLong;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JacksonMappedWithExtraAnnotation instance) {
            Objects.requireNonNull(instance, "instance");
            this.someLong(instance.getSomeLong());
            return this;
        }

        @JsonProperty(value="some_long_string")
        @JsonSerialize(using=ToStringSerializer.class)
        @CanIgnoreReturnValue
        public final Builder someLong(Long someLong) {
            this.someLong = Objects.requireNonNull(someLong, "someLong");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJacksonMappedWithExtraAnnotation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJacksonMappedWithExtraAnnotation(this.someLong);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("someLong");
            }
            return "Cannot build JacksonMappedWithExtraAnnotation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JacksonMappedWithExtraAnnotation", generator="Immutables")
    static final class Json
    implements JacksonMappedWithExtraAnnotation {
        @Nullable
        Long someLong;

        Json() {
        }

        @AdditionalJacksonAnnotation(value="some_long")
        @JsonProperty(value="some_long_string")
        @JsonSerialize(using=ToStringSerializer.class)
        public void setSomeLong(Long someLong) {
            this.someLong = someLong;
        }

        @Override
        public Long getSomeLong() {
            throw new UnsupportedOperationException();
        }
    }
}

