/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.RawType;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RawType", generator="Immutables")
@Immutable
public final class ImmutableRawType
implements RawType {
    private final Set set;
    private final Map map;

    private ImmutableRawType(Set set, Map map) {
        this.set = set;
        this.map = map;
    }

    @Override
    public Set set() {
        return this.set;
    }

    @Override
    public Map map() {
        return this.map;
    }

    public final ImmutableRawType withSet(Set value) {
        if (this.set == value) {
            return this;
        }
        Set newValue = Objects.requireNonNull(value, "set");
        return new ImmutableRawType(newValue, this.map);
    }

    public final ImmutableRawType withMap(Map value) {
        if (this.map == value) {
            return this;
        }
        Map newValue = Objects.requireNonNull(value, "map");
        return new ImmutableRawType(this.set, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRawType && this.equalTo(0, (ImmutableRawType)another);
    }

    private boolean equalTo(int synthetic, ImmutableRawType another) {
        return this.set.equals(another.set) && this.map.equals(another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.map.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RawType").omitNullValues().add("set", (Object)this.set).add("map", (Object)this.map).toString();
    }

    public static ImmutableRawType copyOf(RawType instance) {
        if (instance instanceof ImmutableRawType) {
            return (ImmutableRawType)instance;
        }
        return ImmutableRawType.builder().set(instance.set()).map(instance.map()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RawType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SET = 1L;
        private static final long INIT_BIT_MAP = 2L;
        private long initBits = 3L;
        @Nullable
        private Set set;
        @Nullable
        private Map map;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder set(Set set) {
            Builder.checkNotIsSet(this.setIsSet(), "set");
            this.set = Objects.requireNonNull(set, "set");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder map(Map map) {
            Builder.checkNotIsSet(this.mapIsSet(), "map");
            this.map = Objects.requireNonNull(map, "map");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRawType build() {
            this.checkRequiredAttributes();
            return new ImmutableRawType(this.set, this.map);
        }

        private boolean setIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean mapIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RawType is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.setIsSet()) {
                attributes.add("set");
            }
            if (!this.mapIsSet()) {
                attributes.add("map");
            }
            return "Cannot build RawType, some of required attributes are not set " + attributes;
        }
    }
}

