/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.encoding.defs;

import com.google.common.base.Preconditions;
import java.util.OptionalInt;

final class OptionalIntWithSentinel {
    private static final int SENTINEL_VALUE = 0;
    private int value;

    OptionalIntWithSentinel() {
    }

    public boolean equals(OptionalIntWithSentinel that) {
        return this.value == that.value;
    }

    public OptionalInt get() {
        if (this.value != 0) {
            return OptionalInt.of(this.value);
        }
        return OptionalInt.empty();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    static int initFrom(OptionalInt optional) {
        if (optional.isPresent()) {
            return OptionalIntWithSentinel.safeValue(optional.getAsInt());
        }
        return 0;
    }

    int withOptional(OptionalInt optional) {
        return OptionalIntWithSentinel.initFrom(optional);
    }

    int withInt(int intValue) {
        return OptionalIntWithSentinel.safeValue(intValue);
    }

    int withInteger(Integer integer) {
        return integer != null ? OptionalIntWithSentinel.safeValue(integer) : 0;
    }

    private static int safeValue(int intValue) {
        Preconditions.checkArgument((intValue != 0 ? 1 : 0) != 0, (Object)"Field value can't match the sentinel");
        return intValue;
    }

    static final class Builder {
        private int value = 0;

        Builder() {
        }

        int build() {
            return this.value;
        }

        void setFrom(OptionalInt optional) {
            if (optional.isPresent()) {
                this.setFromInt(optional.getAsInt());
            } else {
                this.value = 0;
            }
        }

        void setFromInteger(Integer value) {
            if (value != null) {
                this.setFromInt(value);
            } else {
                value = 0;
            }
        }

        void setFromInt(int value) {
            this.value = OptionalIntWithSentinel.safeValue(value);
        }
    }
}

