/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.annotation.HasDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HasDefault", generator="Immutables")
@Immutable
final class ImmutableHasDefault
implements HasDefault {
    private static final String DEFAULT_VALUE_OTHER_VALUE;
    private final int value;
    private final String otherValue;

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private ImmutableHasDefault(int value) {
        this.value = value;
        this.otherValue = DEFAULT_VALUE_OTHER_VALUE;
    }

    private ImmutableHasDefault(Builder builder) {
        this.value = builder.value;
        this.otherValue = builder.otherValue != null ? builder.otherValue : DEFAULT_VALUE_OTHER_VALUE;
    }

    private ImmutableHasDefault(int value, String otherValue) {
        this.value = value;
        this.otherValue = otherValue;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return HasDefault.class;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public String otherValue() {
        return this.otherValue;
    }

    public final ImmutableHasDefault withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableHasDefault(value, this.otherValue);
    }

    public final ImmutableHasDefault withOtherValue(String value) {
        String newValue = Objects.requireNonNull(value, "otherValue");
        if (this.otherValue.equals(newValue)) {
            return this;
        }
        return new ImmutableHasDefault(this.value, newValue);
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HasDefault && this.equalTo(0, (HasDefault)another);
    }

    private boolean equalTo(int synthetic, HasDefault another) {
        return this.value == another.value() && this.otherValue.equals(another.otherValue());
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "value".hashCode() ^ this.value;
        return h += 127 * "otherValue".hashCode() ^ this.otherValue.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"@HasDefault").omitNullValues().add("value", this.value).add("otherValue", (Object)this.otherValue).toString();
    }

    public static ImmutableHasDefault of(int value) {
        return new ImmutableHasDefault(value);
    }

    public static ImmutableHasDefault copyOf(HasDefault instance) {
        if (instance instanceof ImmutableHasDefault) {
            return (ImmutableHasDefault)instance;
        }
        return ImmutableHasDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        try {
            DEFAULT_VALUE_OTHER_VALUE = (String)ImmutableHasDefault.cast(HasDefault.class.getDeclaredMethod("otherValue", new Class[0]).getDefaultValue());
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Generated(from="HasDefault", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;
        @Nullable
        private String otherValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HasDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.otherValue(instance.otherValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder otherValue(String otherValue) {
            this.otherValue = Objects.requireNonNull(otherValue, "otherValue");
            return this;
        }

        public ImmutableHasDefault build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHasDefault(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build HasDefault, some of required attributes are not set " + attributes;
        }
    }
}

