/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.annotation.FallbackNullable;
import org.immutables.fixture.annotation.Nil;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FallbackNullable", generator="Immutables")
@Immutable
public final class ImmutableFallbackNullable
implements FallbackNullable {
    @Nil
    private final String jdkOptional;
    @Nil
    private final String nullable;

    private ImmutableFallbackNullable(@Nil String jdkOptional, @Nil String nullable) {
        this.jdkOptional = jdkOptional;
        this.nullable = nullable;
    }

    @Override
    public Optional<String> jdkOptional() {
        return Optional.ofNullable(this.jdkOptional);
    }

    @Override
    @Nil
    public String nullable() {
        return this.nullable;
    }

    public final ImmutableFallbackNullable withJdkOptional(@Nil String value) {
        String newValue = value;
        if (Objects.equals(this.jdkOptional, newValue)) {
            return this;
        }
        return new ImmutableFallbackNullable(newValue, this.nullable);
    }

    public final ImmutableFallbackNullable withJdkOptional(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.jdkOptional, value)) {
            return this;
        }
        return new ImmutableFallbackNullable(value, this.nullable);
    }

    public final ImmutableFallbackNullable withNullable(@Nil String value) {
        if (Objects.equals(this.nullable, value)) {
            return this;
        }
        return new ImmutableFallbackNullable(this.jdkOptional, value);
    }

    public boolean equals(@Nil Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFallbackNullable && this.equalTo(0, (ImmutableFallbackNullable)another);
    }

    private boolean equalTo(int synthetic, ImmutableFallbackNullable another) {
        return Objects.equals(this.jdkOptional, another.jdkOptional) && Objects.equals(this.nullable, another.nullable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.jdkOptional);
        h += (h << 5) + Objects.hashCode(this.nullable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FallbackNullable").omitNullValues().add("jdkOptional", (Object)this.jdkOptional).add("nullable", (Object)this.nullable).toString();
    }

    public static ImmutableFallbackNullable copyOf(FallbackNullable instance) {
        if (instance instanceof ImmutableFallbackNullable) {
            return (ImmutableFallbackNullable)instance;
        }
        return ImmutableFallbackNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FallbackNullable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nil
        private String jdkOptional;
        @Nil
        private String nullable;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FallbackNullable instance) {
            String nullableValue;
            Objects.requireNonNull(instance, "instance");
            Optional<String> jdkOptionalOptional = instance.jdkOptional();
            if (jdkOptionalOptional.isPresent()) {
                this.jdkOptional(jdkOptionalOptional);
            }
            if ((nullableValue = instance.nullable()) != null) {
                this.nullable(nullableValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jdkOptional(@Nil String jdkOptional) {
            this.jdkOptional = jdkOptional;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jdkOptional(Optional<String> jdkOptional) {
            this.jdkOptional = jdkOptional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullable(@Nil String nullable) {
            this.nullable = nullable;
            return this;
        }

        public ImmutableFallbackNullable build() {
            return new ImmutableFallbackNullable(this.jdkOptional, this.nullable);
        }
    }
}

