/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.atlassian.fugue.Option;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.fixture.SillyStructureWithId;
import org.immutables.fixture.SillyTuplie;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SillyStructureWithId", generator="Repositories")
@ThreadSafe
public class SillyStructureWithIdRepository
extends Repositories.Repository<SillyStructureWithId> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillyStructureWithId";
    private final Serialization serialization = new Serialization(this.codecRegistry(), this.fieldNamingStrategy());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public SillyStructureWithIdRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, SillyStructureWithId.class);
    }

    public FluentFuture<Integer> insert(SillyStructureWithId document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillyStructureWithId> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder findById(String id) {
        return this.find(this.criteria().id(id));
    }

    public FluentFuture<Integer> upsert(SillyStructureWithId document) {
        Criteria byId = this.criteria().id(document.id());
        return super.doUpsert((Constraints.ConstraintHost)byId.constraint, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    @Beta
    Bson toBson(Criteria criteria) {
        return Support.convertToBson((Constraints.ConstraintHost)criteria.constraint);
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    private static class Serialization {
        final Encoder<Integer> opt3Encoder;
        final Encoder<Integer> opt5Encoder;
        final Encoder<SillySubstructure> subs6Encoder;
        final Encoder<SillySubstructure> nest7Encoder;
        final Encoder<SillyTuplie> tup3Encoder;
        final CodecRegistry registry;
        final String idName;
        final String attr1Name;
        final String flag2Name;
        final String opt3Name;
        final String opt5Name;
        final String very4Name;
        final String wet5Name;
        final String subs6Name;
        final String nest7Name;
        final String tup3Name;
        final String int9Name;

        Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
            this.registry = registry;
            this.opt3Encoder = this.registry.get(Integer.class);
            this.opt5Encoder = this.registry.get(Integer.class);
            this.subs6Encoder = this.registry.get(SillySubstructure.class);
            this.nest7Encoder = this.registry.get(SillySubstructure.class);
            this.tup3Encoder = this.registry.get(SillyTuplie.class);
            this.idName = "_id";
            this.attr1Name = Serialization.translateName(fieldNamingStrategy, "attr1");
            this.flag2Name = Serialization.translateName(fieldNamingStrategy, "flag2");
            this.opt3Name = Serialization.translateName(fieldNamingStrategy, "opt3");
            this.opt5Name = Serialization.translateName(fieldNamingStrategy, "opt5");
            this.very4Name = Serialization.translateName(fieldNamingStrategy, "very4");
            this.wet5Name = Serialization.translateName(fieldNamingStrategy, "wet5");
            this.subs6Name = Serialization.translateName(fieldNamingStrategy, "subs6");
            this.nest7Name = Serialization.translateName(fieldNamingStrategy, "nest7");
            this.tup3Name = Serialization.translateName(fieldNamingStrategy, "tup3");
            this.int9Name = Serialization.translateName(fieldNamingStrategy, "int9");
        }

        private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
            try {
                return fieldNamingStrategy.translateName((Member)SillyStructureWithIdNamingFields.class.getField(fieldName));
            }
            catch (NoSuchFieldException noSuchField) {
                throw new AssertionError((Object)noSuchField);
            }
        }

        @Generated(from="SillyStructureWithId", generator="Repositories")
        static final class SillyStructureWithIdNamingFields {
            public String id;
            public String attr1;
            public boolean flag2;
            public Optional<Integer> opt3;
            public Option<Integer> opt5;
            public long very4;
            public double wet5;
            public List<SillySubstructure> subs6;
            public SillySubstructure nest7;
            public Optional<SillyTuplie> tup3;
            public int int9;

            SillyStructureWithIdNamingFields() {
            }
        }
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria id(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, false, Support.writable((Object)value)));
        }

        public Criteria idNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, true, Support.writable((Object)value)));
        }

        public Criteria idIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, wrappedValues));
        }

        public Criteria idIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, values));
        }

        public Criteria idNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, wrappedValues));
        }

        public Criteria idNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, values));
        }

        public Criteria idStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria idMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, pattern));
        }

        public Criteria idNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, true, pattern));
        }

        public Criteria idGreaterThan(String lower) {
            return this.idIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria idLessThan(String upper) {
            return this.idIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria idAtMost(String upperInclusive) {
            return this.idIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria idAtLeast(String lowerInclusive) {
            return this.idIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria idIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, false, Support.writable(range)));
        }

        public Criteria idNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, true, Support.writable(range)));
        }

        public Criteria attr1(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.attr1Name, false, Support.writable((Object)value)));
        }

        public Criteria attr1Not(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.attr1Name, true, Support.writable((Object)value)));
        }

        public Criteria attr1In(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, false, wrappedValues));
        }

        public Criteria attr1In(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, false, values));
        }

        public Criteria attr1NotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, true, wrappedValues));
        }

        public Criteria attr1NotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.attr1Name, true, values));
        }

        public Criteria attr1StartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.attr1Name, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria attr1Matches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.attr1Name, false, pattern));
        }

        public Criteria attr1NotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.attr1Name, true, pattern));
        }

        public Criteria attr1GreaterThan(String lower) {
            return this.attr1In((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria attr1LessThan(String upper) {
            return this.attr1In((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria attr1AtMost(String upperInclusive) {
            return this.attr1In((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria attr1AtLeast(String lowerInclusive) {
            return this.attr1In((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria attr1In(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.attr1Name, false, Support.writable(range)));
        }

        public Criteria attr1NotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.attr1Name, true, Support.writable(range)));
        }

        public Criteria flag2(boolean value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.flag2Name, false, Support.writable((Object)value)));
        }

        public Criteria opt3(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt3Name, false, Support.writable(this.serialization.opt3Encoder, (Object)value)));
        }

        public Criteria opt3Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt3Name, true, Support.writable(this.serialization.opt3Encoder, (Object)value)));
        }

        public Criteria opt3In(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.opt3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, false, wrappedValues));
        }

        public Criteria opt3In(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.opt3Encoder, (Object)first));
            values.add(Support.writable(this.serialization.opt3Encoder, (Object)second));
            for (int value : rest) {
                values.add(Support.writable(this.serialization.opt3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, false, values));
        }

        public Criteria opt3NotIn(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.opt3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, true, wrappedValues));
        }

        public Criteria opt3NotIn(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.opt3Encoder, (Object)first));
            values.add(Support.writable(this.serialization.opt3Encoder, (Object)second));
            for (int value : rest) {
                values.add(Support.writable(this.serialization.opt3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt3Name, true, values));
        }

        public Criteria opt3Present() {
            return new Criteria(this.serialization, this.constraint.present(this.serialization.opt3Name, false));
        }

        public Criteria opt3Absent() {
            return new Criteria(this.serialization, this.constraint.present(this.serialization.opt3Name, true));
        }

        public Criteria opt3GreaterThan(int lower) {
            return this.opt3In((Range<Integer>)Range.greaterThan((Comparable)Integer.valueOf(lower)));
        }

        public Criteria opt3LessThan(int upper) {
            return this.opt3In((Range<Integer>)Range.lessThan((Comparable)Integer.valueOf(upper)));
        }

        public Criteria opt3AtMost(int upperInclusive) {
            return this.opt3In((Range<Integer>)Range.atMost((Comparable)Integer.valueOf(upperInclusive)));
        }

        public Criteria opt3AtLeast(int lowerInclusive) {
            return this.opt3In((Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(lowerInclusive)));
        }

        public Criteria opt3In(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.opt3Name, false, Support.writable(this.serialization.opt3Encoder, range)));
        }

        public Criteria opt3NotIn(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.opt3Name, true, Support.writable(this.serialization.opt3Encoder, range)));
        }

        public Criteria opt5(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt5Name, false, Support.writable(this.serialization.opt5Encoder, (Object)value)));
        }

        public Criteria opt5Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.opt5Name, true, Support.writable(this.serialization.opt5Encoder, (Object)value)));
        }

        public Criteria opt5In(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.opt5Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, false, wrappedValues));
        }

        public Criteria opt5In(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.opt5Encoder, (Object)first));
            values.add(Support.writable(this.serialization.opt5Encoder, (Object)second));
            for (int value : rest) {
                values.add(Support.writable(this.serialization.opt5Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, false, values));
        }

        public Criteria opt5NotIn(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.opt5Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, true, wrappedValues));
        }

        public Criteria opt5NotIn(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.opt5Encoder, (Object)first));
            values.add(Support.writable(this.serialization.opt5Encoder, (Object)second));
            for (int value : rest) {
                values.add(Support.writable(this.serialization.opt5Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.opt5Name, true, values));
        }

        public Criteria opt5Present() {
            return new Criteria(this.serialization, this.constraint.present(this.serialization.opt5Name, false));
        }

        public Criteria opt5Absent() {
            return new Criteria(this.serialization, this.constraint.present(this.serialization.opt5Name, true));
        }

        public Criteria opt5GreaterThan(int lower) {
            return this.opt5In((Range<Integer>)Range.greaterThan((Comparable)Integer.valueOf(lower)));
        }

        public Criteria opt5LessThan(int upper) {
            return this.opt5In((Range<Integer>)Range.lessThan((Comparable)Integer.valueOf(upper)));
        }

        public Criteria opt5AtMost(int upperInclusive) {
            return this.opt5In((Range<Integer>)Range.atMost((Comparable)Integer.valueOf(upperInclusive)));
        }

        public Criteria opt5AtLeast(int lowerInclusive) {
            return this.opt5In((Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(lowerInclusive)));
        }

        public Criteria opt5In(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.opt5Name, false, Support.writable(this.serialization.opt5Encoder, range)));
        }

        public Criteria opt5NotIn(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.opt5Name, true, Support.writable(this.serialization.opt5Encoder, range)));
        }

        public Criteria very4(long value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.very4Name, false, Support.writable((Object)value)));
        }

        public Criteria very4Not(long value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.very4Name, true, Support.writable((Object)value)));
        }

        public Criteria very4In(Iterable<Long> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Long value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, false, wrappedValues));
        }

        public Criteria very4In(long first, long second, long ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (long value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, false, values));
        }

        public Criteria very4NotIn(Iterable<Long> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Long value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, true, wrappedValues));
        }

        public Criteria very4NotIn(long first, long second, long ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (long value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.very4Name, true, values));
        }

        public Criteria very4GreaterThan(long lower) {
            return this.very4In((Range<Long>)Range.greaterThan((Comparable)Long.valueOf(lower)));
        }

        public Criteria very4LessThan(long upper) {
            return this.very4In((Range<Long>)Range.lessThan((Comparable)Long.valueOf(upper)));
        }

        public Criteria very4AtMost(long upperInclusive) {
            return this.very4In((Range<Long>)Range.atMost((Comparable)Long.valueOf(upperInclusive)));
        }

        public Criteria very4AtLeast(long lowerInclusive) {
            return this.very4In((Range<Long>)Range.atLeast((Comparable)Long.valueOf(lowerInclusive)));
        }

        public Criteria very4In(Range<Long> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.very4Name, false, Support.writable(range)));
        }

        public Criteria very4NotIn(Range<Long> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.very4Name, true, Support.writable(range)));
        }

        public Criteria wet5(double value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.wet5Name, false, Support.writable((Object)value)));
        }

        public Criteria wet5Not(double value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.wet5Name, true, Support.writable((Object)value)));
        }

        public Criteria wet5In(Iterable<Double> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Double value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, false, wrappedValues));
        }

        public Criteria wet5In(double first, double second, double ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (double value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, false, values));
        }

        public Criteria wet5NotIn(Iterable<Double> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Double value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, true, wrappedValues));
        }

        public Criteria wet5NotIn(double first, double second, double ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (double value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.wet5Name, true, values));
        }

        public Criteria wet5GreaterThan(double lower) {
            return this.wet5In((Range<Double>)Range.greaterThan((Comparable)Double.valueOf(lower)));
        }

        public Criteria wet5LessThan(double upper) {
            return this.wet5In((Range<Double>)Range.lessThan((Comparable)Double.valueOf(upper)));
        }

        public Criteria wet5AtMost(double upperInclusive) {
            return this.wet5In((Range<Double>)Range.atMost((Comparable)Double.valueOf(upperInclusive)));
        }

        public Criteria wet5AtLeast(double lowerInclusive) {
            return this.wet5In((Range<Double>)Range.atLeast((Comparable)Double.valueOf(lowerInclusive)));
        }

        public Criteria wet5In(Range<Double> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.wet5Name, false, Support.writable(range)));
        }

        public Criteria wet5NotIn(Range<Double> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.wet5Name, true, Support.writable(range)));
        }

        public Criteria subs6Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.subs6Name, false, 0));
        }

        public Criteria subs6NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.subs6Name, true, 0));
        }

        public Criteria subs6Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.subs6Name, false, size));
        }

        public Criteria subs6Contains(SillySubstructure value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6Encoder, (Object)value)));
        }

        public Criteria subs6ContainsAll(Iterable<SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.subs6Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria nest7(SillySubstructure value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7Encoder, (Object)value)));
        }

        public Criteria nest7Not(SillySubstructure value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.nest7Name, true, Support.writable(this.serialization.nest7Encoder, (Object)value)));
        }

        public Criteria nest7In(Iterable<SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.nest7Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, false, wrappedValues));
        }

        public Criteria nest7In(SillySubstructure first, SillySubstructure second, SillySubstructure ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.nest7Encoder, (Object)first));
            values.add(Support.writable(this.serialization.nest7Encoder, (Object)second));
            for (SillySubstructure value : rest) {
                values.add(Support.writable(this.serialization.nest7Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, false, values));
        }

        public Criteria nest7NotIn(Iterable<SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure value : values) {
                wrappedValues.add(Support.writable(this.serialization.nest7Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, true, wrappedValues));
        }

        public Criteria nest7NotIn(SillySubstructure first, SillySubstructure second, SillySubstructure ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.nest7Encoder, (Object)first));
            values.add(Support.writable(this.serialization.nest7Encoder, (Object)second));
            for (SillySubstructure value : rest) {
                values.add(Support.writable(this.serialization.nest7Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nest7Name, true, values));
        }

        public Criteria tup3(SillyTuplie value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3Encoder, (Object)value)));
        }

        public Criteria tup3Not(SillyTuplie value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.tup3Name, true, Support.writable(this.serialization.tup3Encoder, (Object)value)));
        }

        public Criteria tup3In(Iterable<SillyTuplie> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillyTuplie value : values) {
                wrappedValues.add(Support.writable(this.serialization.tup3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, false, wrappedValues));
        }

        public Criteria tup3In(SillyTuplie first, SillyTuplie second, SillyTuplie ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.tup3Encoder, (Object)first));
            values.add(Support.writable(this.serialization.tup3Encoder, (Object)second));
            for (SillyTuplie value : rest) {
                values.add(Support.writable(this.serialization.tup3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, false, values));
        }

        public Criteria tup3NotIn(Iterable<SillyTuplie> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillyTuplie value : values) {
                wrappedValues.add(Support.writable(this.serialization.tup3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, true, wrappedValues));
        }

        public Criteria tup3NotIn(SillyTuplie first, SillyTuplie second, SillyTuplie ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.tup3Encoder, (Object)first));
            values.add(Support.writable(this.serialization.tup3Encoder, (Object)second));
            for (SillyTuplie value : rest) {
                values.add(Support.writable(this.serialization.tup3Encoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.tup3Name, true, values));
        }

        public Criteria tup3Present() {
            return new Criteria(this.serialization, this.constraint.present(this.serialization.tup3Name, false));
        }

        public Criteria tup3Absent() {
            return new Criteria(this.serialization, this.constraint.present(this.serialization.tup3Name, true));
        }

        public Criteria int9(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.int9Name, false, Support.writable((Object)value)));
        }

        public Criteria int9Not(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.int9Name, true, Support.writable((Object)value)));
        }

        public Criteria int9In(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, false, wrappedValues));
        }

        public Criteria int9In(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, false, values));
        }

        public Criteria int9NotIn(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, true, wrappedValues));
        }

        public Criteria int9NotIn(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.int9Name, true, values));
        }

        public Criteria int9GreaterThan(int lower) {
            return this.int9In((Range<Integer>)Range.greaterThan((Comparable)Integer.valueOf(lower)));
        }

        public Criteria int9LessThan(int upper) {
            return this.int9In((Range<Integer>)Range.lessThan((Comparable)Integer.valueOf(upper)));
        }

        public Criteria int9AtMost(int upperInclusive) {
            return this.int9In((Range<Integer>)Range.atMost((Comparable)Integer.valueOf(upperInclusive)));
        }

        public Criteria int9AtLeast(int lowerInclusive) {
            return this.int9In((Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(lowerInclusive)));
        }

        public Criteria int9In(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.int9Name, false, Support.writable(range)));
        }

        public Criteria int9NotIn(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.int9Name, true, Support.writable(range)));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public Criteria with(Criteria criteria) {
            return new Criteria(this.serialization, (Constraints.Constraint)criteria.constraint.accept((Constraints.ConstraintVisitor)this.constraint));
        }

        public String toString() {
            return "SillyStructureWithIdRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillyStructureWithId, Indexer> {
        private final Serialization serialization;

        private Indexer(SillyStructureWithIdRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withId() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Indexer withAttr1() {
            this.fields = this.fields.equal(this.serialization.attr1Name, false, (Object)1);
            return this;
        }

        public Indexer withAttr1Desceding() {
            this.fields = this.fields.equal(this.serialization.attr1Name, false, (Object)-1);
            return this;
        }

        public Indexer withFlag2() {
            this.fields = this.fields.equal(this.serialization.flag2Name, false, (Object)1);
            return this;
        }

        public Indexer withFlag2Desceding() {
            this.fields = this.fields.equal(this.serialization.flag2Name, false, (Object)-1);
            return this;
        }

        public Indexer withOpt3() {
            this.fields = this.fields.equal(this.serialization.opt3Name, false, (Object)1);
            return this;
        }

        public Indexer withOpt3Desceding() {
            this.fields = this.fields.equal(this.serialization.opt3Name, false, (Object)-1);
            return this;
        }

        public Indexer withOpt5() {
            this.fields = this.fields.equal(this.serialization.opt5Name, false, (Object)1);
            return this;
        }

        public Indexer withOpt5Desceding() {
            this.fields = this.fields.equal(this.serialization.opt5Name, false, (Object)-1);
            return this;
        }

        public Indexer withVery4() {
            this.fields = this.fields.equal(this.serialization.very4Name, false, (Object)1);
            return this;
        }

        public Indexer withVery4Desceding() {
            this.fields = this.fields.equal(this.serialization.very4Name, false, (Object)-1);
            return this;
        }

        public Indexer withWet5() {
            this.fields = this.fields.equal(this.serialization.wet5Name, false, (Object)1);
            return this;
        }

        public Indexer withWet5Desceding() {
            this.fields = this.fields.equal(this.serialization.wet5Name, false, (Object)-1);
            return this;
        }

        public Indexer withSubs6() {
            this.fields = this.fields.equal(this.serialization.subs6Name, false, (Object)1);
            return this;
        }

        public Indexer withSubs6Desceding() {
            this.fields = this.fields.equal(this.serialization.subs6Name, false, (Object)-1);
            return this;
        }

        public Indexer withNest7() {
            this.fields = this.fields.equal(this.serialization.nest7Name, false, (Object)1);
            return this;
        }

        public Indexer withNest7Desceding() {
            this.fields = this.fields.equal(this.serialization.nest7Name, false, (Object)-1);
            return this;
        }

        public Indexer withTup3() {
            this.fields = this.fields.equal(this.serialization.tup3Name, false, (Object)1);
            return this;
        }

        public Indexer withTup3Desceding() {
            this.fields = this.fields.equal(this.serialization.tup3Name, false, (Object)-1);
            return this;
        }

        public Indexer withInt9() {
            this.fields = this.fields.equal(this.serialization.int9Name, false, (Object)1);
            return this;
        }

        public Indexer withInt9Desceding() {
            this.fields = this.fields.equal(this.serialization.int9Name, false, (Object)-1);
            return this;
        }
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    @NotThreadSafe
    public static final class Replacer
    extends Repositories.Replacer<SillyStructureWithId, Replacer> {
        protected Replacer(SillyStructureWithIdRepository repository, SillyStructureWithId document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super((Repositories.Repository)repository, (Object)document, criteria, ordering);
        }
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillyStructureWithId, Modifier> {
        private final Serialization serialization;

        private Modifier(SillyStructureWithIdRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setId(String value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initId(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setAttr1(String value) {
            this.setFields = this.setFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initAttr1(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setFlag2(boolean value) {
            this.setFields = this.setFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initFlag2(boolean value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier emptyOpt3() {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, null);
            return this;
        }

        public Modifier setOpt3(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, Support.writable(this.serialization.opt3Encoder, (Object)value));
            return this;
        }

        public Modifier initOpt3(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt3Name, false, Support.writable(this.serialization.opt3Encoder, (Object)value));
            return this;
        }

        public Modifier emptyOpt5() {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, null);
            return this;
        }

        public Modifier setOpt5(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, Support.writable(this.serialization.opt5Encoder, (Object)value));
            return this;
        }

        public Modifier initOpt5(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt5Name, false, Support.writable(this.serialization.opt5Encoder, (Object)value));
            return this;
        }

        public Modifier setVery4(long value) {
            this.setFields = this.setFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initVery4(long value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementVery4(long increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.very4Name, false, (Object)increment);
            return this;
        }

        public Modifier setWet5(double value) {
            this.setFields = this.setFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initWet5(double value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementWet5(double increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.wet5Name, false, (Object)increment);
            return this;
        }

        public Modifier clearSubs6() {
            this.setFields = this.setFields.equal(this.serialization.subs6Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeSubs6(SillySubstructure value) {
            this.pullFields = this.pullFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6Encoder, (Object)value));
            return this;
        }

        public Modifier addSubs6(SillySubstructure value) {
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6Encoder, (Object)value));
            return this;
        }

        public Modifier setSubs6(Iterable<? extends SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure sillySubstructure : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6Encoder, (Object)sillySubstructure));
            }
            this.setFields = this.setFields.equal(this.serialization.subs6Name, false, wrappedValues);
            return this;
        }

        public Modifier addAllSubs6(Iterable<? extends SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure sillySubstructure : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6Encoder, (Object)sillySubstructure));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, v);
            return this;
        }

        public Modifier setNest7(SillySubstructure value) {
            this.setFields = this.setFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7Encoder, (Object)value));
            return this;
        }

        public Modifier initNest7(SillySubstructure value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7Encoder, (Object)value));
            return this;
        }

        public Modifier emptyTup3() {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, null);
            return this;
        }

        public Modifier setTup3(SillyTuplie value) {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3Encoder, (Object)value));
            return this;
        }

        public Modifier initTup3(SillyTuplie value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3Encoder, (Object)value));
            return this;
        }

        public Modifier setInt9(int value) {
            this.setFields = this.setFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initInt9(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementInt9(int increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.int9Name, false, (Object)increment);
            return this;
        }
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillyStructureWithId> {
        private final Serialization serialization;

        private Updater(SillyStructureWithIdRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setId(String value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initId(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater setAttr1(String value) {
            this.setFields = this.setFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initAttr1(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.attr1Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater setFlag2(boolean value) {
            this.setFields = this.setFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initFlag2(boolean value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.flag2Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater emptyOpt3() {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, null);
            return this;
        }

        public Updater setOpt3(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt3Name, false, Support.writable(this.serialization.opt3Encoder, (Object)value));
            return this;
        }

        public Updater initOpt3(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt3Name, false, Support.writable(this.serialization.opt3Encoder, (Object)value));
            return this;
        }

        public Updater emptyOpt5() {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, null);
            return this;
        }

        public Updater setOpt5(int value) {
            this.setFields = this.setFields.equal(this.serialization.opt5Name, false, Support.writable(this.serialization.opt5Encoder, (Object)value));
            return this;
        }

        public Updater initOpt5(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.opt5Name, false, Support.writable(this.serialization.opt5Encoder, (Object)value));
            return this;
        }

        public Updater setVery4(long value) {
            this.setFields = this.setFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initVery4(long value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.very4Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementVery4(long increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.very4Name, false, (Object)increment);
            return this;
        }

        public Updater setWet5(double value) {
            this.setFields = this.setFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initWet5(double value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.wet5Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementWet5(double increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.wet5Name, false, (Object)increment);
            return this;
        }

        public Updater clearSubs6() {
            this.setFields = this.setFields.equal(this.serialization.subs6Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeSubs6(SillySubstructure value) {
            this.pullFields = this.pullFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6Encoder, (Object)value));
            return this;
        }

        public Updater addSubs6(SillySubstructure value) {
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, Support.writable(this.serialization.subs6Encoder, (Object)value));
            return this;
        }

        public Updater setSubs6(Iterable<? extends SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure sillySubstructure : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6Encoder, (Object)sillySubstructure));
            }
            this.setFields = this.setFields.equal(this.serialization.subs6Name, false, wrappedValues);
            return this;
        }

        public Updater addAllSubs6(Iterable<? extends SillySubstructure> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (SillySubstructure sillySubstructure : values) {
                wrappedValues.add(Support.writable(this.serialization.subs6Encoder, (Object)sillySubstructure));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.subs6Name, false, v);
            return this;
        }

        public Updater setNest7(SillySubstructure value) {
            this.setFields = this.setFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7Encoder, (Object)value));
            return this;
        }

        public Updater initNest7(SillySubstructure value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.nest7Name, false, Support.writable(this.serialization.nest7Encoder, (Object)value));
            return this;
        }

        public Updater emptyTup3() {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, null);
            return this;
        }

        public Updater setTup3(SillyTuplie value) {
            this.setFields = this.setFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3Encoder, (Object)value));
            return this;
        }

        public Updater initTup3(SillyTuplie value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.tup3Name, false, Support.writable(this.serialization.tup3Encoder, (Object)value));
            return this;
        }

        public Updater setInt9(int value) {
            this.setFields = this.setFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater initInt9(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.int9Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementInt9(int increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.int9Name, false, (Object)increment);
            return this;
        }
    }

    @Generated(from="SillyStructureWithId", generator="Repositories")
    @NotThreadSafe
    public static final class Finder
    extends Repositories.FinderWithDelete<SillyStructureWithId, Finder> {
        private final Serialization serialization;

        private Finder(SillyStructureWithIdRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Finder orderByAttr1() {
            this.ordering = this.ordering.equal(this.serialization.attr1Name, false, (Object)1);
            return this;
        }

        public Finder orderByAttr1Desceding() {
            this.ordering = this.ordering.equal(this.serialization.attr1Name, false, (Object)-1);
            return this;
        }

        public Finder orderByFlag2() {
            this.ordering = this.ordering.equal(this.serialization.flag2Name, false, (Object)1);
            return this;
        }

        public Finder orderByFlag2Desceding() {
            this.ordering = this.ordering.equal(this.serialization.flag2Name, false, (Object)-1);
            return this;
        }

        public Finder orderByOpt3() {
            this.ordering = this.ordering.equal(this.serialization.opt3Name, false, (Object)1);
            return this;
        }

        public Finder orderByOpt3Desceding() {
            this.ordering = this.ordering.equal(this.serialization.opt3Name, false, (Object)-1);
            return this;
        }

        public Finder orderByOpt5() {
            this.ordering = this.ordering.equal(this.serialization.opt5Name, false, (Object)1);
            return this;
        }

        public Finder orderByOpt5Desceding() {
            this.ordering = this.ordering.equal(this.serialization.opt5Name, false, (Object)-1);
            return this;
        }

        public Finder orderByVery4() {
            this.ordering = this.ordering.equal(this.serialization.very4Name, false, (Object)1);
            return this;
        }

        public Finder orderByVery4Desceding() {
            this.ordering = this.ordering.equal(this.serialization.very4Name, false, (Object)-1);
            return this;
        }

        public Finder orderByWet5() {
            this.ordering = this.ordering.equal(this.serialization.wet5Name, false, (Object)1);
            return this;
        }

        public Finder orderByWet5Desceding() {
            this.ordering = this.ordering.equal(this.serialization.wet5Name, false, (Object)-1);
            return this;
        }

        public Finder orderBySubs6() {
            this.ordering = this.ordering.equal(this.serialization.subs6Name, false, (Object)1);
            return this;
        }

        public Finder orderBySubs6Desceding() {
            this.ordering = this.ordering.equal(this.serialization.subs6Name, false, (Object)-1);
            return this;
        }

        public Finder orderByNest7() {
            this.ordering = this.ordering.equal(this.serialization.nest7Name, false, (Object)1);
            return this;
        }

        public Finder orderByNest7Desceding() {
            this.ordering = this.ordering.equal(this.serialization.nest7Name, false, (Object)-1);
            return this;
        }

        public Finder orderByTup3() {
            this.ordering = this.ordering.equal(this.serialization.tup3Name, false, (Object)1);
            return this;
        }

        public Finder orderByTup3Desceding() {
            this.ordering = this.ordering.equal(this.serialization.tup3Name, false, (Object)-1);
            return this;
        }

        public Finder orderByInt9() {
            this.ordering = this.ordering.equal(this.serialization.int9Name, false, (Object)1);
            return this;
        }

        public Finder orderByInt9Desceding() {
            this.ordering = this.ordering.equal(this.serialization.int9Name, false, (Object)-1);
            return this;
        }

        public Finder excludeOpt3() {
            this.exclusion = this.exclusion.equal(this.serialization.opt3Name, false, (Object)-1);
            return this;
        }

        public Finder excludeOpt5() {
            this.exclusion = this.exclusion.equal(this.serialization.opt5Name, false, (Object)-1);
            return this;
        }

        public Finder excludeSubs6() {
            this.exclusion = this.exclusion.equal(this.serialization.subs6Name, false, (Object)-1);
            return this;
        }

        public Finder excludeTup3() {
            this.exclusion = this.exclusion.equal(this.serialization.tup3Name, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((SillyStructureWithIdRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }

        @CheckReturnValue
        public Replacer andReplaceFirst(SillyStructureWithId document) {
            return new Replacer((SillyStructureWithIdRepository)this.repository, document, this.criteria, this.ordering);
        }
    }
}

