/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.WitherDerived;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WitherDerived", generator="Immutables")
@Immutable
public final class ImmutableWitherDerived
extends WitherDerived {
    private final int set;
    private final transient int derived;

    private ImmutableWitherDerived(int set) {
        this.set = set;
        this.derived = super.derived();
    }

    @Override
    int set() {
        return this.set;
    }

    @Override
    int derived() {
        return this.derived;
    }

    public final ImmutableWitherDerived withSet(int value) {
        if (this.set == value) {
            return this;
        }
        return new ImmutableWitherDerived(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWitherDerived && this.equalTo(0, (ImmutableWitherDerived)another);
    }

    private boolean equalTo(int synthetic, ImmutableWitherDerived another) {
        return this.set == another.set && this.derived == another.derived;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.set;
        h += (h << 5) + this.derived;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WitherDerived").omitNullValues().add("set", this.set).add("derived", this.derived).toString();
    }

    public static ImmutableWitherDerived copyOf(WitherDerived instance) {
        if (instance instanceof ImmutableWitherDerived) {
            return (ImmutableWitherDerived)instance;
        }
        return ImmutableWitherDerived.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WitherDerived", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SET = 1L;
        private long initBits = 1L;
        private int set;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WitherDerived instance) {
            Objects.requireNonNull(instance, "instance");
            this.set(instance.set());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder set(int set) {
            this.set = set;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableWitherDerived build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWitherDerived(this.set);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("set");
            }
            return "Cannot build WitherDerived, some of required attributes are not set " + attributes;
        }
    }
}

