/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javaslang.control.Option;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.Wildcards;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Wildcards", generator="Immutables")
@Immutable
public final class ImmutableWildcards
implements Wildcards {
    private final List<?> wilcards;
    private final Option<? super String> option;

    private ImmutableWildcards(List<?> wilcards, Option<? super String> option) {
        this.wilcards = wilcards;
        this.option = option;
    }

    @Override
    public List<?> wilcards() {
        return this.wilcards;
    }

    @Override
    public Option<? super String> option() {
        return this.option;
    }

    public final ImmutableWildcards withWilcards(List<?> value) {
        if (this.wilcards == value) {
            return this;
        }
        List<?> newValue = Objects.requireNonNull(value, "wilcards");
        return new ImmutableWildcards(newValue, this.option);
    }

    public final ImmutableWildcards withOption(Option<? super String> value) {
        Option<? super String> newValue = Objects.requireNonNull(value, "option");
        if (this.option.equals(newValue)) {
            return this;
        }
        return new ImmutableWildcards(this.wilcards, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWildcards && this.equalTo(0, (ImmutableWildcards)another);
    }

    private boolean equalTo(int synthetic, ImmutableWildcards another) {
        return this.wilcards.equals(another.wilcards) && this.option.equals(another.option);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.wilcards.hashCode();
        h += (h << 5) + this.option.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Wildcards").omitNullValues().add("wilcards", this.wilcards).add("option", this.option).toString();
    }

    public static ImmutableWildcards copyOf(Wildcards instance) {
        if (instance instanceof ImmutableWildcards) {
            return (ImmutableWildcards)instance;
        }
        return ImmutableWildcards.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Wildcards", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WILCARDS = 1L;
        private static final long INIT_BIT_OPTION = 2L;
        private long initBits = 3L;
        @Nullable
        private List<?> wilcards;
        @Nullable
        private Option<? super String> option;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Wildcards instance) {
            Objects.requireNonNull(instance, "instance");
            this.wilcards(instance.wilcards());
            this.option(instance.option());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wilcards(List<?> wilcards) {
            this.wilcards = Objects.requireNonNull(wilcards, "wilcards");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder option(Option<? super String> option) {
            this.option = Objects.requireNonNull(option, "option");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWildcards build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWildcards(this.wilcards, this.option);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wilcards");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("option");
            }
            return "Cannot build Wildcards, some of required attributes are not set " + attributes;
        }
    }
}

