/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyEntity;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SillyEntity", generator="Immutables")
@Immutable
public final class ImmutableSillyEntity
extends SillyEntity {
    private final int id;
    private final String val;
    private final ImmutableMap<String, Integer> payload;
    private final ImmutableList<Integer> ints;
    private final transient UnsignedInteger der;

    private ImmutableSillyEntity(int id, String val, ImmutableMap<String, Integer> payload, ImmutableList<Integer> ints) {
        this.id = id;
        this.val = val;
        this.payload = payload;
        this.ints = ints;
        this.der = Objects.requireNonNull(super.der(), "der");
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String val() {
        return this.val;
    }

    public ImmutableMap<String, Integer> payload() {
        return this.payload;
    }

    public ImmutableList<Integer> ints() {
        return this.ints;
    }

    @Override
    public UnsignedInteger der() {
        return this.der;
    }

    public final ImmutableSillyEntity withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableSillyEntity(value, this.val, this.payload, this.ints);
    }

    public final ImmutableSillyEntity withVal(String value) {
        String newValue = Objects.requireNonNull(value, "val");
        if (this.val.equals(newValue)) {
            return this;
        }
        return new ImmutableSillyEntity(this.id, newValue, this.payload, this.ints);
    }

    public final ImmutableSillyEntity withPayload(Map<String, ? extends Integer> entries) {
        if (this.payload == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSillyEntity(this.id, this.val, (ImmutableMap<String, Integer>)newValue, this.ints);
    }

    public final ImmutableSillyEntity withInts(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableSillyEntity(this.id, this.val, this.payload, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableSillyEntity withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSillyEntity(this.id, this.val, this.payload, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyEntity && this.equalTo(0, (ImmutableSillyEntity)another);
    }

    private boolean equalTo(int synthetic, ImmutableSillyEntity another) {
        return this.id == another.id && this.val.equals(another.val) && this.payload.equals(another.payload) && this.ints.equals(another.ints) && this.der.equals((Object)another.der);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id;
        h += (h << 5) + this.val.hashCode();
        h += (h << 5) + this.payload.hashCode();
        h += (h << 5) + this.ints.hashCode();
        h += (h << 5) + this.der.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyEntity").omitNullValues().add("id", this.id).add("val", (Object)this.val).add("payload", this.payload).add("ints", this.ints).add("der", (Object)this.der).toString();
    }

    public static ImmutableSillyEntity copyOf(SillyEntity instance) {
        if (instance instanceof ImmutableSillyEntity) {
            return (ImmutableSillyEntity)instance;
        }
        return ImmutableSillyEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SillyEntity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VAL = 2L;
        private long initBits = 3L;
        private int id;
        @Nullable
        private String val;
        private ImmutableMap.Builder<String, Integer> payload = ImmutableMap.builder();
        private ImmutableList.Builder<Integer> ints = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SillyEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.val(instance.val());
            this.putAllPayload(instance.payload());
            this.addAllInts(instance.ints());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder val(String val) {
            this.val = Objects.requireNonNull(val, "val");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPayload(String key, int value) {
            this.payload.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPayload(Map.Entry<String, ? extends Integer> entry) {
            this.payload.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(Map<String, ? extends Integer> entries) {
            this.payload = ImmutableMap.builder();
            return this.putAllPayload(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPayload(Map<String, ? extends Integer> entries) {
            this.payload.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int element) {
            this.ints.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int ... elements) {
            this.ints.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ints(Iterable<Integer> elements) {
            this.ints = ImmutableList.builder();
            return this.addAllInts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInts(Iterable<Integer> elements) {
            this.ints.addAll(elements);
            return this;
        }

        public ImmutableSillyEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSillyEntity(this.id, this.val, this.payload.build(), this.ints.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("val");
            }
            return "Cannot build SillyEntity, some of required attributes are not set " + attributes;
        }
    }
}

