/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.OrderAttributeValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OrderAttributeValue", generator="Immutables")
@Immutable
public final class ImmutableOrderAttributeValue
extends OrderAttributeValue {
    private final ImmutableSortedSet<Integer> natural;
    private final ImmutableSortedSet<String> reverse;
    private final ImmutableSortedMap<String, String> reverseMap;
    private final ImmutableSortedMap<Integer, String> navigableMap;
    private final ImmutableSortedMultiset<Integer> naturalMultiset;
    private final ImmutableSortedMultiset<String> reverseMultiset;

    private ImmutableOrderAttributeValue(ImmutableSortedSet<Integer> natural, ImmutableSortedSet<String> reverse, ImmutableSortedMap<String, String> reverseMap, ImmutableSortedMap<Integer, String> navigableMap, ImmutableSortedMultiset<Integer> naturalMultiset, ImmutableSortedMultiset<String> reverseMultiset) {
        this.natural = natural;
        this.reverse = reverse;
        this.reverseMap = reverseMap;
        this.navigableMap = navigableMap;
        this.naturalMultiset = naturalMultiset;
        this.reverseMultiset = reverseMultiset;
    }

    public ImmutableSortedSet<Integer> natural() {
        return this.natural;
    }

    public ImmutableSortedSet<String> reverse() {
        return this.reverse;
    }

    public ImmutableSortedMap<String, String> reverseMap() {
        return this.reverseMap;
    }

    public ImmutableSortedMap<Integer, String> navigableMap() {
        return this.navigableMap;
    }

    public ImmutableSortedMultiset<Integer> naturalMultiset() {
        return this.naturalMultiset;
    }

    public ImmutableSortedMultiset<String> reverseMultiset() {
        return this.reverseMultiset;
    }

    public final ImmutableOrderAttributeValue withNatural(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), (Collection)Ints.asList((int[])elements));
        return new ImmutableOrderAttributeValue((ImmutableSortedSet<Integer>)newValue, this.reverse, this.reverseMap, this.navigableMap, this.naturalMultiset, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withNatural(Iterable<Integer> elements) {
        if (this.natural == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableOrderAttributeValue((ImmutableSortedSet<Integer>)newValue, this.reverse, this.reverseMap, this.navigableMap, this.naturalMultiset, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withReverse(String ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), Arrays.asList(elements));
        return new ImmutableOrderAttributeValue(this.natural, (ImmutableSortedSet<String>)newValue, this.reverseMap, this.navigableMap, this.naturalMultiset, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withReverse(Iterable<String> elements) {
        if (this.reverse == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableOrderAttributeValue(this.natural, (ImmutableSortedSet<String>)newValue, this.reverseMap, this.navigableMap, this.naturalMultiset, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withReverseMap(Map<String, ? extends String> entries) {
        if (this.reverseMap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural().reverse());
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, (ImmutableSortedMap<String, String>)newValue, this.navigableMap, this.naturalMultiset, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withNavigableMap(Map<Integer, ? extends String> entries) {
        if (this.navigableMap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, (ImmutableSortedMap<Integer, String>)newValue, this.naturalMultiset, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withNaturalMultiset(int ... elements) {
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural(), (Iterable)Ints.asList((int[])elements));
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, (ImmutableSortedMultiset<Integer>)newValue, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withNaturalMultiset(Iterable<Integer> elements) {
        if (this.naturalMultiset == elements) {
            return this;
        }
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, (ImmutableSortedMultiset<Integer>)newValue, this.reverseMultiset);
    }

    public final ImmutableOrderAttributeValue withReverseMultiset(String ... elements) {
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural().reverse(), Arrays.asList(elements));
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, this.naturalMultiset, (ImmutableSortedMultiset<String>)newValue);
    }

    public final ImmutableOrderAttributeValue withReverseMultiset(Iterable<String> elements) {
        if (this.reverseMultiset == elements) {
            return this;
        }
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableOrderAttributeValue(this.natural, this.reverse, this.reverseMap, this.navigableMap, this.naturalMultiset, (ImmutableSortedMultiset<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOrderAttributeValue && this.equalTo(0, (ImmutableOrderAttributeValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableOrderAttributeValue another) {
        return this.natural.equals(another.natural) && this.reverse.equals(another.reverse) && this.reverseMap.equals(another.reverseMap) && this.navigableMap.equals(another.navigableMap) && this.naturalMultiset.equals(another.naturalMultiset) && this.reverseMultiset.equals(another.reverseMultiset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.natural.hashCode();
        h += (h << 5) + this.reverse.hashCode();
        h += (h << 5) + this.reverseMap.hashCode();
        h += (h << 5) + this.navigableMap.hashCode();
        h += (h << 5) + this.naturalMultiset.hashCode();
        h += (h << 5) + this.reverseMultiset.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OrderAttributeValue").omitNullValues().add("natural", this.natural).add("reverse", this.reverse).add("reverseMap", this.reverseMap).add("navigableMap", this.navigableMap).add("naturalMultiset", this.naturalMultiset).add("reverseMultiset", this.reverseMultiset).toString();
    }

    public static ImmutableOrderAttributeValue copyOf(OrderAttributeValue instance) {
        if (instance instanceof ImmutableOrderAttributeValue) {
            return (ImmutableOrderAttributeValue)instance;
        }
        return ImmutableOrderAttributeValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OrderAttributeValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableSortedSet.Builder<Integer> natural = ImmutableSortedSet.naturalOrder();
        private ImmutableSortedSet.Builder<String> reverse = ImmutableSortedSet.reverseOrder();
        private ImmutableSortedMap.Builder<String, String> reverseMap = ImmutableSortedMap.reverseOrder();
        private ImmutableSortedMap.Builder<Integer, String> navigableMap = ImmutableSortedMap.naturalOrder();
        private ImmutableSortedMultiset.Builder<Integer> naturalMultiset = ImmutableSortedMultiset.naturalOrder();
        private ImmutableSortedMultiset.Builder<String> reverseMultiset = ImmutableSortedMultiset.reverseOrder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OrderAttributeValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllNatural(instance.natural());
            this.addAllReverse(instance.reverse());
            this.putAllReverseMap(instance.reverseMap());
            this.putAllNavigableMap(instance.navigableMap());
            this.addAllNaturalMultiset((Iterable<Integer>)instance.naturalMultiset());
            this.addAllReverseMultiset((Iterable<String>)instance.reverseMultiset());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNatural(int element) {
            this.natural.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNatural(int ... elements) {
            this.natural.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder natural(Iterable<Integer> elements) {
            this.natural = ImmutableSortedSet.naturalOrder();
            return this.addAllNatural(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNatural(Iterable<Integer> elements) {
            this.natural.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReverse(String element) {
            this.reverse.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReverse(String ... elements) {
            this.reverse.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reverse(Iterable<String> elements) {
            this.reverse = ImmutableSortedSet.reverseOrder();
            return this.addAllReverse(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReverse(Iterable<String> elements) {
            this.reverse.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReverseMap(String key, String value) {
            this.reverseMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReverseMap(Map.Entry<String, ? extends String> entry) {
            this.reverseMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reverseMap(Map<String, ? extends String> entries) {
            this.reverseMap = ImmutableSortedMap.reverseOrder();
            return this.putAllReverseMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllReverseMap(Map<String, ? extends String> entries) {
            this.reverseMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNavigableMap(int key, String value) {
            this.navigableMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNavigableMap(Map.Entry<Integer, ? extends String> entry) {
            this.navigableMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder navigableMap(Map<Integer, ? extends String> entries) {
            this.navigableMap = ImmutableSortedMap.naturalOrder();
            return this.putAllNavigableMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNavigableMap(Map<Integer, ? extends String> entries) {
            this.navigableMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNaturalMultiset(int element) {
            this.naturalMultiset.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNaturalMultiset(int ... elements) {
            this.naturalMultiset.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder naturalMultiset(Iterable<Integer> elements) {
            this.naturalMultiset = ImmutableSortedMultiset.naturalOrder();
            return this.addAllNaturalMultiset(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNaturalMultiset(Iterable<Integer> elements) {
            this.naturalMultiset.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReverseMultiset(String element) {
            this.reverseMultiset.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReverseMultiset(String ... elements) {
            this.reverseMultiset.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reverseMultiset(Iterable<String> elements) {
            this.reverseMultiset = ImmutableSortedMultiset.reverseOrder();
            return this.addAllReverseMultiset(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReverseMultiset(Iterable<String> elements) {
            this.reverseMultiset.addAll(elements);
            return this;
        }

        public ImmutableOrderAttributeValue build() {
            return new ImmutableOrderAttributeValue(this.natural.build(), this.reverse.build(), this.reverseMap.build(), this.navigableMap.build(), this.naturalMultiset.build(), this.reverseMultiset.build());
        }
    }
}

