/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.OptionalNumber;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OptionalNumber", generator="Immutables")
@Immutable
public final class ImmutableOptionalNumber
implements OptionalNumber {
    private final Optional<BigDecimal> bigDecimal;

    private ImmutableOptionalNumber(Optional<BigDecimal> bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    @Override
    public Optional<BigDecimal> bigDecimal() {
        return this.bigDecimal;
    }

    public final ImmutableOptionalNumber withBigDecimal(BigDecimal value) {
        Optional newValue = Optional.of((Object)value);
        if (this.bigDecimal.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOptionalNumber((Optional<BigDecimal>)newValue);
    }

    public final ImmutableOptionalNumber withBigDecimal(Optional<? extends BigDecimal> optional) {
        Optional<? extends BigDecimal> value = optional;
        if (this.bigDecimal.equals(value)) {
            return this;
        }
        return new ImmutableOptionalNumber(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionalNumber && this.equalTo(0, (ImmutableOptionalNumber)another);
    }

    private boolean equalTo(int synthetic, ImmutableOptionalNumber another) {
        return this.bigDecimal.equals(another.bigDecimal);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bigDecimal.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionalNumber").omitNullValues().add("bigDecimal", this.bigDecimal.orNull()).toString();
    }

    public static ImmutableOptionalNumber copyOf(OptionalNumber instance) {
        if (instance instanceof ImmutableOptionalNumber) {
            return (ImmutableOptionalNumber)instance;
        }
        return ImmutableOptionalNumber.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OptionalNumber", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Optional<BigDecimal> bigDecimal = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OptionalNumber instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<BigDecimal> bigDecimalOptional = instance.bigDecimal();
            if (bigDecimalOptional.isPresent()) {
                this.bigDecimal(bigDecimalOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bigDecimal(BigDecimal bigDecimal) {
            this.bigDecimal = Optional.of((Object)bigDecimal);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bigDecimal(Optional<? extends BigDecimal> bigDecimal) {
            this.bigDecimal = bigDecimal;
            return this;
        }

        public ImmutableOptionalNumber build() {
            return new ImmutableOptionalNumber(this.bigDecimal);
        }
    }
}

