/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.OptionalCast;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OptionalCast", generator="Immutables")
@Immutable
public final class ImmutableOptionalCast
implements OptionalCast {
    private final Optional<String> bar;
    private final Optional<Object> object;
    private final Optional<String[]> stringArray;
    private final Optional<List<Long>> list;

    private ImmutableOptionalCast(Optional<String> bar, Optional<? extends Object> object, Optional<? extends String[]> stringArray, Optional<? extends List<Long>> list) {
        this.bar = bar;
        this.object = object;
        this.stringArray = stringArray;
        this.list = list;
    }

    private ImmutableOptionalCast(ImmutableOptionalCast original, Optional<String> bar, Optional<Object> object, Optional<String[]> stringArray, Optional<List<Long>> list) {
        this.bar = bar;
        this.object = object;
        this.stringArray = stringArray;
        this.list = list;
    }

    @Override
    public Optional<String> getBar() {
        return this.bar;
    }

    @Override
    public Optional<Object> getObject() {
        return this.object;
    }

    @Override
    public Optional<String[]> getStringArray() {
        return this.stringArray;
    }

    @Override
    public Optional<List<Long>> getList() {
        return this.list;
    }

    public final ImmutableOptionalCast withBar(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.bar.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOptionalCast(this, (Optional<String>)newValue, this.object, this.stringArray, this.list);
    }

    public final ImmutableOptionalCast withBar(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.bar.equals(value)) {
            return this;
        }
        return new ImmutableOptionalCast(this, value, this.object, this.stringArray, this.list);
    }

    public final ImmutableOptionalCast withObject(Object value) {
        Optional newValue = Optional.of((Object)value);
        if (this.object.isPresent() && this.object.get() == value) {
            return this;
        }
        return new ImmutableOptionalCast(this, this.bar, (Optional<Object>)newValue, this.stringArray, this.list);
    }

    public final ImmutableOptionalCast withObject(Optional<? extends Object> optional) {
        Optional<? extends Object> value = optional;
        if (!this.object.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.object.isPresent() && value.isPresent() && this.object.get() == value.get()) {
            return this;
        }
        return new ImmutableOptionalCast(this, this.bar, value, this.stringArray, this.list);
    }

    public final ImmutableOptionalCast withStringArray(String[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.stringArray.isPresent() && this.stringArray.get() == value) {
            return this;
        }
        return new ImmutableOptionalCast(this, this.bar, this.object, (Optional<String[]>)newValue, this.list);
    }

    public final ImmutableOptionalCast withStringArray(Optional<? extends String[]> optional) {
        Optional<? extends String[]> value = optional;
        if (!this.stringArray.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.stringArray.isPresent() && value.isPresent() && this.stringArray.get() == value.get()) {
            return this;
        }
        return new ImmutableOptionalCast(this, this.bar, this.object, value, this.list);
    }

    public final ImmutableOptionalCast withList(List<Long> value) {
        Optional newValue = Optional.of(value);
        if (this.list.isPresent() && this.list.get() == value) {
            return this;
        }
        return new ImmutableOptionalCast(this, this.bar, this.object, this.stringArray, (Optional<List<Long>>)newValue);
    }

    public final ImmutableOptionalCast withList(Optional<? extends List<Long>> optional) {
        Optional<? extends List<Long>> value = optional;
        if (!this.list.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.list.isPresent() && value.isPresent() && this.list.get() == value.get()) {
            return this;
        }
        return new ImmutableOptionalCast(this, this.bar, this.object, this.stringArray, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionalCast && this.equalTo(0, (ImmutableOptionalCast)another);
    }

    private boolean equalTo(int synthetic, ImmutableOptionalCast another) {
        return this.bar.equals(another.bar) && this.object.equals(another.object) && this.stringArray.equals(another.stringArray) && this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bar.hashCode();
        h += (h << 5) + this.object.hashCode();
        h += (h << 5) + this.stringArray.hashCode();
        h += (h << 5) + this.list.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionalCast").omitNullValues().add("bar", this.bar.orNull()).add("object", this.object.orNull()).add("stringArray", this.stringArray.orNull()).add("list", this.list.orNull()).toString();
    }

    public static ImmutableOptionalCast of(Optional<String> bar, Optional<? extends Object> object, Optional<? extends String[]> stringArray, Optional<? extends List<Long>> list) {
        return new ImmutableOptionalCast(bar, object, stringArray, list);
    }

    public static ImmutableOptionalCast copyOf(OptionalCast instance) {
        if (instance instanceof ImmutableOptionalCast) {
            return (ImmutableOptionalCast)instance;
        }
        return ImmutableOptionalCast.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OptionalCast", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Optional<String> bar = Optional.absent();
        private Optional<Object> object = Optional.absent();
        private Optional<String[]> stringArray = Optional.absent();
        private Optional<List<Long>> list = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OptionalCast instance) {
            Optional<List<Long>> listOptional;
            Optional<String[]> stringArrayOptional;
            Optional<Object> objectOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> barOptional = instance.getBar();
            if (barOptional.isPresent()) {
                this.bar(barOptional);
            }
            if ((objectOptional = instance.getObject()).isPresent()) {
                this.object(objectOptional);
            }
            if ((stringArrayOptional = instance.getStringArray()).isPresent()) {
                this.stringArray(stringArrayOptional);
            }
            if ((listOptional = instance.getList()).isPresent()) {
                this.list(listOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bar(String bar) {
            this.bar = Optional.of((Object)bar);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bar(Optional<String> bar) {
            this.bar = bar;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(Object object) {
            this.object = Optional.of((Object)object);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(Optional<? extends Object> object) {
            this.object = object;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stringArray(String[] stringArray) {
            this.stringArray = Optional.of((Object)stringArray);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stringArray(Optional<? extends String[]> stringArray) {
            this.stringArray = stringArray;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder list(List<Long> list) {
            this.list = Optional.of(list);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder list(Optional<? extends List<Long>> list) {
            this.list = list;
            return this;
        }

        public ImmutableOptionalCast build() {
            return new ImmutableOptionalCast(null, this.bar, this.object, this.stringArray, this.list);
        }
    }
}

