/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.JavadocDeprecation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JavadocDeprecation", generator="Immutables")
@Immutable
public final class ImmutableJavadocDeprecation
implements JavadocDeprecation {
    private final String attr;
    private final ImmutableSet<RetentionPolicy> pols;

    private ImmutableJavadocDeprecation(String attr, ImmutableSet<RetentionPolicy> pols) {
        this.attr = attr;
        this.pols = pols;
    }

    @Override
    @Deprecated
    public String attr() {
        return this.attr;
    }

    @Deprecated
    public ImmutableSet<RetentionPolicy> pols() {
        return this.pols;
    }

    @Deprecated
    public final ImmutableJavadocDeprecation withAttr(String value) {
        String newValue = Objects.requireNonNull(value, "attr");
        if (this.attr.equals(newValue)) {
            return this;
        }
        return new ImmutableJavadocDeprecation(newValue, this.pols);
    }

    @Deprecated
    public final ImmutableJavadocDeprecation withPols(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableJavadocDeprecation(this.attr, (ImmutableSet<RetentionPolicy>)newValue);
    }

    @Deprecated
    public final ImmutableJavadocDeprecation withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableJavadocDeprecation(this.attr, (ImmutableSet<RetentionPolicy>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJavadocDeprecation && this.equalTo(0, (ImmutableJavadocDeprecation)another);
    }

    private boolean equalTo(int synthetic, ImmutableJavadocDeprecation another) {
        return this.attr.equals(another.attr) && this.pols.equals(another.pols);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attr.hashCode();
        h += (h << 5) + this.pols.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JavadocDeprecation").omitNullValues().add("attr", (Object)this.attr).add("pols", this.pols).toString();
    }

    public static ImmutableJavadocDeprecation copyOf(JavadocDeprecation instance) {
        if (instance instanceof ImmutableJavadocDeprecation) {
            return (ImmutableJavadocDeprecation)instance;
        }
        return ImmutableJavadocDeprecation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JavadocDeprecation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ATTR = 1L;
        private long initBits = 1L;
        @Nullable
        private String attr;
        private ImmutableSet.Builder<RetentionPolicy> pols = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JavadocDeprecation instance) {
            Objects.requireNonNull(instance, "instance");
            this.attr(instance.attr());
            this.addAllPols(instance.pols());
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder attr(String attr) {
            this.attr = Objects.requireNonNull(attr, "attr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addPols(RetentionPolicy element) {
            this.pols.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addPols(RetentionPolicy ... elements) {
            this.pols.addAll(Arrays.asList(elements));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.pols = ImmutableSet.builder();
            return this.addAllPols(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            this.pols.addAll(elements);
            return this;
        }

        public ImmutableJavadocDeprecation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJavadocDeprecation(this.attr, Sets.immutableEnumSet((Iterable)this.pols.build()));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attr");
            }
            return "Cannot build JavadocDeprecation, some of required attributes are not set " + attributes;
        }
    }
}

