/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.BuildFromCovariants;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BuildFromCovariants.ItemSimple", generator="Immutables")
@Immutable
final class ImmutableItemSimple
extends BuildFromCovariants.ItemSimple {
    private final Integer id;
    private final String uid;

    private ImmutableItemSimple(Integer id, String uid) {
        this.id = id;
        this.uid = uid;
    }

    @Override
    public Integer id() {
        return this.id;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public final ImmutableItemSimple withId(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableItemSimple(newValue, this.uid);
    }

    public final ImmutableItemSimple withUid(String value) {
        String newValue = Objects.requireNonNull(value, "uid");
        if (this.uid.equals(newValue)) {
            return this;
        }
        return new ImmutableItemSimple(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItemSimple && this.equalTo(0, (ImmutableItemSimple)another);
    }

    private boolean equalTo(int synthetic, ImmutableItemSimple another) {
        return this.id.equals(another.id) && this.uid.equals(another.uid);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.uid.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ItemSimple").omitNullValues().add("id", (Object)this.id).add("uid", (Object)this.uid).toString();
    }

    public static ImmutableItemSimple copyOf(BuildFromCovariants.ItemSimple instance) {
        if (instance instanceof ImmutableItemSimple) {
            return (ImmutableItemSimple)instance;
        }
        return ImmutableItemSimple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BuildFromCovariants.ItemSimple", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_UID = 2L;
        private long initBits = 3L;
        @Nullable
        private Integer id;
        @Nullable
        private String uid;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BuildFromCovariants.Item instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BuildFromCovariants.ItemSimple instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BuildFromCovariants.Item instance;
            long bits = 0L;
            if (object instanceof BuildFromCovariants.Item) {
                instance = (BuildFromCovariants.Item)object;
                if ((bits & 1L) == 0L) {
                    this.uid(instance.uid());
                    bits |= 1L;
                }
            }
            if (object instanceof BuildFromCovariants.ItemSimple) {
                instance = (BuildFromCovariants.ItemSimple)object;
                if ((bits & 1L) == 0L) {
                    this.uid(instance.uid());
                    bits |= 1L;
                }
                this.id((Integer)instance.id());
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(Integer id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uid(String uid) {
            this.uid = Objects.requireNonNull(uid, "uid");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableItemSimple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItemSimple(this.id, this.uid);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("uid");
            }
            return "Cannot build ItemSimple, some of required attributes are not set " + attributes;
        }
    }
}

