/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.DerivedNotInConstructor;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DerivedNotInConstructor", generator="Immutables")
@Immutable
public final class ImmutableDerivedNotInConstructor
extends DerivedNotInConstructor {
    private final ImmutableList<String> items;
    private final transient int totalLength;

    private ImmutableDerivedNotInConstructor(Iterable<String> items) {
        this.items = ImmutableList.copyOf(items);
        this.totalLength = super.totalLength();
    }

    private ImmutableDerivedNotInConstructor(ImmutableDerivedNotInConstructor original, ImmutableList<String> items) {
        this.items = items;
        this.totalLength = super.totalLength();
    }

    public ImmutableList<String> items() {
        return this.items;
    }

    @Override
    public int totalLength() {
        return this.totalLength;
    }

    public final ImmutableDerivedNotInConstructor withItems(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDerivedNotInConstructor(this, (ImmutableList<String>)newValue);
    }

    public final ImmutableDerivedNotInConstructor withItems(Iterable<String> elements) {
        if (this.items == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDerivedNotInConstructor(this, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDerivedNotInConstructor && this.equalTo(0, (ImmutableDerivedNotInConstructor)another);
    }

    private boolean equalTo(int synthetic, ImmutableDerivedNotInConstructor another) {
        return this.items.equals(another.items) && this.totalLength == another.totalLength;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.items.hashCode();
        h += (h << 5) + this.totalLength;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DerivedNotInConstructor").omitNullValues().add("items", this.items).add("totalLength", this.totalLength).toString();
    }

    public static ImmutableDerivedNotInConstructor of(List<String> items) {
        return ImmutableDerivedNotInConstructor.of(items);
    }

    public static ImmutableDerivedNotInConstructor of(Iterable<String> items) {
        return new ImmutableDerivedNotInConstructor(items);
    }

    public static ImmutableDerivedNotInConstructor copyOf(DerivedNotInConstructor instance) {
        if (instance instanceof ImmutableDerivedNotInConstructor) {
            return (ImmutableDerivedNotInConstructor)instance;
        }
        return ImmutableDerivedNotInConstructor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DerivedNotInConstructor", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> items = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DerivedNotInConstructor instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllItems(instance.items());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(String element) {
            this.items.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(String ... elements) {
            this.items.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder items(Iterable<String> elements) {
            this.items = ImmutableList.builder();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<String> elements) {
            this.items.addAll(elements);
            return this;
        }

        public ImmutableDerivedNotInConstructor build() {
            return new ImmutableDerivedNotInConstructor(null, this.items.build());
        }
    }
}

