/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyStructure;
import org.immutables.fixture.SillyStructure;
import org.immutables.fixture.SillyTuplie;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture", generator="Gsons")
public final class GsonAdaptersSillyStructure
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyStructureTypeAdapter.adapts(type)) {
            return new SillyStructureTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyStructure(SillyStructure)";
    }

    @Generated(from="SillyStructure", generator="Gsons")
    private static class SillyStructureTypeAdapter
    extends TypeAdapter<SillyStructure> {
        public final Integer opt3TypeSample = null;
        public final SillySubstructure subs6TypeSample = null;
        public final SillySubstructure nest7TypeSample = null;
        public final SillyTuplie tup3TypeSample = null;
        private final TypeAdapter<Integer> opt3TypeAdapter;
        private final TypeAdapter<SillySubstructure> subs6TypeAdapter;
        private final TypeAdapter<SillySubstructure> nest7TypeAdapter;
        private final TypeAdapter<SillyTuplie> tup3TypeAdapter;

        SillyStructureTypeAdapter(Gson gson) {
            this.opt3TypeAdapter = gson.getAdapter(Integer.class);
            this.subs6TypeAdapter = gson.getAdapter(SillySubstructure.class);
            this.nest7TypeAdapter = gson.getAdapter(SillySubstructure.class);
            this.tup3TypeAdapter = gson.getAdapter(SillyTuplie.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return SillyStructure.class == type.getRawType() || ImmutableSillyStructure.class == type.getRawType();
        }

        public void write(JsonWriter out, SillyStructure value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyStructure(out, value);
            }
        }

        public SillyStructure read(JsonReader in) throws IOException {
            return this.readSillyStructure(in);
        }

        private void writeSillyStructure(JsonWriter out, SillyStructure instance) throws IOException {
            out.beginObject();
            out.name("attr1");
            out.value(instance.attr1());
            out.name("flag2");
            out.value(instance.flag2());
            Optional<Integer> opt3Optional = instance.opt3();
            if (opt3Optional.isPresent()) {
                out.name("opt3");
                Integer opt3Value = (Integer)opt3Optional.get();
                this.opt3TypeAdapter.write(out, (Object)opt3Value);
            } else if (out.getSerializeNulls()) {
                out.name("opt3");
                out.nullValue();
            }
            out.name("very4");
            out.value(instance.very4());
            out.name("wet5");
            out.value(instance.wet5());
            List<SillySubstructure> subs6Elements = instance.subs6();
            out.name("subs6");
            out.beginArray();
            for (SillySubstructure e : subs6Elements) {
                this.subs6TypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("nest7");
            this.nest7TypeAdapter.write(out, (Object)instance.nest7());
            Optional<SillyTuplie> tup3Optional = instance.tup3();
            if (tup3Optional.isPresent()) {
                out.name("tup3");
                SillyTuplie tup3Value = (SillyTuplie)tup3Optional.get();
                this.tup3TypeAdapter.write(out, (Object)tup3Value);
            } else if (out.getSerializeNulls()) {
                out.name("tup3");
                out.nullValue();
            }
            out.name("int9");
            out.value((long)instance.int9());
            out.endObject();
        }

        private SillyStructure readSillyStructure(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableSillyStructure.Builder builder = ImmutableSillyStructure.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if (!"attr1".equals(attributeName)) break;
                    this.readInAttr1(in, builder);
                    return;
                }
                case 'f': {
                    if (!"flag2".equals(attributeName)) break;
                    this.readInFlag2(in, builder);
                    return;
                }
                case 'o': {
                    if (!"opt3".equals(attributeName)) break;
                    this.readInOpt3(in, builder);
                    return;
                }
                case 'v': {
                    if (!"very4".equals(attributeName)) break;
                    this.readInVery4(in, builder);
                    return;
                }
                case 'w': {
                    if (!"wet5".equals(attributeName)) break;
                    this.readInWet5(in, builder);
                    return;
                }
                case 's': {
                    if (!"subs6".equals(attributeName)) break;
                    this.readInSubs6(in, builder);
                    return;
                }
                case 'n': {
                    if (!"nest7".equals(attributeName)) break;
                    this.readInNest7(in, builder);
                    return;
                }
                case 't': {
                    if (!"tup3".equals(attributeName)) break;
                    this.readInTup3(in, builder);
                    return;
                }
                case 'i': {
                    if (!"int9".equals(attributeName)) break;
                    this.readInInt9(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInAttr1(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            builder.attr1(in.nextString());
        }

        private void readInFlag2(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            builder.flag2(in.nextBoolean());
        }

        private void readInOpt3(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.opt3TypeAdapter.read(in);
                builder.opt3(value);
            }
        }

        private void readInVery4(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            builder.very4(in.nextLong());
        }

        private void readInWet5(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            builder.wet5(in.nextDouble());
        }

        private void readInSubs6(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    SillySubstructure value = (SillySubstructure)this.subs6TypeAdapter.read(in);
                    builder.addSubs6(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                SillySubstructure value = (SillySubstructure)this.subs6TypeAdapter.read(in);
                builder.addSubs6(value);
            }
        }

        private void readInNest7(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            SillySubstructure value = (SillySubstructure)this.nest7TypeAdapter.read(in);
            builder.nest7(value);
        }

        private void readInTup3(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                SillyTuplie value = (SillyTuplie)this.tup3TypeAdapter.read(in);
                builder.tup3(value);
            }
        }

        private void readInInt9(JsonReader in, ImmutableSillyStructure.Builder builder) throws IOException {
            builder.int9(in.nextInt());
        }
    }
}

