package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Copied}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new Copied.Builder()}.
 */
@Generated(from = "Copied", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableCopied extends Copied {
  private final int attr;
  private final @Nullable Void voids;
  private final String[] arr;
  private final ImmutableMap<String, Integer> map;
  private final ImmutableList<Boolean> list;

  private ImmutableCopied(
      int attr,
      @Nullable Void voids,
      String[] arr,
      ImmutableMap<String, Integer> map,
      ImmutableList<Boolean> list) {
    this.attr = attr;
    this.voids = voids;
    this.arr = arr;
    this.map = map;
    this.list = list;
  }

  /**
   * @return The value of the {@code attr} attribute
   */
  @Override
  public int attr() {
    return attr;
  }

  /**
   * @return The value of the {@code voids} attribute
   */
  @Override
  public @Nullable Void voids() {
    return voids;
  }

  /**
   * @return A cloned {@code arr} array
   */
  @Override
  public String[] arr() {
    return arr.clone();
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public ImmutableMap<String, Integer> map() {
    return map;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public ImmutableList<Boolean> list() {
    return list;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Copied#attr() attr} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopied withAttr(int value) {
    if (this.attr == value) return this;
    return new ImmutableCopied(value, this.voids, this.arr, this.map, this.list);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Copied#voids() voids} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for voids (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopied withVoids(@Nullable Void value) {
    if (this.voids == value) return this;
    return new ImmutableCopied(this.attr, value, this.arr, this.map, this.list);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Copied#arr() arr}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arr
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCopied withArr(String... elements) {
    String[] newValue = elements.clone();
    return new ImmutableCopied(this.attr, this.voids, newValue, this.map, this.list);
  }

  /**
   * Copy the current immutable object by replacing the {@link Copied#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCopied withMap(Map<String, ? extends Integer> entries) {
    if (this.map == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCopied(this.attr, this.voids, this.arr, newValue, this.list);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Copied#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCopied withList(boolean... elements) {
    ImmutableList<Boolean> newValue = ImmutableList.copyOf(Booleans.asList(elements));
    return new ImmutableCopied(this.attr, this.voids, this.arr, this.map, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Copied#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCopied withList(Iterable<Boolean> elements) {
    if (this.list == elements) return this;
    ImmutableList<Boolean> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCopied(this.attr, this.voids, this.arr, this.map, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCopied} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCopied
        && equalTo(0, (ImmutableCopied) another);
  }

  private boolean equalTo(int synthetic, ImmutableCopied another) {
    return attr == another.attr
        && Objects.equals(voids, another.voids)
        && Arrays.equals(arr, another.arr)
        && map.equals(another.map)
        && list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code attr}, {@code voids}, {@code arr}, {@code map}, {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + attr;
    h += (h << 5) + Objects.hashCode(voids);
    h += (h << 5) + Arrays.hashCode(arr);
    h += (h << 5) + map.hashCode();
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Copied} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Copied")
        .omitNullValues()
        .add("attr", attr)
        .add("voids", voids)
        .add("arr", Arrays.toString(arr))
        .add("map", map)
        .add("list", list)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Copied} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Copied instance
   */
  public static ImmutableCopied copyOf(Copied instance) {
    if (instance instanceof ImmutableCopied) {
      return (ImmutableCopied) instance;
    }
    return new Copied.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCopied ImmutableCopied}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Copied", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_ATTR = 0x1L;
    private static final long INIT_BIT_ARR = 0x2L;
    private long initBits = 0x3L;

    private int attr;
    private @Nullable Void voids;
    private @Nullable String[] arr;
    private ImmutableMap.Builder<String, Integer> map = ImmutableMap.builder();
    private ImmutableList.Builder<Boolean> list = ImmutableList.builder();

    /**
     * Creates a builder for {@link ImmutableCopied ImmutableCopied} instances.
     * <pre>
     * new Copied.Builder()
     *    .attr(int) // required {@link Copied#attr() attr}
     *    .voids(Void | null) // nullable {@link Copied#voids() voids}
     *    .arr(String) // required {@link Copied#arr() arr}
     *    .putMap|putAllMap(String =&gt; int) // {@link Copied#map() map} mappings
     *    .addList|addAllList(boolean) // {@link Copied#list() list} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof Copied.Builder)) {
        throw new UnsupportedOperationException("Use: new Copied.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code Copied} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder from(Copied instance) {
      Objects.requireNonNull(instance, "instance");
      attr(instance.attr());
      @Nullable Void voidsValue = instance.voids();
      if (voidsValue != null) {
        voids(voidsValue);
      }
      arr(instance.arr());
      putAllMap(instance.map());
      addAllList(instance.list());
      return (Copied.Builder) this;
    }

    /**
     * Initializes the value for the {@link Copied#attr() attr} attribute.
     * @param attr The value for attr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder attr(int attr) {
      this.attr = attr;
      initBits &= ~INIT_BIT_ATTR;
      return (Copied.Builder) this;
    }

    /**
     * Initializes the value for the {@link Copied#voids() voids} attribute.
     * @param voids The value for voids (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder voids(@Nullable Void voids) {
      this.voids = voids;
      return (Copied.Builder) this;
    }

    /**
     * Initializes the value for the {@link Copied#arr() arr} attribute.
     * @param arr The elements for arr
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder arr(String... arr) {
      this.arr = arr.clone();
      initBits &= ~INIT_BIT_ARR;
      return (Copied.Builder) this;
    }

    /**
     * Put one entry to the {@link Copied#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder putMap(String key, int value) {
      this.map.put(key, value);
      return (Copied.Builder) this;
    }

    /**
     * Put one entry to the {@link Copied#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder putMap(Map.Entry<String, ? extends Integer> entry) {
      this.map.put(entry);
      return (Copied.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Copied#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder map(Map<String, ? extends Integer> entries) {
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Copied#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder putAllMap(Map<String, ? extends Integer> entries) {
      this.map.putAll(entries);
      return (Copied.Builder) this;
    }

    /**
     * Adds one element to {@link Copied#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder addList(boolean element) {
      this.list.add(element);
      return (Copied.Builder) this;
    }

    /**
     * Adds elements to {@link Copied#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder addList(boolean... elements) {
      this.list.addAll(Booleans.asList(elements));
      return (Copied.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link Copied#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder list(Iterable<Boolean> elements) {
      this.list = ImmutableList.builder();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link Copied#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Copied.Builder addAllList(Iterable<Boolean> elements) {
      this.list.addAll(elements);
      return (Copied.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCopied ImmutableCopied}.
     * @return An immutable instance of Copied
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCopied build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCopied(attr, voids, arr, map.build(), list.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ATTR) != 0) attributes.add("attr");
      if ((initBits & INIT_BIT_ARR) != 0) attributes.add("arr");
      return "Cannot build Copied, some of required attributes are not set " + attributes;
    }
  }
}
