package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link OutsideBuildable OutsideBuildable}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code OutsideBuildableBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "OutsideBuildable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class OutsideBuildableBuilder {

  /**
   * Creates a builder for {@link OutsideBuildable OutsideBuildable} instances.
   * <pre>
   * new OutsideBuildableBuilder()
   *    .build();
   * </pre>
   */
  public OutsideBuildableBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code OutsideBuildable} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final OutsideBuildableBuilder from(OutsideBuildable instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }

  /**
   * Builds a new {@link OutsideBuildable OutsideBuildable}.
   * @return An immutable instance of OutsideBuildable
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public OutsideBuildable build() {
    return new OutsideBuildableBuilder.ImmutableOutsideBuildable(this);
  }

  /**
   * Immutable implementation of {@link OutsideBuildable}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new OutsideBuildableBuilder()}.
   */
  @Generated(from = "OutsideBuildable", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class ImmutableOutsideBuildable extends OutsideBuildable {

    private ImmutableOutsideBuildable(OutsideBuildableBuilder builder) {
    }

    /**
     * This instance is equal to all instances of {@code ImmutableOutsideBuildable} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof OutsideBuildableBuilder.ImmutableOutsideBuildable
          && equalTo(0, (OutsideBuildableBuilder.ImmutableOutsideBuildable) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, OutsideBuildableBuilder.ImmutableOutsideBuildable another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return -363078441;
    }

    /**
     * Prints the immutable value {@code OutsideBuildable}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "OutsideBuildable{}";
    }
  }
}
