package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link UnderrideObjectMethods.StaticUnderride StaticUnderride} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableStaticUnderride is not thread-safe</em>
 * @see ImmutableStaticUnderride
 */
@Generated(from = "UnderrideObjectMethods.StaticUnderride", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "UnderrideObjectMethods.StaticUnderride"})
@NotThreadSafe
public final class ModifiableStaticUnderride
    implements UnderrideObjectMethods.StaticUnderride {

  private ModifiableStaticUnderride() {}

  /**
   * Construct a modifiable instance of {@code StaticUnderride}.
   * @return A new modifiable instance
   */
  public static ModifiableStaticUnderride create() {
    return new ModifiableStaticUnderride();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableStaticUnderride clear() {
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link UnderrideObjectMethods.StaticUnderride} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableStaticUnderride from(UnderrideObjectMethods.StaticUnderride instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableStaticUnderride) {
      from((ModifiableStaticUnderride) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link UnderrideObjectMethods.StaticUnderride} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableStaticUnderride from(ModifiableStaticUnderride instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableStaticUnderride ImmutableStaticUnderride}.
   * @return An immutable instance of StaticUnderride
   */
  public final ImmutableStaticUnderride toImmutable() {
    return ImmutableStaticUnderride.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableStaticUnderride} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableStaticUnderride)) return false;
    ModifiableStaticUnderride other = (ModifiableStaticUnderride) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableStaticUnderride another) {
    return UnderrideObjectMethods.StaticUnderride.equalTo(this, another);
  }

  public final int hashCode() {
    if (!isInitialized()) return -2100186901;
    return UnderrideObjectMethods.StaticUnderride.hash(this);
  }

  /**
  * Prints the immutable value {@code StaticUnderride} delegating to a customized method.
  * @return A string representation of the value
  */
  @Override
  public String toString() {
    return UnderrideObjectMethods.StaticUnderride.stringify(this);
  }
}
