package org.immutables.fixture.style;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link PostData PostData} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiablePostData is not thread-safe</em>
 * @see ImmutablePostData
 */
@Generated(from = "PostData", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "PostData"})
@NotThreadSafe
public final class ModifiablePostData implements PostData {
  private boolean loginAllowed;

  private ModifiablePostData() {}

  /**
   * Construct a modifiable instance of {@code PostData}.
   * @return A new modifiable instance
   */
  public static ModifiablePostData create() {
    return new ModifiablePostData();
  }

  /**
   * @return value of {@code loginAllowed} attribute
   */
  @JsonProperty("login_allowed")
  @Override
  public final boolean isLoginAllowed() {
    return loginAllowed;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiablePostData clear() {
    loginAllowed = false;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link PostData} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiablePostData from(PostData instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiablePostData) {
      from((ModifiablePostData) instance);
      return this;
    }
    setLoginAllowed(instance.isLoginAllowed());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link PostData} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiablePostData from(ModifiablePostData instance) {
    Objects.requireNonNull(instance, "instance");
    setLoginAllowed(instance.isLoginAllowed());
    return this;
  }

  /**
   * Assigns a value to the {@link PostData#isLoginAllowed() loginAllowed} attribute.
   * @param loginAllowed The value for loginAllowed
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiablePostData setLoginAllowed(boolean loginAllowed) {
    this.loginAllowed = loginAllowed;
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutablePostData ImmutablePostData}.
   * @return An immutable instance of PostData
   */
  public final ImmutablePostData toImmutable() {
    return ImmutablePostData.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiablePostData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiablePostData)) return false;
    ModifiablePostData other = (ModifiablePostData) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiablePostData another) {
    return loginAllowed == another.loginAllowed;
  }

  /**
   * Computes a hash code from attributes: {@code loginAllowed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Booleans.hashCode(loginAllowed);
    return h;
  }

  /**
   * Generates a string representation of this {@code PostData}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiablePostData")
        .add("loginAllowed", isLoginAllowed())
        .toString();
  }
}
